/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class FullScreenAction
extends AbstractCyAction {
    private static final long serialVersionUID = 2987814408730103803L;
    private static final String MENU_NAME = "Full Screen Mode";
    protected final CySwingApplication desktop;
    protected boolean inFullScreenMode;
    private Rectangle lastBounds;

    public FullScreenAction(CySwingApplication desktop) {
        this(desktop, MENU_NAME);
    }

    public FullScreenAction(CySwingApplication desktop, String menuName) {
        super(menuName);
        this.setPreferredMenu("View");
        this.setMenuGravity(5.1f);
        this.useCheckBoxMenuItem = true;
        this.desktop = desktop;
        KeyStroke ks = LookAndFeelUtil.isMac() ? KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 128) : KeyStroke.getKeyStroke(122, 0);
        this.setAcceleratorKeyStroke(ks);
    }

    public void actionPerformed(ActionEvent arg0) {
        this.toggle();
        this.inFullScreenMode = !this.inFullScreenMode;
    }

    protected void toggle() {
        JFrame frame = this.desktop.getJFrame();
        if (!this.inFullScreenMode) {
            this.lastBounds = frame.getBounds();
        }
        if (!LookAndFeelUtil.isMac()) {
            frame.dispose();
            if (this.inFullScreenMode) {
                frame.setUndecorated(false);
                frame.setBounds(this.lastBounds);
                frame.setExtendedState(0);
                frame.setVisible(true);
            } else {
                frame.setUndecorated(true);
                frame.setExtendedState(6);
                frame.setVisible(true);
            }
        }
    }
}

