/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.MenuEvent;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.internal.view.CytoPanelImpl;
import org.cytoscape.internal.view.CytoPanelNameInternal;
import org.cytoscape.internal.view.CytoPanelStateInternal;
import org.cytoscape.internal.view.CytoscapeDesktop;

public class CytoPanelAction
extends AbstractCyAction {
    private final CytoPanelNameInternal position;
    private final CytoscapeDesktop desktop;

    public CytoPanelAction(CytoPanelNameInternal position, CytoscapeDesktop desktop, float menuGravity) {
        super("Show " + position.getTitle());
        this.position = position;
        this.desktop = desktop;
        this.setPreferredMenu("View");
        this.setMenuGravity(menuGravity);
        this.useCheckBoxMenuItem = true;
    }

    public void actionPerformed(ActionEvent evt) {
        CytoPanelImpl cytoPanel = (CytoPanelImpl)this.desktop.getCytoPanel(this.position);
        CytoPanelStateInternal state = cytoPanel.getStateInternal();
        CytoPanelStateInternal newState = state == CytoPanelStateInternal.HIDE ? (cytoPanel.getCytoPanelNameInternal() == CytoPanelNameInternal.BOTTOM ? CytoPanelStateInternal.UNDOCK : CytoPanelStateInternal.DOCK) : CytoPanelStateInternal.HIDE;
        cytoPanel.setStateInternal(newState);
    }

    public void menuSelected(MenuEvent evt) {
        this.updateEnableState();
        CytoPanel cytoPanel = this.desktop.getCytoPanel(this.position);
        boolean select = cytoPanel.getCytoPanelComponentCount() > 0 && ((CytoPanelImpl)cytoPanel).getStateInternal() != CytoPanelStateInternal.HIDE;
        this.putValue("SwingSelectedKey", select);
    }

    public void updateEnableState() {
        CytoPanel cytoPanel = this.desktop.getCytoPanel(this.position);
        this.setEnabled(cytoPanel instanceof CytoPanelImpl && cytoPanel.getThisComponent() != null && cytoPanel.getCytoPanelComponentCount() > 0);
    }
}

