/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.PopupMenuEvent;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.create.CreateNetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.swing.DialogTaskManager;

public class CreateNetworkViewsAction
extends AbstractCyAction {
    private final CyServiceRegistrar serviceRegistrar;

    public CreateNetworkViewsAction(float menuGravity, CyServiceRegistrar serviceRegistrar) {
        super("Create Views");
        this.serviceRegistrar = serviceRegistrar;
        this.setMenuGravity(menuGravity);
    }

    public void actionPerformed(ActionEvent e) {
        List networks = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getSelectedNetworks();
        if (!networks.isEmpty()) {
            CreateNetworkViewTaskFactory factory = (CreateNetworkViewTaskFactory)this.serviceRegistrar.getService(CreateNetworkViewTaskFactory.class);
            DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
            taskManager.execute(factory.createTaskIterator((Collection)networks));
        }
    }

    public void updateEnableState() {
        List networks = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getSelectedNetworks();
        ArrayList<CyNetwork> networksWithoutViews = new ArrayList<CyNetwork>();
        CyNetworkViewManager netViewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        for (CyNetwork n : networks) {
            if (netViewManager.viewExists(n)) continue;
            networksWithoutViews.add(n);
        }
        int count = networksWithoutViews.size();
        if (count > 0) {
            this.setName("Create " + count + " View" + (count == 1 ? "" : "s"));
        } else {
            this.setName("Create Views");
        }
        this.setEnabled(count > 0);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.updateEnableState();
    }
}

