/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.internal.view.NetworkViewFrame;
import org.cytoscape.internal.view.NetworkViewMediator;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class CloseWindowAction
extends AbstractCyAction {
    private final NetworkViewMediator netViewMediator;

    public CloseWindowAction(float menuGravity, NetworkViewMediator netViewMediator) {
        super("Close Window");
        this.netViewMediator = netViewMediator;
        this.setPreferredMenu("View");
        this.setMenuGravity(7.5f);
        int CTRL = LookAndFeelUtil.isMac() ? 256 : 128;
        this.setAcceleratorKeyStroke(KeyStroke.getKeyStroke(87, CTRL));
    }

    public void actionPerformed(ActionEvent e) {
        Window window = this.getActiveWindows();
        if (window != null && window instanceof NetworkViewFrame) {
            this.netViewMediator.reattachNetworkView(((NetworkViewFrame)window).getNetworkView());
        }
    }

    public boolean isEnabled() {
        Window window = this.getActiveWindows();
        return super.isEnabled() && window != null && window instanceof NetworkViewFrame;
    }

    private Window getActiveWindows() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return keyboardFocusManager.getActiveWindow();
    }
}

