/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.UIManager;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.CyShutdownListener;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.application.swing.CyColumnPresentation;
import org.cytoscape.application.swing.CyColumnPresentationManager;
import org.cytoscape.application.swing.CyHelpBroker;
import org.cytoscape.application.swing.CyNetworkViewDesktopMgr;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.ToolBarComponent;
import org.cytoscape.application.swing.search.NetworkSearchTaskFactory;
import org.cytoscape.internal.MacCyActivator;
import org.cytoscape.internal.SessionHandler;
import org.cytoscape.internal.actions.AboutAction;
import org.cytoscape.internal.actions.BookmarkAction;
import org.cytoscape.internal.actions.CheckForUpdatesAction;
import org.cytoscape.internal.actions.CloseWindowAction;
import org.cytoscape.internal.actions.CreateNetworkViewsAction;
import org.cytoscape.internal.actions.CytoPanelAction;
import org.cytoscape.internal.actions.DestroyNetworkViewsAction;
import org.cytoscape.internal.actions.DestroyNetworksAction;
import org.cytoscape.internal.actions.DetachedViewToolBarAction;
import org.cytoscape.internal.actions.ExitAction;
import org.cytoscape.internal.actions.ExportImageAction;
import org.cytoscape.internal.actions.ExportNetworkAction;
import org.cytoscape.internal.actions.FullScreenAction;
import org.cytoscape.internal.actions.NewNetworkFromSelectionAction;
import org.cytoscape.internal.actions.PreferenceAction;
import org.cytoscape.internal.actions.PrintAction;
import org.cytoscape.internal.actions.RecentSessionManager;
import org.cytoscape.internal.actions.StarterPanelAction;
import org.cytoscape.internal.command.CommandToolPanel;
import org.cytoscape.internal.command.PauseCommandTaskFactory;
import org.cytoscape.internal.dialogs.BookmarkDialogFactory;
import org.cytoscape.internal.dialogs.PreferencesDialogFactory;
import org.cytoscape.internal.io.SessionIO;
import org.cytoscape.internal.layout.ui.LayoutMenuPopulator;
import org.cytoscape.internal.layout.ui.LayoutSettingsManager;
import org.cytoscape.internal.layout.ui.SettingsAction;
import org.cytoscape.internal.model.RootNetworkManager;
import org.cytoscape.internal.select.RowViewTracker;
import org.cytoscape.internal.select.RowsSetViewUpdater;
import org.cytoscape.internal.select.SelectEdgeViewUpdater;
import org.cytoscape.internal.select.SelectNodeViewUpdater;
import org.cytoscape.internal.shutdown.ConfigDirPropertyWriter;
import org.cytoscape.internal.tunable.CyPropertyConfirmation;
import org.cytoscape.internal.tunable.CyPropertyConfirmationHandler;
import org.cytoscape.internal.undo.RedoAction;
import org.cytoscape.internal.undo.UndoAction;
import org.cytoscape.internal.util.HSLColor;
import org.cytoscape.internal.util.IconUtil;
import org.cytoscape.internal.util.undo.UndoMonitor;
import org.cytoscape.internal.view.CyColumnPresentationManagerImpl;
import org.cytoscape.internal.view.CyDesktopManager;
import org.cytoscape.internal.view.CyHelpBrokerImpl;
import org.cytoscape.internal.view.CytoPanelNameInternal;
import org.cytoscape.internal.view.CytoscapeDesktop;
import org.cytoscape.internal.view.CytoscapeMenuBar;
import org.cytoscape.internal.view.CytoscapeMenuPopulator;
import org.cytoscape.internal.view.CytoscapeMenus;
import org.cytoscape.internal.view.CytoscapeToolBar;
import org.cytoscape.internal.view.GridViewToggleModel;
import org.cytoscape.internal.view.NetworkMainPanel;
import org.cytoscape.internal.view.NetworkMediator;
import org.cytoscape.internal.view.NetworkSearchBar;
import org.cytoscape.internal.view.NetworkSearchMediator;
import org.cytoscape.internal.view.NetworkSelectionMediator;
import org.cytoscape.internal.view.NetworkViewMainPanel;
import org.cytoscape.internal.view.NetworkViewMediator;
import org.cytoscape.internal.view.ToolBarEnableUpdater;
import org.cytoscape.internal.view.help.ArrangeTaskFactory;
import org.cytoscape.internal.view.help.HelpContactHelpDeskTaskFactory;
import org.cytoscape.internal.view.help.HelpReportABugTaskFactory;
import org.cytoscape.internal.view.help.HelpTourTaskFactory;
import org.cytoscape.internal.view.help.HelpTutorialsTaskFactory;
import org.cytoscape.internal.view.help.HelpUserManualTaskFactory;
import org.cytoscape.internal.view.help.HelpVideosTaskFactory;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.model.events.NetworkDestroyedListener;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.task.NetworkCollectionTaskFactory;
import org.cytoscape.task.NetworkTaskFactory;
import org.cytoscape.task.NetworkViewCollectionTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.RootNetworkCollectionTaskFactory;
import org.cytoscape.task.TableTaskFactory;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.events.NetworkViewDestroyedListener;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.swing.GUITunableHandlerFactory;
import org.cytoscape.work.swing.SimpleGUITunableHandlerFactory;
import org.jdesktop.swingx.color.ColorUtil;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyActivator
extends AbstractCyActivator {
    private static int LARGE_ICON_SIZE = 32;
    private static final String CONTEXT_MENU_FILTER = "(inNetworkPanelContextMenu=true)";
    private static final String HELP_MENU = "Help";
    private static final String ARRANGE_VIEWS_MENU = "View.Arrange Detached Views[8]";
    private static Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private CytoscapeMenus cytoscapeMenus;
    private ToolBarEnableUpdater toolBarEnableUpdater;
    private NetworkSearchBar netSearchBar;
    private NetworkSearchMediator netSearchMediator;
    private NetworkMainPanel netMainPanel;
    private NetworkMediator netMediator;
    private ViewComparator viewComparator;
    private GridViewToggleModel gridViewToggleModel;
    private NetworkViewMainPanel netViewMainPanel;
    private NetworkViewMediator netViewMediator;
    private CytoscapeDesktop cytoscapeDesktop;
    private CommandToolPanel commandToolPanel;
    private SessionHandler sessionHandler;
    private LayoutMenuPopulator layoutMenuPopulator;
    private CytoscapeMenuPopulator cytoscapeMenuPopulator;
    private LayoutSettingsManager layoutSettingsManager;
    private HelpUserManualTaskFactory helpUserManualTaskFactory;
    private HelpTourTaskFactory helpTourTaskFactory;
    private HelpTutorialsTaskFactory helpTutorialsTaskFactory;
    private HelpVideosTaskFactory helpVideosTaskFactory;
    private HelpContactHelpDeskTaskFactory helpContactHelpDeskTaskFactory;
    private HelpReportABugTaskFactory helpReportABugTaskFactory;
    private CyDesktopManager cyDesktopManager;
    private ArrangeTaskFactory arrangeGridTaskFactory;
    private ArrangeTaskFactory arrangeCascadeTaskFactory;
    private ArrangeTaskFactory arrangeHorizontalTaskFactory;
    private ArrangeTaskFactory arrangeVerticalTaskFactory;
    private PreferencesDialogFactory preferencesDialogFactory;
    private BookmarkDialogFactory bookmarkDialogFactory;
    private UndoMonitor undoMonitor;
    private RowViewTracker rowViewTracker;
    private SelectEdgeViewUpdater selecteEdgeViewUpdater;
    private SelectNodeViewUpdater selecteNodeViewUpdater;
    private CyColumnPresentationManagerImpl columnPresentationManager;
    private RowsSetViewUpdater rowsSetViewUpdater;
    private RecentSessionManager recentSessionManager;
    private NetworkSelectionMediator netSelectionMediator;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private PrintAction printAction;
    private ExitAction exitAction;
    private PreferenceAction preferenceAction;
    private BookmarkAction bookmarkAction;
    private SettingsAction settingsAction;
    private CytoPanelAction cytoPanelWestAction;
    private CytoPanelAction cytoPanelSouthAction;
    private CytoPanelAction cytoPanelEastAction;
    private CytoPanelAction cytoPanelSouthWestAction;
    private CytoPanelAction cytoPanelCommandAction;
    private NewNetworkFromSelectionAction newNetworkFromSelectionAction;
    private StarterPanelAction starterPanelActionMenu;
    private StarterPanelAction starterPanelActionToolBar;
    private DetachedViewToolBarAction detachedViewToolBarAction;
    private CloseWindowAction closeWindowAction;
    private CreateNetworkViewsAction createNetworkViewsAction;
    private DestroyNetworkViewsAction destroyNetworkViewsAction;
    private DestroyNetworksAction destroyNetworksAction;
    private ExportNetworkAction exportNetworkAction;
    private ExportImageAction exportImageAction;
    private CheckForUpdatesAction welcomeScreenAction;

    public void start(BundleContext bc) throws Exception {
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        ViewUtil.invokeOnEDTAndWait(() -> this.setLookAndFeel(bc), logger);
        ConfigDirPropertyWriter configDirPropertyWriter = new ConfigDirPropertyWriter(serviceRegistrar);
        this.registerService(bc, configDirPropertyWriter, CyShutdownListener.class);
        CyHelpBrokerImpl cyHelpBroker = new CyHelpBrokerImpl();
        this.registerService(bc, cyHelpBroker, CyHelpBroker.class);
        this.registerServiceListener(bc, configDirPropertyWriter::addCyProperty, configDirPropertyWriter::removeCyProperty, CyProperty.class);
        SimpleGUITunableHandlerFactory cyPropConfirmHandlerFactory = new SimpleGUITunableHandlerFactory(CyPropertyConfirmationHandler.class, new Class[]{CyPropertyConfirmation.class});
        this.registerService(bc, cyPropConfirmHandlerFactory, GUITunableHandlerFactory.class);
        ViewUtil.invokeOnEDTAndWait(() -> this.initComponents(bc, serviceRegistrar));
        this.registerService(bc, (Object)this.undoAction, CyAction.class);
        this.registerService(bc, (Object)this.redoAction, CyAction.class);
        this.registerService(bc, (Object)this.printAction, CyAction.class);
        this.registerService(bc, (Object)this.preferenceAction, CyAction.class);
        this.registerService(bc, (Object)this.bookmarkAction, CyAction.class);
        this.registerService(bc, (Object)this.settingsAction, CyAction.class);
        this.registerService(bc, (Object)this.settingsAction, SetCurrentNetworkViewListener.class);
        this.registerService(bc, (Object)this.cytoPanelWestAction, CyAction.class);
        this.registerService(bc, (Object)this.cytoPanelSouthAction, CyAction.class);
        this.registerService(bc, (Object)this.cytoPanelEastAction, CyAction.class);
        this.registerService(bc, (Object)this.cytoPanelSouthWestAction, CyAction.class);
        this.registerService(bc, (Object)this.cytoPanelCommandAction, CyAction.class);
        this.registerService(bc, (Object)this.starterPanelActionMenu, CyAction.class);
        this.registerService(bc, (Object)this.starterPanelActionToolBar, CyAction.class);
        this.registerService(bc, (Object)this.detachedViewToolBarAction, CyAction.class);
        this.registerService(bc, (Object)this.closeWindowAction, CyAction.class);
        this.registerService(bc, (Object)this.newNetworkFromSelectionAction, CyAction.class);
        this.registerService(bc, this.cyDesktopManager, CyNetworkViewDesktopMgr.class);
        this.registerService(bc, this.bookmarkDialogFactory, SessionLoadedListener.class);
        Properties props = new Properties();
        props.setProperty("preferredMenu", HELP_MENU);
        props.setProperty("title", "User Manual");
        props.setProperty("menuGravity", "1.0");
        props.setProperty("tooltip", "Show User Manual");
        this.registerService(bc, (Object)this.helpUserManualTaskFactory, TaskFactory.class, props);
        props = new Properties();
        props.setProperty("preferredMenu", HELP_MENU);
        props.setProperty("title", "Video Demos");
        props.setProperty("menuGravity", "1.1");
        props.setProperty("tooltip", "Show Demo Videos");
        this.registerService(bc, (Object)this.helpVideosTaskFactory, TaskFactory.class, props);
        props = new Properties();
        props.setProperty("preferredMenu", HELP_MENU);
        props.setProperty("title", "Tour");
        props.setProperty("menuGravity", "1.2");
        this.registerService(bc, (Object)this.helpTourTaskFactory, TaskFactory.class, props);
        props = new Properties();
        props.setProperty("preferredMenu", HELP_MENU);
        props.setProperty("title", "Tutorials");
        props.setProperty("menuGravity", "1.5");
        props.setProperty("tooltip", "Show Tutorials");
        this.registerService(bc, (Object)this.helpTutorialsTaskFactory, TaskFactory.class, props);
        props = new Properties();
        props.setProperty("preferredMenu", HELP_MENU);
        props.setProperty("menuGravity", "7.0");
        props.setProperty("title", "Links for Help");
        this.registerService(bc, (Object)this.helpContactHelpDeskTaskFactory, TaskFactory.class, props);
        props = new Properties();
        props.setProperty("preferredMenu", HELP_MENU);
        props.setProperty("title", "Report a Bug");
        props.setProperty("menuGravity", "8.0");
        this.registerService(bc, (Object)this.helpReportABugTaskFactory, TaskFactory.class, props);
        props = new Properties();
        props.setProperty("enableFor", "networkAndView");
        props.setProperty("accelerator", "cmd g");
        props.setProperty("preferredMenu", ARRANGE_VIEWS_MENU);
        props.setProperty("title", "Grid");
        props.setProperty("menuGravity", "1.0");
        this.registerService(bc, (Object)this.arrangeGridTaskFactory, TaskFactory.class, props);
        props = new Properties();
        props.setProperty("enableFor", "networkAndView");
        props.setProperty("preferredMenu", ARRANGE_VIEWS_MENU);
        props.setProperty("title", "Cascade");
        props.setProperty("menuGravity", "2.0");
        this.registerService(bc, (Object)this.arrangeCascadeTaskFactory, TaskFactory.class, props);
        props = new Properties();
        props.setProperty("enableFor", "networkAndView");
        props.setProperty("preferredMenu", ARRANGE_VIEWS_MENU);
        props.setProperty("title", "Vertical Stack");
        props.setProperty("menuGravity", "3.0");
        this.registerService(bc, (Object)this.arrangeHorizontalTaskFactory, TaskFactory.class, props);
        props = new Properties();
        props.setProperty("enableFor", "networkAndView");
        props.setProperty("preferredMenu", ARRANGE_VIEWS_MENU);
        props.setProperty("title", "Side by Side");
        props.setProperty("menuGravity", "4.0");
        this.registerService(bc, (Object)this.arrangeVerticalTaskFactory, TaskFactory.class, props);
        props = new Properties();
        props.setProperty("inNetworkPanelContextMenu", "true");
        this.registerAllServices(bc, (Object)this.createNetworkViewsAction, props);
        props = new Properties();
        props.setProperty("inNetworkPanelContextMenu", "true");
        this.registerAllServices(bc, (Object)this.destroyNetworkViewsAction, props);
        props = new Properties();
        props.setProperty("inNetworkPanelContextMenu", "true");
        this.registerAllServices(bc, (Object)this.destroyNetworksAction, props);
        props = new Properties();
        props.setProperty("inNetworkPanelContextMenu", "true");
        this.registerAllServices(bc, (Object)this.exportNetworkAction, props);
        props = new Properties();
        props.setProperty("inNetworkPanelContextMenu", "true");
        this.registerAllServices(bc, (Object)this.exportImageAction, props);
        PauseCommandTaskFactory pauseCommand = new PauseCommandTaskFactory(this.cytoscapeDesktop);
        Properties props2 = new Properties();
        props2.setProperty("commandNamespace", "command");
        props2.setProperty("commandDescription", "Display a message and pause until the user continues.");
        props2.setProperty("command", "pause");
        props2.setProperty("commandLongDescription", "The **pause** command displays a dialog with the text provided in the *message* argument and waits for the user to click **OK**");
        props2.setProperty("commandSupportsJSON", "true");
        props2.setProperty("commandExampleJSON", "{}");
        this.registerService(bc, (Object)pauseCommand, TaskFactory.class, props2);
        this.registerAllServices(bc, this.cytoscapeDesktop);
        this.registerAllServices(bc, this.netMediator);
        this.registerAllServices(bc, this.netViewMediator);
        this.registerService(bc, this.undoMonitor, SetCurrentNetworkViewListener.class);
        this.registerService(bc, this.undoMonitor, NetworkDestroyedListener.class);
        this.registerService(bc, this.undoMonitor, NetworkViewDestroyedListener.class);
        this.registerAllServices(bc, this.rowViewTracker);
        this.registerAllServices(bc, this.selecteEdgeViewUpdater);
        this.registerAllServices(bc, this.selecteNodeViewUpdater);
        this.registerService(bc, this.columnPresentationManager, CyColumnPresentationManager.class);
        this.registerAllServices(bc, this.rowsSetViewUpdater);
        this.registerAllServices(bc, this.sessionHandler);
        this.registerAllServices(bc, this.toolBarEnableUpdater);
        this.registerAllServices(bc, this.recentSessionManager);
        this.registerAllServices(bc, this.netSelectionMediator);
        this.registerAllServices(bc, this.netSearchMediator);
        this.registerAllServices(bc, (Object)this.welcomeScreenAction, new Properties());
        this.registerServiceListener(bc, this.cytoscapeDesktop::addAction, this.cytoscapeDesktop::removeAction, CyAction.class);
        this.registerServiceListener(bc, this.preferenceAction::addCyProperty, this.preferenceAction::removeCyProperty, CyProperty.class);
        this.registerServiceListener(bc, this.cytoscapeDesktop::addCytoPanelComponent, this.cytoscapeDesktop::removeCytoPanelComponent, CytoPanelComponent.class);
        this.registerServiceListener(bc, this.cytoscapeDesktop::addToolBarComponent, this.cytoscapeDesktop::removeToolBarComponent, ToolBarComponent.class);
        this.registerServiceListener(bc, this.cytoscapeMenuPopulator::addTaskFactory, this.cytoscapeMenuPopulator::removeTaskFactory, TaskFactory.class);
        this.registerServiceListener(bc, this.cytoscapeMenuPopulator::addNetworkTaskFactory, this.cytoscapeMenuPopulator::removeNetworkTaskFactory, NetworkTaskFactory.class);
        this.registerServiceListener(bc, this.cytoscapeMenuPopulator::addNetworkViewTaskFactory, this.cytoscapeMenuPopulator::removeNetworkViewTaskFactory, NetworkViewTaskFactory.class);
        this.registerServiceListener(bc, this.cytoscapeMenuPopulator::addRootNetworkCollectionTaskFactory, this.cytoscapeMenuPopulator::removeRootNetworkCollectionTaskFactory, RootNetworkCollectionTaskFactory.class);
        this.registerServiceListener(bc, this.cytoscapeMenuPopulator::addNetworkCollectionTaskFactory, this.cytoscapeMenuPopulator::removeNetworkCollectionTaskFactory, NetworkCollectionTaskFactory.class);
        this.registerServiceListener(bc, this.cytoscapeMenuPopulator::addNetworkViewCollectionTaskFactory, this.cytoscapeMenuPopulator::removeNetworkViewCollectionTaskFactory, NetworkViewCollectionTaskFactory.class);
        this.registerServiceListener(bc, this.cytoscapeMenuPopulator::addTableTaskFactory, this.cytoscapeMenuPopulator::removeTableTaskFactory, TableTaskFactory.class);
        this.registerServiceListener(bc, this.layoutSettingsManager::addLayout, this.layoutSettingsManager::removeLayout, CyLayoutAlgorithm.class);
        this.registerServiceListener(bc, this.settingsAction::addLayout, this.settingsAction::removeLayout, CyLayoutAlgorithm.class);
        this.registerServiceListener(bc, this.columnPresentationManager::addPresentation, this.columnPresentationManager::removePresentation, CyColumnPresentation.class);
        this.registerServiceListener(bc, this.netMediator::addNetworkViewTaskFactory, this.netMediator::removeNetworkViewTaskFactory, NetworkViewTaskFactory.class, CONTEXT_MENU_FILTER);
        this.registerServiceListener(bc, this.netMediator::addNetworkTaskFactory, this.netMediator::removeNetworkTaskFactory, NetworkTaskFactory.class, CONTEXT_MENU_FILTER);
        this.registerServiceListener(bc, this.netMediator::addRootNetworkCollectionTaskFactory, this.netMediator::removeRootNetworkCollectionTaskFactory, RootNetworkCollectionTaskFactory.class, CONTEXT_MENU_FILTER);
        this.registerServiceListener(bc, this.netMediator::addNetworkViewCollectionTaskFactory, this.netMediator::removeNetworkViewCollectionTaskFactory, NetworkViewCollectionTaskFactory.class, CONTEXT_MENU_FILTER);
        this.registerServiceListener(bc, this.netMediator::addNetworkCollectionTaskFactory, this.netMediator::removeNetworkCollectionTaskFactory, NetworkCollectionTaskFactory.class, CONTEXT_MENU_FILTER);
        this.registerServiceListener(bc, this.netMediator::addCyAction, this.netMediator::removeCyAction, CyAction.class, CONTEXT_MENU_FILTER);
        this.registerServiceListener(bc, this.netSearchMediator::addNetworkSearchTaskFactory, this.netSearchMediator::removeNetworkSearchTaskFactory, NetworkSearchTaskFactory.class);
        this.registerServiceListener(bc, this.layoutMenuPopulator::addLayout, this.layoutMenuPopulator::removeLayout, CyLayoutAlgorithm.class);
        this.registerAllServices(bc, this.netMainPanel);
        this.registerAllServices(bc, this.commandToolPanel);
        if (LookAndFeelUtil.isMac()) {
            try {
                new MacCyActivator().start(bc);
            }
            catch (Exception e) {
                logger.error("Cannot start MacCyActivator", (Throwable)e);
            }
        } else {
            AboutAction aboutAction = new AboutAction(HELP_MENU, serviceRegistrar);
            this.registerService(bc, (Object)aboutAction, CyAction.class);
            this.registerService(bc, (Object)this.exitAction, CyAction.class);
        }
        if (!LookAndFeelUtil.isMac()) {
            FullScreenAction fullScreenAction = new FullScreenAction(this.cytoscapeDesktop);
            this.registerService(bc, (Object)fullScreenAction, CyAction.class);
        }
    }

    private void initComponents(BundleContext bc, CyServiceRegistrar serviceRegistrar) {
        CyApplicationManager applicationManager = (CyApplicationManager)this.getService(bc, CyApplicationManager.class);
        CyNetworkViewManager netViewManager = (CyNetworkViewManager)this.getService(bc, CyNetworkViewManager.class);
        IconManager iconManager = (IconManager)serviceRegistrar.getService(IconManager.class);
        RootNetworkManager rootNetManager = new RootNetworkManager(serviceRegistrar);
        this.registerService(bc, rootNetManager, NetworkAboutToBeDestroyedListener.class);
        this.registerService(bc, rootNetManager, SessionAboutToBeLoadedListener.class);
        CytoscapeMenuBar cytoscapeMenuBar = new CytoscapeMenuBar(serviceRegistrar);
        CytoscapeToolBar cytoscapeToolBar = new CytoscapeToolBar(serviceRegistrar);
        this.cytoscapeMenus = new CytoscapeMenus(cytoscapeMenuBar, cytoscapeToolBar);
        this.toolBarEnableUpdater = new ToolBarEnableUpdater(cytoscapeToolBar, serviceRegistrar);
        this.netSearchBar = new NetworkSearchBar(serviceRegistrar);
        this.netSearchMediator = new NetworkSearchMediator(this.netSearchBar, serviceRegistrar);
        this.netMainPanel = new NetworkMainPanel(this.netSearchBar, serviceRegistrar);
        this.netMediator = new NetworkMediator(this.netMainPanel, rootNetManager, serviceRegistrar);
        this.commandToolPanel = new CommandToolPanel(serviceRegistrar);
        this.viewComparator = new ViewComparator(this.netMainPanel);
        this.gridViewToggleModel = new GridViewToggleModel(GridViewToggleModel.Mode.VIEW);
        this.netViewMainPanel = new NetworkViewMainPanel(this.gridViewToggleModel, this.cytoscapeMenus, this.viewComparator, serviceRegistrar);
        this.netViewMediator = new NetworkViewMediator(this.netViewMainPanel, this.netMediator, this.gridViewToggleModel, serviceRegistrar);
        this.cytoscapeDesktop = new CytoscapeDesktop(this.cytoscapeMenus, this.netViewMediator, serviceRegistrar);
        SessionIO sessionIO = new SessionIO();
        this.sessionHandler = new SessionHandler(this.cytoscapeDesktop, this.netViewMediator, sessionIO, this.netMainPanel, serviceRegistrar);
        this.layoutMenuPopulator = new LayoutMenuPopulator(cytoscapeMenuBar, serviceRegistrar);
        this.cytoscapeMenuPopulator = new CytoscapeMenuPopulator(this.cytoscapeDesktop, rootNetManager, serviceRegistrar);
        this.layoutSettingsManager = new LayoutSettingsManager(serviceRegistrar);
        this.helpUserManualTaskFactory = new HelpUserManualTaskFactory(serviceRegistrar);
        this.helpTutorialsTaskFactory = new HelpTutorialsTaskFactory(serviceRegistrar);
        this.helpVideosTaskFactory = new HelpVideosTaskFactory(serviceRegistrar);
        this.helpContactHelpDeskTaskFactory = new HelpContactHelpDeskTaskFactory(serviceRegistrar);
        this.helpReportABugTaskFactory = new HelpReportABugTaskFactory(serviceRegistrar);
        this.helpTourTaskFactory = new HelpTourTaskFactory(serviceRegistrar);
        this.cyDesktopManager = new CyDesktopManager(this.netViewMediator);
        this.arrangeGridTaskFactory = new ArrangeTaskFactory(CyNetworkViewDesktopMgr.ArrangeType.GRID, this.cyDesktopManager, this.netViewMediator);
        this.arrangeCascadeTaskFactory = new ArrangeTaskFactory(CyNetworkViewDesktopMgr.ArrangeType.CASCADE, this.cyDesktopManager, this.netViewMediator);
        this.arrangeHorizontalTaskFactory = new ArrangeTaskFactory(CyNetworkViewDesktopMgr.ArrangeType.HORIZONTAL, this.cyDesktopManager, this.netViewMediator);
        this.arrangeVerticalTaskFactory = new ArrangeTaskFactory(CyNetworkViewDesktopMgr.ArrangeType.VERTICAL, this.cyDesktopManager, this.netViewMediator);
        this.preferencesDialogFactory = new PreferencesDialogFactory(serviceRegistrar);
        this.bookmarkDialogFactory = new BookmarkDialogFactory(serviceRegistrar);
        this.undoMonitor = new UndoMonitor(serviceRegistrar);
        this.rowViewTracker = new RowViewTracker();
        this.selecteEdgeViewUpdater = new SelectEdgeViewUpdater(this.rowViewTracker);
        this.selecteNodeViewUpdater = new SelectNodeViewUpdater(this.rowViewTracker);
        this.columnPresentationManager = new CyColumnPresentationManagerImpl(serviceRegistrar);
        this.rowsSetViewUpdater = new RowsSetViewUpdater(this.rowViewTracker, this.netViewMediator, serviceRegistrar);
        this.recentSessionManager = new RecentSessionManager(serviceRegistrar);
        this.netSelectionMediator = new NetworkSelectionMediator(this.netMainPanel, this.netViewMainPanel, rootNetManager, serviceRegistrar);
        this.undoAction = new UndoAction(serviceRegistrar);
        this.redoAction = new RedoAction(serviceRegistrar);
        this.printAction = new PrintAction(applicationManager, netViewManager, serviceRegistrar);
        this.exitAction = new ExitAction(serviceRegistrar);
        this.preferenceAction = new PreferenceAction(this.cytoscapeDesktop, this.preferencesDialogFactory);
        this.bookmarkAction = new BookmarkAction(this.cytoscapeDesktop, this.bookmarkDialogFactory);
        this.settingsAction = new SettingsAction(this.layoutSettingsManager, serviceRegistrar);
        this.cytoPanelWestAction = new CytoPanelAction(CytoPanelNameInternal.WEST, this.cytoscapeDesktop, 1.0f);
        this.cytoPanelSouthAction = new CytoPanelAction(CytoPanelNameInternal.SOUTH, this.cytoscapeDesktop, 1.1f);
        this.cytoPanelEastAction = new CytoPanelAction(CytoPanelNameInternal.EAST, this.cytoscapeDesktop, 1.2f);
        this.cytoPanelSouthWestAction = new CytoPanelAction(CytoPanelNameInternal.SOUTH_WEST, this.cytoscapeDesktop, 1.3f);
        this.cytoPanelCommandAction = new CytoPanelAction(CytoPanelNameInternal.BOTTOM, this.cytoscapeDesktop, 1.35f);
        Font iconFont = iconManager.getIconFont("cytoscape-3", 32.0f);
        TextIcon icon = new TextIcon(IconUtil.LAYERED_NEW_FROM_SELECTED, iconFont, IconUtil.COLORS_3, LARGE_ICON_SIZE, LARGE_ICON_SIZE, new Integer[]{1});
        this.newNetworkFromSelectionAction = new NewNetworkFromSelectionAction(10.1f, (Icon)icon, serviceRegistrar);
        TextIcon icon2 = new TextIcon("\uf015", iconManager.getIconFont(28.0f), UIManager.getColor("CyColor.complement(+1)"), LARGE_ICON_SIZE, LARGE_ICON_SIZE);
        this.starterPanelActionToolBar = new StarterPanelAction(1.1E14f, (Icon)icon2, this.cytoscapeDesktop);
        this.starterPanelActionMenu = new StarterPanelAction(1.4f, this.cytoscapeDesktop);
        this.detachedViewToolBarAction = new DetachedViewToolBarAction(1.5f, this.netViewMediator);
        this.closeWindowAction = new CloseWindowAction(1.99f, this.netViewMediator);
        this.createNetworkViewsAction = new CreateNetworkViewsAction(3.0f, serviceRegistrar);
        this.destroyNetworkViewsAction = new DestroyNetworkViewsAction(3.1f, serviceRegistrar);
        this.destroyNetworksAction = new DestroyNetworksAction(3.2f, this.netMainPanel, serviceRegistrar);
        this.exportNetworkAction = new ExportNetworkAction(1000.1f, serviceRegistrar);
        this.exportImageAction = new ExportImageAction(1000.2f, serviceRegistrar);
        this.welcomeScreenAction = new CheckForUpdatesAction(serviceRegistrar);
    }

    private void setLookAndFeel(BundleContext bc) {
        IconManager iconManager = (IconManager)this.getService(bc, IconManager.class);
        Properties props = (Properties)this.getCy3Property(bc).getProperties();
        String lookAndFeel = props.getProperty("lookAndFeel");
        if (lookAndFeel == null) {
            lookAndFeel = LookAndFeelUtil.isMac() || LookAndFeelUtil.isWindows() ? UIManager.getSystemLookAndFeelClassName() : "javax.swing.plaf.nimbus.NimbusLookAndFeel";
        }
        try {
            logger.debug("Setting look and feel to: " + lookAndFeel);
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception e) {
            logger.error("Unexpected error", (Throwable)e);
        }
        if (LookAndFeelUtil.isAquaLAF()) {
            boolean useScreenMenuBar;
            String useScreenMenuBarVal = props.getProperty("useScreenMenuBar");
            if ("true".equalsIgnoreCase(useScreenMenuBarVal)) {
                useScreenMenuBar = true;
            } else if ("false".equalsIgnoreCase(useScreenMenuBarVal)) {
                useScreenMenuBar = false;
            } else {
                String language = Locale.getDefault().getLanguage();
                String version = System.getProperty("os.version");
                boolean highSierra = version.startsWith("10.13");
                boolean english = language.equals(new Locale("en").getLanguage());
                useScreenMenuBar = !highSierra || english;
            }
            System.setProperty("apple.laf.useScreenMenuBar", "" + useScreenMenuBar);
        }
        try {
            Color tsb;
            if (UIManager.getFont("Label.font") == null) {
                UIManager.put("Label.font", new JLabel().getFont());
            }
            if ((tsb = UIManager.getColor("Table.selectionBackground")) == null) {
                tsb = UIManager.getColor("Tree.selectionBackground");
            }
            if (tsb == null) {
                tsb = UIManager.getColor("Table[Enabled+Selected].textBackground");
            }
            if (tsb != null) {
                HSLColor hsl = new HSLColor(tsb);
                tsb = hsl.adjustLuminance(LookAndFeelUtil.isAquaLAF() ? 94.0f : 90.0f);
            }
            Color tableSelectionBg = tsb != null && !tsb.equals(Color.WHITE) ? tsb : new Color(222, 234, 252);
            UIManager.put("Table.focusCellBackground", UIManager.getColor("Tree.selectionBackground"));
            UIManager.put("Table.focusCellForeground", UIManager.getColor("Tree.selectionForeground"));
            UIManager.put("Table.selectionBackground", tableSelectionBg);
            UIManager.put("Table.selectionForeground", UIManager.getColor("Table.foreground"));
            Color originalDisabledFg = null;
            if (LookAndFeelUtil.isNimbusLAF()) {
                originalDisabledFg = UIManager.getColor("nimbusDisabledText");
                if (originalDisabledFg != null) {
                    originalDisabledFg = new Color(originalDisabledFg.getRGB());
                }
            } else {
                originalDisabledFg = UIManager.getColor(CyActivator.isGtkLAF() ? "Button.disabledForeground" : "Label.disabledForeground");
                if (originalDisabledFg == null) {
                    originalDisabledFg = UIManager.getColor("TextField.inactiveForeground");
                }
            }
            Color disabledFg = originalDisabledFg == null ? (originalDisabledFg = UIManager.getColor("Panel.background").darker()) : (LookAndFeelUtil.isWinLAF() || LookAndFeelUtil.isAquaLAF() ? ColorUtil.setBrightness((Color)originalDisabledFg, (float)0.75f) : originalDisabledFg);
            UIManager.put("Label.disabledForeground", disabledFg);
            UIManager.put("Button.disabledForeground", disabledFg);
            UIManager.put("Button.disabledText", disabledFg);
            UIManager.put("ToggleButton.disabledForeground", disabledFg);
            UIManager.put("ToggleButton.disabledText", disabledFg);
            UIManager.put("CheckBox.disabledForeground", disabledFg);
            UIManager.put("Radio.disabledForeground", disabledFg);
            UIManager.put("Menu.disabledForeground", disabledFg);
            UIManager.put("MenuItem.disabledForeground", disabledFg);
            UIManager.put("CheckBoxMenuItem.disabledForeground", disabledFg);
            UIManager.put("RadioButtonMenuItem.disabledForeground", disabledFg);
            UIManager.put("Table.disabledForeground", disabledFg);
            UIManager.put("Table.disabledText", disabledFg);
            UIManager.put("Table.rowHeight", new JTable().getRowHeight());
            UIManager.put("TableHeader.disabledForeground", disabledFg);
            UIManager.put("TextField.inactiveForeground", disabledFg);
            UIManager.put("TextField.disabledForeground", disabledFg);
            UIManager.put("FormattedTextField.inactiveForeground", disabledFg);
            UIManager.put("FormattedTextField.disabledForeground", disabledFg);
            UIManager.put("PasswordField.disabledBackground", disabledFg);
            UIManager.put("TextArea.inactiveForeground", disabledFg);
            UIManager.put("TextArea.disabledForeground", disabledFg);
            UIManager.put("List.disabledForeground", disabledFg);
            UIManager.put("ComboBox.disabledForeground", disabledFg);
            UIManager.put("Tree.hash", new Color(255, 255, 255, 0));
            UIManager.put("ToolBar.separatorSize", new Dimension(1, 20));
            UIManager.put("ToolBarSeparatorUI", "javax.swing.plaf.basic.BasicToolBarSeparatorUI");
            UIManager.put("Label.infoForeground", ColorUtil.setBrightness((Color)UIManager.getColor("Label.foreground"), (float)0.48f));
            Font tableFont = UIManager.getFont("Label.font").deriveFont(11.0f);
            if (LookAndFeelUtil.isAquaLAF()) {
                Color tableHeaderBorderColor = UIManager.getColor("Separator.foreground");
                UIManager.put("TableHeader.borderColor", tableHeaderBorderColor);
                UIManager.put("TableHeader.cellBorder", BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, tableHeaderBorderColor), BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, tableHeaderBorderColor), BorderFactory.createEmptyBorder(0, 4, 0, 4)))));
                UIManager.put("TableRowHeader.cellBorder", BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, tableHeaderBorderColor), BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, tableHeaderBorderColor), BorderFactory.createEmptyBorder(4, 0, 4, 0)))));
                UIManager.put("TableHeader.background", new Color(240, 240, 240));
                UIManager.put("Table.alternateRowColor", new Color(244, 245, 245, 0));
                UIManager.put("Table.showGrid", false);
                UIManager.put("Table.gridColor", new Color(216, 216, 216, 0));
                UIManager.put("Table.font", tableFont);
                UIManager.put("Tree.font", tableFont);
            } else if (LookAndFeelUtil.isWinLAF()) {
                Color tableHeaderBorderColor = new Color(223, 223, 223);
                UIManager.put("TableHeader.borderColor", tableHeaderBorderColor);
                UIManager.put("TableHeader.cellBorder", BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 6, 0), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, tableHeaderBorderColor), BorderFactory.createEmptyBorder(2, 6, 2, 6))));
                UIManager.put("TableRowHeader.cellBorder", BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 6), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, tableHeaderBorderColor), BorderFactory.createEmptyBorder(6, 2, 6, 2))));
                UIManager.put("TableHeader.background", UIManager.getColor("Table.background"));
                UIManager.put("Table.alternateRowColor", new Color(245, 245, 245, 0));
                UIManager.put("Table.showGrid", false);
                UIManager.put("Table.gridColor", new Color(223, 223, 223, 0));
                UIManager.put("Viewport.background", UIManager.getColor("Table.background"));
                UIManager.put("ScrollPane.background", UIManager.getColor("Table.background"));
                UIManager.put("Separator.foreground", new Color(208, 208, 208));
                Color selBgColor = UIManager.getColor("TextField.selectionBackground");
                if (selBgColor != null) {
                    UIManager.put("Focus.color", new Color(selBgColor.getRGB()));
                }
            } else if (LookAndFeelUtil.isNimbusLAF()) {
                UIManager.put("nimbusLightBackground", Color.WHITE);
                UIManager.put("nimbusDisabledText", new Color(142, 143, 145));
                UIManager.put("Table.background", Color.WHITE);
                UIManager.put("Table.foreground", new Color(UIManager.getColor("Table.foreground").getRGB()));
                UIManager.put("Table.alternateRowColor", new Color(242, 242, 242, 0));
                UIManager.put("Table:\"Table.cellRenderer\".background", Color.WHITE);
                UIManager.put("Table.showGrid", true);
                UIManager.put("Table.gridColor", UIManager.getColor("nimbusBorder"));
                UIManager.put("Table.font", tableFont);
                UIManager.put("Viewport.background", Color.WHITE);
                UIManager.put("ScrollPane.background", Color.WHITE);
                UIManager.put("Tree.font", tableFont);
                UIManager.put("Separator.foreground", UIManager.getColor("nimbusBorder"));
                Color nimbusColor = UIManager.getColor("nimbusFocus");
                if (nimbusColor == null) {
                    nimbusColor = new Color(115, 164, 209);
                }
                UIManager.put("Focus.color", new Color(nimbusColor.getRGB()));
                UIManager.put("TextField.selectionBackground", UIManager.getColor("nimbusSelectionBackground"));
                Color tableHeaderBorderColor = UIManager.getColor("nimbusBorder");
                UIManager.put("TableHeader.borderColor", tableHeaderBorderColor);
                UIManager.put("TableHeader.cellBorder", BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, tableHeaderBorderColor), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
                UIManager.put("TableRowHeader.cellBorder", BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, tableHeaderBorderColor), BorderFactory.createEmptyBorder(4, 2, 4, 2)));
                UIManager.getLookAndFeelDefaults().put("List[Selected].textBackground", new Color(57, 105, 138));
                UIManager.getLookAndFeelDefaults().put("List[Selected].textForeground", Color.WHITE);
            } else if (CyActivator.isGtkLAF()) {
                Color tableHeaderBorderColor = UIManager.getColor("Separator.foreground");
                UIManager.put("TableHeader.borderColor", tableHeaderBorderColor);
                UIManager.put("TableHeader.cellBorder", BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, tableHeaderBorderColor), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
                UIManager.put("TableRowHeader.cellBorder", BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, tableHeaderBorderColor), BorderFactory.createEmptyBorder(4, 2, 4, 2)));
                UIManager.put("TableHeader.background", UIManager.getColor("Table.background"));
                UIManager.put("Table.alternateRowColor", new Color(245, 245, 245, 0));
            }
            if (UIManager.getIcon("Tree.rightToLeftCollapsedIcon") == null && (LookAndFeelUtil.isWinLAF() || CyActivator.isGtkLAF())) {
                Icon treeIcon = UIManager.getIcon("Tree.collapsedIcon");
                int w = treeIcon != null ? Math.max(12, treeIcon.getIconWidth()) : 16;
                int h = treeIcon != null ? Math.max(12, treeIcon.getIconHeight()) : 16;
                Font font = iconManager.getIconFont(10.0f);
                Color c = UIManager.getColor("Label.infoForeground");
                UIManager.put("Tree.expandedIcon", new TextIcon("\uf078", font, c, w, h));
                UIManager.put("Tree.collapsedIcon", new TextIcon("\uf054", font, c, w, h));
                UIManager.put("Tree.rightToLeftCollapsedIcon", new TextIcon("\uf053", font, c, w, h));
            }
            UIManager.put("ScrollPane.border", BorderFactory.createLineBorder(UIManager.getColor("Separator.foreground")));
            UIManager.put("SplitPaneUI", "javax.swing.plaf.basic.BasicSplitPaneUI");
            UIManager.put("SplitPane.dividerSize", 5);
            UIManager.put("SplitPane.foreground", UIManager.getColor("Separator.foreground"));
            UIManager.put("SplitPane.background", UIManager.getColor("Separator.foreground"));
            UIManager.put("SplitPaneDivider.border", BorderFactory.createEmptyBorder());
            UIManager.put("CyToggleButton.background", UIManager.getColor("Button.background"));
            if (LookAndFeelUtil.isNimbusLAF()) {
                UIManager.put("CyToggleButton.foreground", new Color(UIManager.getColor("Button.foreground").getRGB()));
                UIManager.put("CyToggleButton[Selected].background", new Color(UIManager.getColor("nimbusBlueGrey").getRGB()));
                UIManager.put("CyToggleButton[Selected].foreground", new Color(UIManager.getColor("ToggleButton.foreground").getRGB()));
                UIManager.put("CyToggleButton[Selected].borderColor", new Color(UIManager.getColor("nimbusBorder").getRGB()));
            } else {
                UIManager.put("CyToggleButton.foreground", ColorUtil.setBrightness((Color)UIManager.getColor("Button.foreground"), (float)0.25f));
                UIManager.put("CyToggleButton[Selected].background", ColorUtil.setBrightness((Color)UIManager.getColor("Button.background"), (float)0.8f));
                UIManager.put("CyToggleButton[Selected].foreground", UIManager.getColor("Button.foreground"));
                UIManager.put("CyToggleButton[Selected].borderColor", ColorUtil.setBrightness((Color)UIManager.getColor("Button.foreground"), (float)0.68f));
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error", (Throwable)e);
        }
        UIManager.put("CyColor.primary(-2)", new Color(150, 83, 0));
        UIManager.put("CyColor.primary(-1)", new Color(190, 110, 12));
        UIManager.put("CyColor.primary(0)", new Color(234, 145, 35));
        UIManager.put("CyColor.primary", new Color(234, 145, 35));
        UIManager.put("CyColor.primary(+1)", new Color(248, 172, 78));
        UIManager.put("CyColor.primary(+2)", new Color(255, 194, 120));
        UIManager.put("CyColor.secondary1(-2)", new Color(0, 110, 37));
        UIManager.put("CyColor.secondary1(-1)", new Color(9, 139, 53));
        UIManager.put("CyColor.secondary1(0)", new Color(26, 171, 75));
        UIManager.put("CyColor.secondary1", new Color(26, 171, 75));
        UIManager.put("CyColor.secondary1(+1)", new Color(57, 182, 99));
        UIManager.put("CyColor.secondary1(+2)", new Color(95, 202, 131));
        UIManager.put("CyColor.secondary2(-2)", new Color(150, 23, 0));
        UIManager.put("CyColor.secondary2(-1)", new Color(190, 40, 12));
        UIManager.put("CyColor.secondary2(0)", new Color(234, 66, 35));
        UIManager.put("CyColor.secondary2", new Color(234, 66, 35));
        UIManager.put("CyColor.secondary2(+1)", new Color(248, 105, 78));
        UIManager.put("CyColor.secondary2(+2)", new Color(255, 141, 120));
        UIManager.put("CyColor.complement(-2)", new Color(5, 62, 96));
        UIManager.put("CyColor.complement(-1)", new Color(14, 81, 121));
        UIManager.put("CyColor.complement(0)", new Color(29, 105, 149));
        UIManager.put("CyColor.complement", new Color(29, 105, 149));
        UIManager.put("CyColor.complement(+1)", new Color(56, 120, 158));
        UIManager.put("CyColor.complement(+2)", new Color(92, 149, 183));
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    private CyProperty<Properties> getCy3Property(BundleContext bc) {
        return (CyProperty)this.getService(bc, CyProperty.class, "(cyPropertyName=cytoscape3.props)");
    }

    public static boolean isGtkLAF() {
        return UIManager.getLookAndFeel() != null && "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    private class ViewComparator
    implements Comparator<CyNetworkView> {
        private final NetworkMainPanel netMainPanel;
        private final Collator collator;

        ViewComparator(NetworkMainPanel netMainPanel) {
            this.netMainPanel = netMainPanel;
            this.collator = Collator.getInstance(Locale.getDefault());
        }

        @Override
        public int compare(CyNetworkView v1, CyNetworkView v2) {
            Integer idx2;
            Integer idx1 = this.netMainPanel.indexOf((CyNetwork)v1.getModel());
            int value = idx1.compareTo(idx2 = Integer.valueOf(this.netMainPanel.indexOf((CyNetwork)v2.getModel())));
            if (value == 0 && (value = this.collator.compare(ViewUtil.getTitle(v1), ViewUtil.getTitle(v2))) == 0) {
                value = v1.getSUID().compareTo(v2.getSUID());
            }
            return value;
        }
    }
}

