/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.event.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.event.CyPayloadEvent;
import org.cytoscape.event.internal.CyListenerAdapter;
import org.cytoscape.event.internal.PayloadAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyEventHelperImpl
implements CyEventHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final Object DUMMY = new Object();
    private static final int PAYLOAD_ACCUMULATOR_LIMIT = 100000;
    private static final int PAYLOAD_FLUSH_CHECK_LIMIT = 3;
    private static final boolean alwaysForce = false;
    private final CyListenerAdapter normal;
    private final Map<Object, Map<Class<?>, PayloadAccumulator<?, ?, ?>>> sourceAccMap;
    private final ScheduledExecutorService payloadEventMonitor;
    private final Map<Object, Object> silencedSources;
    private final Object lock = new Object();

    public CyEventHelperImpl(CyListenerAdapter normal) {
        this.normal = normal;
        this.sourceAccMap = new LinkedHashMap();
        this.payloadEventMonitor = Executors.newSingleThreadScheduledExecutor();
        this.silencedSources = new WeakHashMap<Object, Object>();
        this.payloadEventMonitor.scheduleAtFixedRate(() -> this.flushPayloadEvents(null, false), 100L, 100L, TimeUnit.MILLISECONDS);
    }

    public <E extends CyEvent<?>> void fireEvent(E event) {
        this.flushPayloadEvents();
        this.normal.fireEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void silenceEventSource(Object eventSource) {
        if (eventSource == null) {
            return;
        }
        logger.debug("Silencing event source: " + eventSource.toString());
        this.normal.silenceEventSource(eventSource);
        Object object = this.lock;
        synchronized (object) {
            this.silencedSources.put(eventSource, DUMMY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsilenceEventSource(Object eventSource) {
        if (eventSource == null) {
            return;
        }
        logger.debug("Unsilencing event source: " + eventSource.toString());
        this.normal.unsilenceEventSource(eventSource);
        Object object = this.lock;
        synchronized (object) {
            this.silencedSources.remove(eventSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, P, E extends CyPayloadEvent<S, P>> void addEventPayload(S source, P payload, Class<E> eventType) {
        if (payload == null || source == null || eventType == null) {
            logger.warn("Improperly specified payload event with source: " + source + ";  with payload: " + payload + ";  with event type: " + eventType);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            PayloadAccumulator<Object, Object, Object> acc;
            if (this.silencedSources.containsKey(source)) {
                return;
            }
            Map<Class<?>, PayloadAccumulator<?, ?, ?>> cmap = this.sourceAccMap.get(source);
            if (cmap == null) {
                cmap = new LinkedHashMap();
                this.sourceAccMap.put(source, cmap);
            }
            if ((acc = cmap.get(eventType)) == null) {
                try {
                    acc = new PayloadAccumulator(source, eventType, 100000, 3);
                    cmap.put(eventType, acc);
                }
                catch (NoSuchMethodException nsme) {
                    logger.warn("Unable to add payload to event, because of missing event constructor.", (Throwable)nsme);
                    return;
                }
            }
            acc.addPayload(payload);
        }
    }

    public void flushPayloadEvents(Object source) {
        this.flushPayloadEvents(source, true);
    }

    public void flushPayloadEvents() {
        this.flushPayloadEvents(null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPayloadEvents(Object oneSource, boolean force) {
        ArrayList flushList = new ArrayList();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            if (oneSource != null) {
                this.createPayloadEvents(oneSource, flushList, force);
            } else {
                for (Object source : new ArrayList<Object>(this.sourceAccMap.keySet())) {
                    this.createPayloadEvents(source, flushList, force);
                }
            }
        }
        for (CyEvent cyEvent : flushList) {
            this.normal.fireEvent(cyEvent);
        }
    }

    private void createPayloadEvents(Object source, List<CyEvent<?>> flushList, boolean force) {
        Map<Class<?>, PayloadAccumulator<?, ?, ?>> cmap = this.sourceAccMap.get(source);
        if (cmap == null) {
            return;
        }
        Iterator<PayloadAccumulator<?, ?, ?>> iter = cmap.values().iterator();
        while (iter.hasNext()) {
            PayloadAccumulator<?, ?, ?> acc = iter.next();
            if (!force && !acc.checkReady()) continue;
            try {
                Object event = acc.newEventInstance();
                if (event != null) {
                    flushList.add((CyEvent<?>)event);
                }
            }
            catch (Exception ie) {
                logger.warn("Couldn't instantiate event for source: " + acc.getSource(), (Throwable)ie);
            }
            iter.remove();
        }
        if (cmap.isEmpty()) {
            this.sourceAccMap.remove(source);
        }
    }

    void cleanup() {
        this.payloadEventMonitor.shutdown();
    }
}

