/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.json.serializer;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.io.internal.write.json.serializer.CytoscapeJsStyleConverter;
import org.cytoscape.io.internal.write.json.serializer.VisualMappingSerializer;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;

public class PassthroughMappingSerializer
implements VisualMappingSerializer<PassthroughMapping<?, ?>> {
    private static final Pattern REPLACE_INVALID_JS_CHAR_PATTERN = Pattern.compile("^[^a-zA-Z_]+|[^a-zA-Z_0-9]+");
    private static final Set<VisualProperty<?>> COMPATIBLE_VP = new HashSet();
    private final CytoscapeJsStyleConverter converter = new CytoscapeJsStyleConverter();

    @Override
    public String serialize(PassthroughMapping<?, ?> mapping) {
        VisualProperty vp = mapping.getVisualProperty();
        if (!COMPATIBLE_VP.contains(vp)) {
            return null;
        }
        String columnName = mapping.getMappingColumnName();
        Matcher matcher = REPLACE_INVALID_JS_CHAR_PATTERN.matcher(columnName);
        columnName = matcher.replaceAll("_");
        return "data(" + columnName + ")";
    }

    static {
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_LABEL);
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_TOOLTIP);
        COMPATIBLE_VP.add(BasicVisualLexicon.EDGE_LABEL);
        COMPATIBLE_VP.add(BasicVisualLexicon.EDGE_TOOLTIP);
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_BORDER_WIDTH);
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_SIZE);
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_WIDTH);
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_HEIGHT);
        COMPATIBLE_VP.add(BasicVisualLexicon.EDGE_WIDTH);
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_TRANSPARENCY);
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_LABEL_TRANSPARENCY);
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_BORDER_TRANSPARENCY);
        COMPATIBLE_VP.add(BasicVisualLexicon.EDGE_TRANSPARENCY);
        COMPATIBLE_VP.add(BasicVisualLexicon.EDGE_LABEL_TRANSPARENCY);
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_FILL_COLOR);
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_SELECTED_PAINT);
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_PAINT);
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_LABEL_COLOR);
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_BORDER_PAINT);
        COMPATIBLE_VP.add(BasicVisualLexicon.EDGE_LABEL_COLOR);
        COMPATIBLE_VP.add(BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT);
        COMPATIBLE_VP.add(BasicVisualLexicon.EDGE_STROKE_SELECTED_PAINT);
        COMPATIBLE_VP.add(BasicVisualLexicon.EDGE_UNSELECTED_PAINT);
        COMPATIBLE_VP.add(BasicVisualLexicon.EDGE_SELECTED_PAINT);
        COMPATIBLE_VP.add(BasicVisualLexicon.NODE_SHAPE);
        COMPATIBLE_VP.add(BasicVisualLexicon.EDGE_TARGET_ARROW_SHAPE);
        COMPATIBLE_VP.add(BasicVisualLexicon.EDGE_SOURCE_ARROW_SHAPE);
        COMPATIBLE_VP.add(BasicVisualLexicon.EDGE_LINE_TYPE);
    }
}

