/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.json.serializer;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.awt.Paint;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.application.CyVersion;
import org.cytoscape.io.internal.write.json.serializer.CytoscapeJsStyleConverter;
import org.cytoscape.io.internal.write.json.serializer.CytoscapeJsToken;
import org.cytoscape.io.internal.write.json.serializer.PassthroughMappingSerializer;
import org.cytoscape.io.internal.write.json.serializer.ValueSerializer;
import org.cytoscape.io.internal.write.json.serializer.ValueSerializerManager;
import org.cytoscape.io.internal.write.json.serializer.VisualMappingSerializer;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CytoscapeJsVisualStyleSerializer
extends JsonSerializer<VisualStyle> {
    private static final Logger logger = LoggerFactory.getLogger(CytoscapeJsVisualStyleSerializer.class);
    private static final Pattern REPLACE_INVALID_JS_CHAR_PATTERN = Pattern.compile("^[^a-zA-Z_]+|[^a-zA-Z_0-9]+");
    private static final DecimalFormat DF = new DecimalFormat();
    private static final Collection<VisualProperty<?>> NODE_SELECTED_PROPERTIES = new ArrayList();
    private static final Collection<VisualProperty<?>> EDGE_SELECTED_PROPERTIES = new ArrayList();
    private final VisualMappingSerializer<PassthroughMapping<?, ?>> passthrough = new PassthroughMappingSerializer();
    private final CytoscapeJsStyleConverter converter;
    private final VisualLexicon lexicon;
    private final ValueSerializerManager manager;
    private final String version;
    private final CyNetworkViewManager viewManager;

    public CytoscapeJsVisualStyleSerializer(ValueSerializerManager manager, VisualLexicon lexicon, CyVersion cyVersion, CyNetworkViewManager viewManager) {
        this.manager = manager;
        this.viewManager = viewManager;
        this.converter = new CytoscapeJsStyleConverter();
        this.lexicon = lexicon;
        this.version = cyVersion.getVersion();
        DF.setMaximumFractionDigits(8);
    }

    public void serialize(VisualStyle vs, JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.useDefaultPrettyPrinter();
        jg.writeStartObject();
        jg.writeStringField("format_version", "1.0");
        jg.writeStringField("generated_by", "cytoscape-" + this.version);
        jg.writeStringField("target_cytoscapejs_version", "~2.1");
        jg.writeStringField(CytoscapeJsToken.TITLE.getTag(), vs.getTitle());
        jg.writeArrayFieldStart(CytoscapeJsToken.STYLE.getTag());
        this.serializeVisualProperties(BasicVisualLexicon.NODE, vs, jg);
        this.serializeMappings(BasicVisualLexicon.NODE, vs, jg, CyNode.class);
        this.serializeBypass(BasicVisualLexicon.NODE, vs, jg, CyNode.class);
        this.serializeSelectedProperties(BasicVisualLexicon.NODE, vs, jg);
        this.serializeVisualProperties(BasicVisualLexicon.EDGE, vs, jg);
        this.serializeMappings(BasicVisualLexicon.EDGE, vs, jg, CyEdge.class);
        this.serializeBypass(BasicVisualLexicon.EDGE, vs, jg, CyEdge.class);
        this.serializeSelectedProperties(BasicVisualLexicon.EDGE, vs, jg);
        jg.writeEndArray();
        jg.writeEndObject();
    }

    private final void serializeVisualProperties(VisualProperty<?> vp, VisualStyle vs, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        jg.writeStringField(CytoscapeJsToken.SELECTOR.getTag(), vp.getIdString().toLowerCase());
        jg.writeObjectFieldStart(CytoscapeJsToken.CSS.getTag());
        Collection visualProperties = this.lexicon.getAllDescendants(vp);
        for (VisualProperty<?> removed : NODE_SELECTED_PROPERTIES) {
            visualProperties.remove(removed);
        }
        for (VisualProperty<?> removed : EDGE_SELECTED_PROPERTIES) {
            visualProperties.remove(removed);
        }
        this.createDefaults(visualProperties, vs, jg);
        this.createMappings(visualProperties, vs, jg);
        jg.writeEndObject();
        jg.writeEndObject();
    }

    private final void serializeSelectedProperties(VisualProperty<?> vp, VisualStyle vs, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        jg.writeStringField(CytoscapeJsToken.SELECTOR.getTag(), vp.getIdString().toLowerCase() + CytoscapeJsToken.SELECTED.getTag());
        jg.writeObjectFieldStart(CytoscapeJsToken.CSS.getTag());
        if (vp == BasicVisualLexicon.NODE) {
            this.createDefaults(NODE_SELECTED_PROPERTIES, vs, jg);
            this.createMappings(NODE_SELECTED_PROPERTIES, vs, jg);
        } else {
            this.createDefaults(EDGE_SELECTED_PROPERTIES, vs, jg);
            this.createMappings(EDGE_SELECTED_PROPERTIES, vs, jg);
        }
        jg.writeEndObject();
        jg.writeEndObject();
    }

    private final void serializeMappings(VisualProperty<?> vp, VisualStyle vs, JsonGenerator jg, Class<? extends CyIdentifiable> target) throws IOException {
        Collection mappings = vs.getAllVisualMappingFunctions();
        for (VisualMappingFunction mapping : mappings) {
            VisualProperty mappingVp;
            CytoscapeJsToken tag;
            if (mapping.getVisualProperty().getTargetDataType() != target || (tag = this.converter.getTag(mappingVp = mapping.getVisualProperty())) == null && mappingVp != BasicVisualLexicon.NODE_SIZE && mappingVp != BasicVisualLexicon.EDGE_UNSELECTED_PAINT) continue;
            if (mapping instanceof DiscreteMapping) {
                this.generateDiscreteMappingSection(tag, (DiscreteMapping)mapping, vp, vs, jg);
                continue;
            }
            if (!(mapping instanceof ContinuousMapping) || tag == null) continue;
            if (mappingVp == BasicVisualLexicon.NODE_SIZE) {
                this.generateContinuousMappingSection(CytoscapeJsToken.WIDTH, (ContinuousMapping)mapping, vp, vs, jg);
                this.generateContinuousMappingSection(CytoscapeJsToken.HEIGHT, (ContinuousMapping)mapping, vp, vs, jg);
                continue;
            }
            this.generateContinuousMappingSection(tag, (ContinuousMapping)mapping, vp, vs, jg);
        }
    }

    private final void serializeBypass(VisualProperty<?> root, VisualStyle vs, JsonGenerator jg, Class<? extends CyIdentifiable> type) throws IOException {
        Collection visualProperties = this.lexicon.getAllDescendants(root);
        this.createBypassMappings(visualProperties, vs, jg, type);
    }

    private final void generateContinuousMappingSection(CytoscapeJsToken jsTag, ContinuousMapping<?, ?> mapping, VisualProperty<?> vp, VisualStyle vs, JsonGenerator jg) throws IOException {
        Class type = mapping.getVisualProperty().getRange().getType();
        VisualProperty targetVP = mapping.getVisualProperty();
        String columnName = mapping.getMappingColumnName();
        Matcher matcher = REPLACE_INVALID_JS_CHAR_PATTERN.matcher(columnName);
        columnName = matcher.replaceAll("_");
        List points = mapping.getAllPoints();
        String objectType = vp.getIdString().toLowerCase();
        if (points.size() == 0) {
            return;
        }
        if (points.size() == 1) {
            ContinuousMappingPoint point = (ContinuousMappingPoint)points.get(0);
            Number bound = (Number)point.getValue();
            this.writeSelector(targetVP, jg, point.getRange().lesserValue, "<", objectType, columnName, jsTag.getTag(), bound);
            this.writeSelector(targetVP, jg, point.getRange().equalValue, "=", objectType, columnName, jsTag.getTag(), bound);
            this.writeSelector(targetVP, jg, point.getRange().greaterValue, ">", objectType, columnName, jsTag.getTag(), bound);
            return;
        }
        TreeMap<Number, ContinuousMappingPoint> pointMap = new TreeMap<Number, ContinuousMappingPoint>();
        for (Object point : points) {
            ContinuousMappingPoint p = (ContinuousMappingPoint)point;
            Number val = (Number)p.getValue();
            pointMap.put(val, p);
        }
        ValueSerializer serializer = this.manager.getSerializer(type);
        ContinuousMappingPoint prevPoint = null;
        for (Number key : pointMap.descendingKeySet()) {
            ContinuousMappingPoint point = (ContinuousMappingPoint)pointMap.get(key);
            Number bound = (Number)point.getValue();
            if (key.equals(pointMap.lastKey())) {
                this.writeSelector(targetVP, jg, point.getRange().greaterValue, ">", objectType, columnName, jsTag.getTag(), bound);
                this.writeSelector(targetVP, jg, point.getRange().equalValue, "=", objectType, columnName, jsTag.getTag(), bound);
                prevPoint = point;
                continue;
            }
            if (key.equals(pointMap.firstKey())) {
                this.generateMap(jg, columnName, objectType, jsTag.getTag(), point, prevPoint, serializer);
                this.writeSelector(targetVP, jg, point.getRange().equalValue, "=", objectType, columnName, jsTag.getTag(), bound);
                this.writeSelector(targetVP, jg, point.getRange().lesserValue, "<", objectType, columnName, jsTag.getTag(), bound);
                continue;
            }
            this.generateMap(jg, columnName, objectType, jsTag.getTag(), point, prevPoint, serializer);
            prevPoint = point;
        }
    }

    private final void generateMap(JsonGenerator jg, String columnName, String objectType, String tag, ContinuousMappingPoint<?, ?> point, ContinuousMappingPoint<?, ?> prevPoint, ValueSerializer serializer) throws IOException {
        Object lowerVal = point.getRange().greaterValue;
        Object upperVal = prevPoint.getRange().lesserValue;
        String lowerValString = lowerVal.toString();
        String upperValString = upperVal.toString();
        if (serializer != null) {
            lowerValString = serializer.serialize(lowerVal);
            upperValString = serializer.serialize(upperVal);
        }
        String map = "mapData(" + columnName + ",";
        map = map + DF.format(point.getValue()) + "," + DF.format(prevPoint.getValue()) + "," + lowerValString + "," + upperValString + ")";
        this.writeMapSelector(jg, map, objectType, columnName, tag, (Number)point.getValue(), (Number)prevPoint.getValue());
    }

    private final void writeMapSelector(JsonGenerator jg, Object value, String objectType, String colName, String jsTag, Number boundL, Number boundU) throws IOException {
        jg.writeStartObject();
        String tag = objectType + "[" + colName + " > ";
        tag = tag + DF.format(boundL) + "][" + colName + " < " + DF.format(boundU) + "]";
        jg.writeStringField(CytoscapeJsToken.SELECTOR.getTag(), tag);
        jg.writeObjectFieldStart(CytoscapeJsToken.CSS.getTag());
        jg.writeObjectField(jsTag, value);
        jg.writeEndObject();
        jg.writeEndObject();
    }

    private final void writeSelector(VisualProperty<?> vp, JsonGenerator jg, Object value, String operator, String objectType, String colName, String jsTag, Number bound) throws IOException {
        jg.writeStartObject();
        String tag = objectType + "[" + colName + " " + operator + " ";
        tag = tag + DF.format(bound) + "]";
        jg.writeStringField(CytoscapeJsToken.SELECTOR.getTag(), tag);
        jg.writeObjectFieldStart(CytoscapeJsToken.CSS.getTag());
        jg.writeObjectField(jsTag, this.convert(vp, value));
        jg.writeEndObject();
        jg.writeEndObject();
    }

    private final void generateDiscreteMappingSection(CytoscapeJsToken jsTag, DiscreteMapping<?, ?> mapping, VisualProperty<?> vp, VisualStyle vs, JsonGenerator jg) throws IOException {
        Map mappingPairs = mapping.getAll();
        Set locks = vs.getAllVisualPropertyDependencies();
        boolean sizeLocked = false;
        for (VisualPropertyDependency lock : locks) {
            if (!lock.getIdString().equals("nodeSizeLocked")) continue;
            sizeLocked = true;
        }
        String colName = mapping.getMappingColumnName();
        Matcher matcher = REPLACE_INVALID_JS_CHAR_PATTERN.matcher(colName);
        colName = matcher.replaceAll("_");
        Class colType = mapping.getMappingColumnType();
        ArrayList<Boolean> orderedMappingKeys = new ArrayList<Boolean>();
        Set keys = mappingPairs.keySet();
        if (colType == Boolean.class) {
            if (keys.contains(true) && keys.contains(false)) {
                orderedMappingKeys.add(Boolean.TRUE);
                orderedMappingKeys.add(Boolean.FALSE);
            } else {
                orderedMappingKeys.addAll(keys);
            }
        } else {
            orderedMappingKeys.addAll(keys);
        }
        for (Object e : orderedMappingKeys) {
            Object value = this.convert(mapping.getVisualProperty(), mappingPairs.get(e));
            jg.writeStartObject();
            Object tag = "";
            tag = colType == Boolean.class ? (((Boolean)e).booleanValue() ? vp.getIdString().toLowerCase() + "[" + colName + "]" : vp.getIdString().toLowerCase() + "[!" + colName + "]") : (colType == Integer.class || colType == Double.class || colType == Float.class || colType == Long.class ? vp.getIdString().toLowerCase() + "[" + colName + " = " + e + "]" : vp.getIdString().toLowerCase() + "[" + colName + " = '" + e + "']");
            jg.writeStringField(CytoscapeJsToken.SELECTOR.getTag(), (String)tag);
            jg.writeObjectFieldStart(CytoscapeJsToken.CSS.getTag());
            if (sizeLocked && mapping.getVisualProperty() == BasicVisualLexicon.NODE_SIZE) {
                jg.writeObjectField(CytoscapeJsToken.WIDTH.getTag(), value);
                jg.writeObjectField(CytoscapeJsToken.HEIGHT.getTag(), value);
            } else if (mapping.getVisualProperty() == BasicVisualLexicon.EDGE_UNSELECTED_PAINT) {
                jg.writeObjectField(CytoscapeJsToken.LINE_COLOR.getTag(), value);
                jg.writeObjectField(CytoscapeJsToken.TARGET_ARROW_COLOR.getTag(), value);
                jg.writeObjectField(CytoscapeJsToken.SOURCE_ARROW_COLOR.getTag(), value);
            } else {
                jg.writeObjectField(jsTag.getTag(), value);
            }
            jg.writeEndObject();
            jg.writeEndObject();
        }
    }

    private void createDefaults(Collection<VisualProperty<?>> visualProperties, VisualStyle vs, JsonGenerator jg) throws IOException {
        Set deps = vs.getAllVisualPropertyDependencies();
        boolean useSize = false;
        boolean useStroke = false;
        for (VisualPropertyDependency visualPropertyDependency : deps) {
            if (visualPropertyDependency.getIdString().equals("nodeSizeLocked") && visualPropertyDependency.isDependencyEnabled()) {
                useSize = true;
            }
            if (!visualPropertyDependency.getIdString().equals("arrowColorMatchesEdge") || !visualPropertyDependency.isDependencyEnabled()) continue;
            useStroke = true;
        }
        for (VisualProperty visualProperty : visualProperties) {
            CytoscapeJsToken tag;
            VisualMappingFunction mapping = vs.getVisualMappingFunction(visualProperty);
            if (mapping != null && mapping instanceof PassthroughMapping || (tag = this.converter.getTag(visualProperty)) == null || !this.writeValue(visualProperty, vs, jg, useSize, useStroke)) continue;
            Object defaultValue = this.getDefaultVisualPropertyValue(vs, visualProperty);
            jg.writeObjectField(tag.getTag(), defaultValue);
        }
    }

    private void createBypassMappings(Collection<VisualProperty<?>> vps, VisualStyle vs, JsonGenerator jg, Class<? extends CyIdentifiable> type) throws IOException {
        Set views = this.viewManager.getNetworkViewSet();
        if (type.equals(CyNode.class)) {
            views.stream().flatMap(view -> view.getNodeViews().stream()).forEach(nodeView -> this.writeBypass((View<? extends CyIdentifiable>)nodeView, vps, jg, type));
        } else if (type.equals(CyEdge.class)) {
            views.stream().flatMap(view -> view.getEdgeViews().stream()).forEach(edgeView -> this.writeBypass((View<? extends CyIdentifiable>)edgeView, vps, jg, type));
        }
    }

    private final void writeBypass(View<? extends CyIdentifiable> view, Collection<VisualProperty<?>> vps, JsonGenerator jg, Class<? extends CyIdentifiable> type) {
        HashSet bypassVpSet = new HashSet();
        for (VisualProperty<?> vp : vps) {
            boolean lock1 = view.isValueLocked(vp);
            boolean lock2 = view.isDirectlyLocked(vp);
            if (!lock1 && !lock2) continue;
            bypassVpSet.add(vp);
        }
        if (bypassVpSet.isEmpty()) {
            return;
        }
        String objTypeString = null;
        if (type.equals(CyNode.class)) {
            objTypeString = "node";
        } else if (type.equals(CyEdge.class)) {
            objTypeString = "edge";
        } else {
            return;
        }
        try {
            jg.writeStartObject();
            String mappingString = objTypeString + "[ id = '" + ((CyIdentifiable)view.getModel()).getSUID().toString() + "' ]";
            jg.writeStringField(CytoscapeJsToken.SELECTOR.getTag(), mappingString);
            jg.writeObjectFieldStart(CytoscapeJsToken.CSS.getTag());
            this.writeBypassVp(view, bypassVpSet, jg);
            jg.writeEndObject();
            jg.writeEndObject();
        }
        catch (Exception e) {
            logger.warn("Could not write bypass entry", (Throwable)e);
        }
    }

    private final void writeBypassVp(View<? extends CyIdentifiable> view, Collection<VisualProperty<?>> vps, JsonGenerator jg) throws IOException {
        for (VisualProperty<?> vp : vps) {
            CytoscapeJsToken tag = this.converter.getTag(vp);
            if (tag == null) continue;
            Object originalValue = view.getVisualProperty(vp);
            Object value = this.convert(vp, originalValue);
            jg.writeObjectField(tag.getTag(), value);
        }
    }

    private final boolean writeValue(VisualProperty<?> vp, VisualStyle vs, JsonGenerator jg, boolean sizeLock, boolean arrowLock) throws JsonProcessingException, IOException {
        if (vp == BasicVisualLexicon.EDGE_TRANSPARENCY || vp == BasicVisualLexicon.EDGE_LABEL_TRANSPARENCY || vp == BasicVisualLexicon.NODE_LABEL_TRANSPARENCY || vp == BasicVisualLexicon.NODE_TRANSPARENCY || vp == BasicVisualLexicon.NODE_BORDER_TRANSPARENCY) {
            Integer defaultValue = (Integer)this.getDefaultVisualPropertyValue(vs, vp);
            double doubleValue = (double)defaultValue.intValue() / 255.0;
            jg.writeNumberField(this.converter.getTag(vp).getTag(), doubleValue);
            return false;
        }
        if (vp == BasicVisualLexicon.NODE_WIDTH || vp == BasicVisualLexicon.NODE_HEIGHT) {
            if (sizeLock) {
                Double size = (Double)this.getDefaultVisualPropertyValue(vs, BasicVisualLexicon.NODE_SIZE);
                jg.writeNumberField(this.converter.getTag(vp).getTag(), size.doubleValue());
                return false;
            }
            return true;
        }
        if (vp == BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT || vp.getIdString().equals("EDGE_TARGET_ARROW_UNSELECTED_PAINT") || vp.getIdString().equals("EDGE_SOURCE_ARROW_UNSELECTED_PAINT")) {
            if (arrowLock) {
                Paint color = (Paint)this.getDefaultVisualPropertyValue(vs, BasicVisualLexicon.EDGE_UNSELECTED_PAINT);
                jg.writeObjectField(this.converter.getTag(vp).getTag(), (Object)color);
                return false;
            }
            return true;
        }
        if (vp.getIdString().equals("NODE_LABEL_POSITION")) {
            Object labelPosition = this.getDefaultVisualPropertyValue(vs, vp);
            String valText = labelPosition.toString();
            this.writeLabelPosition(jg, valText);
            return false;
        }
        return true;
    }

    private final void writeLabelPosition(JsonGenerator jg, String valText) throws JsonGenerationException, IOException {
        String[] parts = valText.split("\\s+");
        String position = parts[1];
        String positionObject = parts[3];
        if (position.equals("North") || position.equals("Northeast") || position.equals("Northwest")) {
            jg.writeStringField(CytoscapeJsToken.TEXT_VALIGN.getTag(), "top");
        } else if (position.equals("Center") || position.equals("East") || position.equals("West")) {
            jg.writeStringField(CytoscapeJsToken.TEXT_VALIGN.getTag(), "center");
        } else {
            jg.writeStringField(CytoscapeJsToken.TEXT_VALIGN.getTag(), "bottom");
        }
        if (position.equals("West") || position.equals("Northwest") || position.equals("Southwest")) {
            jg.writeStringField(CytoscapeJsToken.TEXT_HALIGN.getTag(), "left");
        } else if (position.equals("East") || position.equals("Northeast") || position.equals("Southeast")) {
            jg.writeStringField(CytoscapeJsToken.TEXT_HALIGN.getTag(), "right");
        } else if (positionObject.equals("Northwest") || positionObject.equals("West") || positionObject.equals("Southwest")) {
            jg.writeStringField(CytoscapeJsToken.TEXT_HALIGN.getTag(), "right");
        } else if (positionObject.equals("East") || positionObject.equals("Northeast") || positionObject.equals("Southeast")) {
            jg.writeStringField(CytoscapeJsToken.TEXT_HALIGN.getTag(), "left");
        } else {
            jg.writeStringField(CytoscapeJsToken.TEXT_HALIGN.getTag(), "center");
        }
    }

    private Object convert(VisualProperty<?> vp, Object originalValue) {
        if (vp == BasicVisualLexicon.EDGE_TRANSPARENCY || vp == BasicVisualLexicon.EDGE_LABEL_TRANSPARENCY || vp == BasicVisualLexicon.NODE_LABEL_TRANSPARENCY || vp == BasicVisualLexicon.NODE_TRANSPARENCY || vp == BasicVisualLexicon.NODE_BORDER_TRANSPARENCY) {
            return (double)((Integer)originalValue).intValue() / 255.0;
        }
        if (vp.getIdString().equals("NODE_LABEL_POSITION")) {
            String valText = originalValue.toString();
            String[] parts = valText.split(" ");
            String position = parts[1];
            if (position.equals("North") || position.equals("Northeast") || position.equals("Northwest")) {
                return "top";
            }
            if (position.equals("Center") || position.equals("East") || position.equals("West")) {
                return "center";
            }
            return "bottom";
        }
        return originalValue;
    }

    private final <T> T getDefaultVisualPropertyValue(VisualStyle vs, VisualProperty<T> vp) {
        Object value = vs.getDefaultValue(vp);
        if (value == null) {
            return (T)vp.getDefault();
        }
        return (T)value;
    }

    private void createMappings(Collection<VisualProperty<?>> visualProperties, VisualStyle vs, JsonGenerator jg) throws IOException {
        for (VisualProperty<?> vp : visualProperties) {
            CytoscapeJsToken jsTag;
            VisualMappingFunction mapping = vs.getVisualMappingFunction(vp);
            if (mapping == null || mapping instanceof DiscreteMapping || (jsTag = this.converter.getTag(mapping.getVisualProperty())) == null && mapping.getVisualProperty() != BasicVisualLexicon.NODE_SIZE || !(mapping instanceof PassthroughMapping)) continue;
            if (mapping.getVisualProperty() == BasicVisualLexicon.NODE_SIZE) {
                jg.writeStringField(CytoscapeJsToken.WIDTH.getTag(), this.passthrough.serialize((PassthroughMapping)mapping));
                jg.writeStringField(CytoscapeJsToken.HEIGHT.getTag(), this.passthrough.serialize((PassthroughMapping)mapping));
                continue;
            }
            jg.writeStringField(jsTag.getTag(), this.passthrough.serialize((PassthroughMapping)mapping));
        }
    }

    public Class<VisualStyle> handledType() {
        return VisualStyle.class;
    }

    static {
        EDGE_SELECTED_PROPERTIES.add(BasicVisualLexicon.EDGE_STROKE_SELECTED_PAINT);
        EDGE_SELECTED_PROPERTIES.add(BasicVisualLexicon.EDGE_SELECTED_PAINT);
        NODE_SELECTED_PROPERTIES.add(BasicVisualLexicon.NODE_SELECTED_PAINT);
    }
}

