/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.json.serializer;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.cytoscape.io.internal.write.json.serializer.CytoscapeJsToken;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;

public class CyJacksonModule
extends SimpleModule {
    private static final long serialVersionUID = -2618300407121070693L;

    public CyJacksonModule() {
        super("CyJacksonModule", new Version(1, 0, 0, null, null, null));
        this.addSerializer(new CyNodeSerializer());
        this.addSerializer(new CyEdgeSerializer());
        this.addSerializer(new CyRowSerializer());
        this.addSerializer(new CyTableSerializer());
        this.addSerializer(new CyNetworkSerializer());
    }

    private static final void writeNodeInfo(CyNode node, JsonGenerator jgen) throws JsonGenerationException, IOException {
        if (node.getNetworkPointer() != null) {
            jgen.writeNumberField("nestedNetwork", node.getNetworkPointer().getSUID().longValue());
        }
    }

    private static final void writeEdgeInfo(CyEdge edge, JsonGenerator jgen) throws JsonGenerationException, IOException {
        jgen.writeNumberField("source", edge.getSource().getSUID().longValue());
        jgen.writeNumberField("target", edge.getTarget().getSUID().longValue());
        jgen.writeBooleanField("isDirected", edge.isDirected());
    }

    private class CyRowSerializer
    extends JsonSerializer<CyRow> {
        private CyRowSerializer() {
        }

        public void serialize(CyRow row, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            CyTable table = row.getTable();
            Map values = row.getAllValues();
            for (String key : values.keySet()) {
                Object value = values.get(key);
                if (value == null) continue;
                Class type = table.getColumn(key).getType();
                if (type == List.class) {
                    type = table.getColumn(key).getListElementType();
                    this.writeList(type, key, (List)value, jgen);
                    continue;
                }
                this.write(type, key, value, jgen);
            }
        }

        private void writeList(Class<?> type, String fieldName, List<?> values, JsonGenerator jgen) throws JsonGenerationException, IOException {
            jgen.writeFieldName(fieldName);
            jgen.writeStartArray();
            for (Object value : values) {
                this.writeValue(type, value, jgen);
            }
            jgen.writeEndArray();
        }

        private void write(Class<?> type, String fieldName, Object value, JsonGenerator jgen) throws JsonGenerationException, IOException {
            jgen.writeFieldName(fieldName);
            this.writeValue(type, value, jgen);
        }

        private final void writeValue(Class<?> type, Object value, JsonGenerator jgen) throws JsonGenerationException, IOException {
            jgen.writeStartObject();
            if (type == String.class) {
                jgen.writeStringField("type", "string");
                jgen.writeStringField("value", (String)value);
            } else if (type == Boolean.class) {
                jgen.writeStringField("type", "boolean");
                jgen.writeBooleanField("value", ((Boolean)value).booleanValue());
            } else if (type == Double.class) {
                jgen.writeStringField("type", "double");
                jgen.writeNumberField("value", ((Double)value).doubleValue());
            } else if (type == Integer.class) {
                jgen.writeStringField("type", "integer");
                jgen.writeNumberField("value", ((Integer)value).intValue());
            } else if (type == Long.class) {
                jgen.writeStringField("type", "long");
                jgen.writeNumberField("value", ((Long)value).longValue());
            } else if (type == Float.class) {
                jgen.writeStringField("type", "double");
                jgen.writeNumberField("value", ((Float)value).floatValue());
            }
            jgen.writeEndObject();
        }

        public Class<CyRow> handledType() {
            return CyRow.class;
        }
    }

    private class CyTableSerializer
    extends JsonSerializer<CyTable> {
        private CyTableSerializer() {
        }

        public void serialize(CyTable table, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeEndObject();
        }

        public Class<CyTable> handledType() {
            return CyTable.class;
        }
    }

    private class CyEdgeSerializer
    extends JsonSerializer<CyEdge> {
        private CyEdgeSerializer() {
        }

        public void serialize(CyEdge edge, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            CyJacksonModule.writeEdgeInfo(edge, jgen);
            jgen.writeEndObject();
        }

        public Class<CyEdge> handledType() {
            return CyEdge.class;
        }
    }

    private class CyNodeSerializer
    extends JsonSerializer<CyNode> {
        private CyNodeSerializer() {
        }

        public void serialize(CyNode node, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            CyJacksonModule.writeNodeInfo(node, jgen);
            jgen.writeEndObject();
        }

        public Class<CyNode> handledType() {
            return CyNode.class;
        }
    }

    private final class CyNetworkSerializer
    extends JsonSerializer<CyNetwork> {
        private CyNetworkSerializer() {
        }

        public void serialize(CyNetwork network, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeObjectFieldStart("network");
            jgen.writeObject((Object)network.getRow((CyIdentifiable)network));
            List nodes = network.getNodeList();
            List edges = network.getEdgeList();
            jgen.writeArrayFieldStart(CytoscapeJsToken.NODES.getTag());
            for (CyNode node : nodes) {
                jgen.writeStartObject();
                CyJacksonModule.writeNodeInfo(node, jgen);
                jgen.writeObject((Object)network.getRow((CyIdentifiable)node));
                jgen.writeEndObject();
            }
            jgen.writeEndArray();
            jgen.writeArrayFieldStart(CytoscapeJsToken.EDGES.getTag());
            for (CyEdge edge : edges) {
                jgen.writeStartObject();
                CyJacksonModule.writeEdgeInfo(edge, jgen);
                jgen.writeObject((Object)network.getRow((CyIdentifiable)edge));
                jgen.writeEndObject();
            }
            jgen.writeEndArray();
            jgen.writeEndObject();
        }

        public Class<CyNetwork> handledType() {
            return CyNetwork.class;
        }
    }
}

