/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.task.AbstractNetworkTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONNetworkWriter
extends AbstractNetworkTask
implements CyWriter {
    private static final Logger logger = LoggerFactory.getLogger(JSONNetworkWriter.class);
    private static final String ENCODING = "UTF-8";
    protected final OutputStream outputStream;
    protected final ObjectMapper network2jsonMapper;
    protected final CharsetEncoder encoder;

    public JSONNetworkWriter(OutputStream outputStream, CyNetwork network, ObjectMapper network2jsonMapper) {
        super(network);
        this.outputStream = outputStream;
        this.network2jsonMapper = network2jsonMapper;
        if (Charset.isSupported(ENCODING)) {
            this.encoder = Charset.forName(ENCODING).newEncoder();
        } else {
            logger.warn("UTF-8 is not supported by this system.  This can be a problem for non-Roman annotations.");
            this.encoder = Charset.defaultCharset().newEncoder();
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (taskMonitor != null) {
            taskMonitor.setTitle("Writing to JSON...");
            taskMonitor.setProgress(0.0);
        }
        this.network2jsonMapper.writeValue(this.outputStream, (Object)this.network);
    }
}

