/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.Map;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.internal.read.json.CytoscapejsMapper;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.util.ListSingleSelection;

public class CytoscapeJsNetworkReader
extends AbstractCyNetworkReader {
    private final CytoscapejsMapper mapper;
    private CyNetwork network = null;
    private final InputStream is;
    private final String networkCollectionName;

    public CytoscapeJsNetworkReader(String networkCollectionName, InputStream is, CyApplicationManager cyApplicationManager, CyNetworkFactory cyNetworkFactory, CyNetworkManager cyNetworkManager, CyRootNetworkManager cyRootNetworkManager) {
        super(is, cyApplicationManager, cyNetworkFactory, cyNetworkManager, cyRootNetworkManager);
        this.networkCollectionName = networkCollectionName;
        if (is == null) {
            throw new NullPointerException("Input Stream cannot be null.");
        }
        this.mapper = new CytoscapejsMapper();
        this.is = is;
    }

    public CyNetwork[] getNetworks() {
        CyNetwork[] result = new CyNetwork[]{this.network};
        return result;
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        CyNetworkView view = this.getNetworkViewFactory().createNetworkView(network);
        Map<CyNode, Double[]> positionMap = this.mapper.getNodePosition();
        for (CyNode node : positionMap.keySet()) {
            Double[] position = positionMap.get(node);
            view.getNodeView(node).setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)position[0]);
            view.getNodeView(node).setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)position[1]);
        }
        return view;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        CySubNetwork subNetwork;
        ListSingleSelection rootList;
        ObjectMapper objMapper = new ObjectMapper();
        JsonNode rootNode = (JsonNode)objMapper.readValue(this.is, JsonNode.class);
        if (this.networkCollectionName != null && (rootList = this.getRootNetworkList()).getPossibleValues().contains(this.networkCollectionName)) {
            rootList.setSelectedValue((Object)this.networkCollectionName);
        }
        CyRootNetwork rootNetwork = this.getRootNetwork();
        String collectionName = null;
        if (rootNetwork != null) {
            subNetwork = rootNetwork.addSubNetwork();
        } else {
            subNetwork = (CySubNetwork)this.cyNetworkFactory.createNetwork();
            collectionName = this.networkCollectionName;
        }
        this.network = rootNode.isArray() ? this.mapper.createNetworkFromElementList(rootNode, (CyNetwork)subNetwork, collectionName) : this.mapper.createNetwork(rootNode, (CyNetwork)subNetwork, collectionName);
    }
}

