/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.internal.color;

import java.awt.Color;

public enum Viridis {
    Viridis("viridis", "Viridis perceptually balanced palette", new int[]{16639781, 16508707, 16311841, 16180768, 16049694, 15852829, 15721756, 15525147, 15394074, 15197209, 15066137, 14869528, 14672664, 14541592, 14344985, 14213657, 14017050, 13820443, 13689116, 13492509, 13295903, 13164576, 12967969, 12771107, 12640037, 12443430, 12246568, 12115497, 11918891, 0xB2DD2D, 11590959, 11394096, 11197490, 11066164, 10869558, 10672695, 10541625, 10344763, 10213692, 10016830, 9820224, 9688897, 9492291, 9360965, 9164358, 9033032, 8836425, 8705099, 8508237, 8377166, 8180304, 8048977, 7852371, 7721044, 7589974, 7393111, 7261784, 7130458, 6933851, 6802524, 6671198, 6540127, 6343264, 6211938, 6080611, 5949540, 5818213, 5686887, 5555560, 5424489, 5293162, 5161835, 5030508, 4899181, 4768110, 4636783, 4505456, 4374129, 4242802, 4177011, 4045940, 3914613, 3848822, 3717495, 3651704, 3520377, 3454585, 3323514, 3257723, 3126396, 3060604, 2994813, 2929022, 2797695, 2731903, 2666112, 2600321, 2534785, 2468994, 2468738, 2402947, 2337155, 2271364, 2271109, 2205317, 2205061, 2139270, 2139014, 2073223, 2072967, 2072968, 2072712, 2072456, 2072201, 2006409, 2006153, 2005898, 2071178, 2070922, 2070667, 2070411, 2070155, 2069899, 2069644, 2134924, 2134668, 2134668, 2199948, 2199693, 2199437, 2199181, 0x228D8D, 2264205, 2263949, 2329229, 2328974, 2328718, 2393998, 2393742, 2459022, 2458766, 2458510, 2523790, 2523790, 2523534, 2588814, 2588558, 2588302, 2653582, 2653326, 2718606, 2718350, 2718094, 2783374, 2783118, 2782862, 2848142, 2847886, 2913166, 2912910, 2912654, 2978190, 2977934, 3043214, 3042958, 3042702, 3107982, 3107726, 3173006, 3172750, 3238030, 3237774, 3237518, 3302798, 3302542, 3367821, 3367565, 3432845, 3432589, 3497869, 3497613, 3562893, 3562637, 3627917, 3627660, 3692940, 3692684, 3757708, 3757452, 3822732, 3822475, 3887755, 3887499, 3952779, 3952522, 4017802, 4017546, 4082826, 4082313, 4082057, 4147337, 4147080, 4212360, 4212104, 4277383, 4276871, 4342150, 4341894, 4341637, 4406917, 4406660, 4471684, 4471427, 4471171, 4536450, 4536193, 4535681, 4600960, 4600703, 4600446, 4599934, 4665213, 4664956, 4664699, 4664442, 4663930, 4729209, 4728952, 4728439, 4728182, 4727925, 4727668, 4727155, 4726897, 4726640, 4726127, 4725870, 4725613, 4725356, 4724842, 4724585, 4724328, 4723815, 4658021, 4657508, 4657251, 4656737, 4656480, 4590430, 4590173, 4589660, 4589402, 4523353, 4523095, 4457046, 4456788}),
    Plasma("plasma", "Plasma perceptually balanced palette", new int[]{15792417, 15791908, 15856933, 15856678, 0xF2F227, 15986727, 15986215, 16051495, 16116519, 16116006, 16181286, 16180774, 16245797, 16245285, 16310565, 16310053, 16375077, 16374820, 16439844, 16439332, 16504612, 16504100, 16503588, 16568869, 16568357, 16567845, 16567589, 16632614, 16632358, 16631847, 16631335, 16631079, 16630568, 16630313, 16695337, 16694826, 16694570, 16694059, 16693804, 16693292, 16693037, 16626990, 16626735, 16626223, 16625968, 16625457, 16625202, 16624691, 16624435, 16558388, 16558133, 16557622, 16557367, 16556856, 16491064, 16490809, 16490298, 16424507, 16423996, 16423741, 16357950, 16357438, 16357183, 16291136, 16290881, 16225090, 16224579, 16224324, 16158532, 16158021, 16092230, 16091975, 16025928, 16025673, 15959882, 15959371, 15893579, 15827788, 15827277, 15761486, 15761231, 15695440, 15694929, 15629137, 15563346, 15563091, 15497044, 15431253, 15430998, 15365207, 15299159, 15298904, 15233113, 15167322, 15167067, 15101020, 15035229, 15034973, 14969182, 14903391, 14837344, 14837089, 14771298, 14705507, 14639715, 14573924, 14573413, 14507622, 14441831, 14376040, 14310249, 14309994, 14243946, 14178155, 14112364, 0xD6556D, 13980782, 13980527, 13914736, 13848945, 13782897, 13717106, 13651315, 13585524, 13519733, 13453942, 13388151, 13387640, 13321849, 13256058, 13190266, 13124475, 13058684, 12992893, 12927102, 12861055, 12795264, 12729473, 12663682, 12597891, 12532100, 12466309, 12400518, 12334471, 12268680, 12202888, 12071561, 12005770, 11939979, 11874188, 11808397, 11742350, 11676559, 11610768, 11544977, 11413650, 11347859, 11282068, 11216020, 11150229, 11018902, 10953111, 10887320, 10821529, 10690202, 10624410, 10558363, 10492572, 10361245, 10295453, 10229662, 10098335, 10032543, 9966752, 9835425, 9769377, 9703586, 9572259, 9506467, 9375140, 9309348, 9243557, 9112229, 9046437, 8915110, 8849318, 8783526, 8652199, 8586663, 8455335, 8389800, 8258472, 8192936, 8061608, 7996072, 7864744, 7799208, 7668136, 7602600, 7471528, 7405736, 7274664, 7209128, 7078056, 6946984, 6881448, 6750376, 6684839, 6553767, 6488231, 6357159, 6291878, 6160806, 6029734, 5964197, 5833125, 5767588, 5636516, 5571236, 5440163, 5309091, 5243554, 5112482, 4981409, 4916129, 4785056, 4719519, 4588447, 4457374, 4391838, 4261021, 4129948, 4064412, 3933339, 3802266, 3671194, 3605657, 3474584, 3343767, 3212695, 3081622, 3016085, 2885012, 2753939, 2622866, 2491793, 2360977, 2229904, 2098831, 1902222, 1771149, 1640076, 1443722, 1247113, 1050504, 854151}),
    Magma("magma", "Magma perceptually balanced palette", new int[]{16580031, 16579517, 16579003, 16578489, 16578232, 16577718, 16577204, 16576690, 16576176, 16575662, 16640940, 16640426, 16639913, 16639399, 16638885, 16638627, 16638113, 16637600, 16637086, 16636572, 16701594, 16701337, 16700823, 16700309, 16699796, 16699282, 16698768, 16698511, 16697997, 16697484, 16696970, 16696456, 16695943, 16695685, 16695172, 16694658, 16694145, 16693631, 16693118, 16692860, 16692347, 16691834, 16691320, 16690807, 16690294, 16689780, 16689523, 16689010, 16688497, 16687983, 16687470, 16686957, 16686444, 16620395, 16620138, 16619625, 16619112, 16618599, 16618086, 16552037, 16551524, 16551011, 16550498, 16550241, 16484193, 16483680, 16483167, 16417119, 16416606, 16416094, 16350045, 16349533, 16349277, 16283228, 16282716, 16216668, 16216156, 16150108, 16149596, 16083804, 16017756, 16017244, 15951196, 15885404, 15884893, 15818845, 15753054, 15687006, 0xEE5B5E, 15555167, 15489120, 15423328, 15357537, 15291490, 15225698, 15159907, 15028324, 14962532, 14896741, 14830950, 14699623, 14633576, 14567784, 14436457, 14370666, 14239339, 14173548, 14042476, 13976685, 13845358, 13779567, 13648239, 13582448, 13451377, 13385585, 13254258, 13123187, 13057395, 12926068, 12860533, 12729205, 12597878, 12532343, 12401015, 12335480, 12204152, 12072825, 12007289, 11875962, 11744890, 11679099, 11548027, 11416699, 11351164, 11219836, 11154301, 11022973, 10891645, 10826110, 10694782, 10563710, 10497919, 10366847, 10235519, 10169983, 10038656, 9973120, 9841792, 9710720, 9644928, 9513857, 9448065, 9316993, 9185665, 9120129, 8988801, 8923009, 8791937, 8660609, 8595073, 8463745, 8398210, 8266882, 8135554, 8070018, 7938690, 7873153, 7741825, 7676289, 7544961, 7479169, 7348097, 7216769, 7150977, 7019905, 6954113, 6823041, 6757248, 6625920, 6560384, 6429056, 6297728, 6232191, 6100863, 6035071, 5903998, 5838206, 5707134, 5641341, 5510013, 5378940, 5313148, 5182075, 5116283, 4985210, 4853881, 4788344, 4657272, 4526199, 4460406, 4329333, 4198260, 4132722, 4001649, 3870576, 3739502, 3674220, 3543147, 3412073, 3346535, 3215717, 3084643, 2953569, 2888031, 2756956, 2691418, 2560600, 0x251255, 2363987, 2232656, 2167118, 2101579, 1970505, 1904967, 1839172, 1708098, 1642559, 1576765, 1445691, 1379896, 1314358, 1248564, 1183025, 1117231, 1051437, 920363, 854569, 788774, 723236, 657442, 591648, 526110, 460316, 394522, 394520, 328726, 263188, 197394, 197391, 131597, 131595, 131337, 65800, 65798, 65541, 4}),
    Inferno("inferno", "Inferno perceptually balanced palette", new int[]{16580516, 16448929, 16383133, 16317338, 16186006, 16120210, 16054414, 15988362, 15988102, 15922306, 15921789, 15855993, 15855477, 15854961, 15854701, 15919721, 15919205, 15918689, 15983965, 15983450, 16048470, 16047955, 0xF4DD4F, 16112460, 16111945, 16176966, 16176451, 16241472, 16240957, 16305978, 16305463, 16370485, 16369970, 16369455, 16434733, 16434218, 16433704, 16433190, 16498211, 16497697, 16497183, 16496669, 16496154, 16561176, 16560662, 16560148, 16559634, 16559121, 16558607, 16558093, 16557580, 16557322, 16556809, 16556296, 16555783, 16489735, 16489222, 16488710, 16488198, 16487942, 16421895, 16421383, 16420872, 16354825, 16354314, 16354059, 16288012, 16287502, 16286991, 16221200, 16220690, 16154643, 16154132, 16088341, 16087831, 16021784, 15955993, 15955483, 15889436, 15823645, 0xF1711F, 15757088, 15691297, 15690787, 15624740, 15558949, 15492902, 15427112, 15426601, 15360810, 15294763, 15228973, 15162926, 15097135, 15031344, 14965297, 14899507, 14833460, 14767669, 14701878, 14635831, 14570040, 14504250, 14372923, 14306876, 14241085, 14175294, 14109503, 13978177, 13912130, 13846339, 13780548, 13649221, 13583430, 13517639, 13386312, 13320521, 13254730, 13123403, 13057612, 12991821, 12860494, 12794703, 12663376, 12597841, 12532050, 12400723, 12334932, 12203605, 12137814, 12006743, 11940952, 11809625, 11743834, 11612762, 11546971, 11415644, 11350109, 11218782, 11087454, 11021919, 10890592, 10824800, 10693729, 10627938, 10496611, 10431075, 10299748, 10168676, 10102885, 9971558, 9906022, 9774695, 9643623, 9577832, 9446760, 9380969, 9249641, 9184105, 9052778, 8921706, 8855915, 8724843, 8659051, 8527980, 8396652, 8330860, 8199789, 8133997, 8002925, 7871597, 7806061, 7674734, 7608942, 7477870, 7412078, 7281006, 7149678, 7084142, 6952814, 6887022, 6755950, 6624622, 6559086, 6427758, 6361966, 6230894, 6099566, 6034030, 5902702, 5836910, 5705838, 5574509, 5508973, 5377645, 5312108, 5180780, 5049708, 4983915, 4852843, 4787050, 4655978, 4524649, 4459112, 4328040, 4196967, 4065638, 4000101, 3869028, 3737955, 3672418, 3541345, 3410527, 3279454, 3213916, 3082843, 2952025, 2820951, 2689877, 2624339, 2493521, 2362447, 2296908, 2165834, 2034760, 1969221, 1838147, 1772609, 1641534, 1575996, 1444665, 1379127, 1313588, 1182258, 1116720, 1050925, 919851, 854057, 788518, 722724, 657186, 591391, 525597, 460059, 394265, 328727, 262932, 262930, 197136, 131598, 131596, 131338, 65800, 65798, 65541, 4});

    private String name;
    private String description;
    private int[] hexColors;

    private Viridis(String name, String description, int[] colors) {
        this.name = name;
        this.description = description;
        this.hexColors = colors;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int[] getColors() {
        return this.hexColors;
    }

    public Color getColor(float val) {
        int pos = Integer.MAX_VALUE;
        if (val >= 0.0f && val <= 1.0f) {
            pos = (int)Math.floor(this.map(val, 0.0f, 1.0f, 0.0f, this.hexColors.length - 1));
            return new Color(this.hexColors[pos]);
        }
        throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " > Val:" + val + ". Val must be a value between 0 and 1");
    }

    public Color[] getColorPalette(int steps) {
        Color[] palette = new Color[steps];
        float step = (float)this.hexColors.length / (float)steps;
        for (int i = 0; i < steps; ++i) {
            float fraction = step * (float)i;
            if (fraction > (float)this.hexColors.length - step) {
                fraction = (float)this.hexColors.length - step;
            }
            float val = this.map(fraction, 0.0f, (float)this.hexColors.length - step, 0.0f, 1.0f);
            palette[i] = this.getColor(val);
        }
        return palette;
    }

    private final float map(float value, float istart, float istop, float ostart, float ostop) {
        return ostart + (ostop - ostart) * ((value - istart) / (istop - istart));
    }
}

