/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.internal.color;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.internal.color.AbstractPalette;

public class RandomPaletteProvider
implements PaletteProvider {
    private final int MAX_COLOR = 0x1000000;
    private final long seed = System.currentTimeMillis();
    private final Random rand = new Random(this.seed);

    public String getProviderName() {
        return "Random";
    }

    public List<PaletteType> getPaletteTypes() {
        return Collections.singletonList(BrewerType.QUALITATIVE);
    }

    public List<String> listPaletteNames(PaletteType type, boolean colorBlindSafe) {
        if (type.equals(BrewerType.QUALITATIVE) || type.equals(BrewerType.ANY)) {
            return Arrays.asList("Random");
        }
        return new ArrayList<String>();
    }

    public List<Object> listPaletteIdentifiers(PaletteType type, boolean colorBlindSafe) {
        return this.listPaletteNames(type, colorBlindSafe);
    }

    public Palette getPalette(String paletteName) {
        return this.getPalette(paletteName, 8);
    }

    public Palette getPalette(String paletteName, int size) {
        if (paletteName.equalsIgnoreCase("Random") || paletteName.equalsIgnoreCase(" ")) {
            return new RandomPalette(this, size);
        }
        return null;
    }

    public Palette getPalette(Object paletteIdentifier) {
        return this.getPalette((String)paletteIdentifier);
    }

    public Palette getPalette(Object paletteIdentifier, int size) {
        return this.getPalette((String)paletteIdentifier, size);
    }

    class RandomPalette
    extends AbstractPalette {
        Color[] colors;

        RandomPalette(PaletteProvider provider, int size) {
            super(provider, "Random", size, (PaletteType)BrewerType.QUALITATIVE, false);
            this.getColors(size);
        }

        @Override
        public Color[] getColors() {
            return this.colors;
        }

        @Override
        public boolean isReversable() {
            return false;
        }

        @Override
        public Color[] getColors(int nColors) {
            this.colors = new Color[nColors];
            for (int i = 0; i < nColors; ++i) {
                this.colors[i] = new Color((int)(RandomPaletteProvider.this.rand.nextFloat() * 1.6777216E7f));
            }
            return this.colors;
        }

        public String toString() {
            return "Random";
        }
    }
}

