/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.internal.color;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.internal.color.AbstractPalette;

public class RainbowOSCPaletteProvider
implements PaletteProvider {
    public String getProviderName() {
        return "Rainbow OSC";
    }

    public List<PaletteType> getPaletteTypes() {
        return Collections.singletonList(BrewerType.QUALITATIVE);
    }

    public List<String> listPaletteNames(PaletteType type, boolean colorBlindSafe) {
        if (type.equals(BrewerType.QUALITATIVE) || type.equals(BrewerType.ANY)) {
            return Arrays.asList("Rainbow OSC");
        }
        return new ArrayList<String>();
    }

    public List<Object> listPaletteIdentifiers(PaletteType type, boolean colorBlindSafe) {
        return this.listPaletteNames(type, colorBlindSafe);
    }

    public Palette getPalette(String paletteName) {
        return this.getPalette(paletteName, 8);
    }

    public Palette getPalette(String paletteName, int size) {
        if (paletteName.equalsIgnoreCase("Rainbow OSC") || paletteName.equalsIgnoreCase(" ")) {
            return new RainbowOSCPalette(this, size);
        }
        return null;
    }

    public Palette getPalette(Object paletteIdentifier) {
        return this.getPalette((String)paletteIdentifier);
    }

    public Palette getPalette(Object paletteIdentifier, int size) {
        return this.getPalette((String)paletteIdentifier, size);
    }

    class RainbowOSCPalette
    extends AbstractPalette {
        RainbowOSCPalette(PaletteProvider provider, int size) {
            super(provider, "Rainbow OSC", size, (PaletteType)BrewerType.QUALITATIVE, false);
        }

        @Override
        public Color[] getColors() {
            return this.getColors(this.size);
        }

        @Override
        public boolean isReversable() {
            return false;
        }

        @Override
        public Color[] getColors(int nColors) {
            Color[] colors = new Color[nColors];
            float increment = 1.0f / (float)nColors;
            float hue = 0.0f;
            float sat = 0.0f;
            float br = 0.0f;
            for (int i = 0; i < nColors; ++i) {
                sat = Math.abs(((Number)Math.cos((double)(8 * i) / (Math.PI * 2))).floatValue()) * 0.7f + 0.3f;
                br = Math.abs(((Number)Math.sin((double)i / (Math.PI * 2) + 1.5707963267948966)).floatValue()) * 0.7f + 0.3f;
                colors[i] = new Color(Color.HSBtoRGB(hue += increment, sat, br));
            }
            return colors;
        }

        public String toString() {
            return "Rainbow OSC";
        }
    }
}

