/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.internal.color;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteProviderManager;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.internal.color.BuiltinDivergentPaletteProvider;
import org.cytoscape.util.internal.color.ColorBrewerPaletteProvider;
import org.cytoscape.util.internal.color.RainbowOSCPaletteProvider;
import org.cytoscape.util.internal.color.RainbowPaletteProvider;
import org.cytoscape.util.internal.color.RandomPaletteProvider;
import org.cytoscape.util.internal.color.ViridisPaletteProvider;

public class PaletteProviderManagerImpl
implements PaletteProviderManager {
    Map<String, PaletteProvider> providerMap = new HashMap<String, PaletteProvider>();
    Map<Object, Palette> savedPaletteMap = new HashMap<Object, Palette>();

    public PaletteProviderManagerImpl() {
        this.addPaletteProvider(new RainbowPaletteProvider());
        this.addPaletteProvider(new RainbowOSCPaletteProvider());
        this.addPaletteProvider(new RandomPaletteProvider());
        this.addPaletteProvider(new ColorBrewerPaletteProvider());
        this.addPaletteProvider(new ViridisPaletteProvider());
        this.addPaletteProvider(new BuiltinDivergentPaletteProvider());
    }

    public List<PaletteProvider> getPaletteProviders() {
        return new ArrayList<PaletteProvider>(this.providerMap.values());
    }

    public List<String> getPaletteProviderNames() {
        return new ArrayList<String>(this.providerMap.keySet());
    }

    public List<PaletteProvider> getPaletteProviders(PaletteType type, boolean colorSafe) {
        ArrayList<PaletteProvider> providers = new ArrayList<PaletteProvider>();
        for (PaletteProvider provider : this.providerMap.values()) {
            List palettes = provider.listPaletteNames(type, colorSafe);
            if (palettes == null || palettes.size() <= 0) continue;
            providers.add(provider);
        }
        return providers;
    }

    public PaletteProvider getPaletteProvider(String provider) {
        if (this.providerMap.containsKey(provider)) {
            return this.providerMap.get(provider);
        }
        return null;
    }

    public void addPaletteProvider(PaletteProvider provider) {
        this.providerMap.put(provider.getProviderName(), provider);
    }

    public void removePaletteProvider(PaletteProvider provider) {
        if (this.providerMap.containsKey(provider.getProviderName())) {
            this.providerMap.remove(provider.getProviderName());
        }
    }

    public void savePalette(Object key, Palette palette) {
        this.savedPaletteMap.put(key, palette);
    }

    public Palette retrievePalette(Object key) {
        if (!this.savedPaletteMap.containsKey(key)) {
            return null;
        }
        return this.savedPaletteMap.get(key);
    }
}

