/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.launcher.internal;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGUniverse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class SplashPanel
extends Component {
    private static final int BORDER_WIDTH = 1;
    private static final int PROGRESS_BAR_HEIGHT = 4;
    private static final int PAD = 20;
    private static final Color BORDER_COLOR = new Color(42, 42, 42);
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final Font FONT = new Font("SansSerif", 0, 12);
    private SVGDiagram svgDiagram;
    private final int fontHeight;
    private final int fontWidth;
    private final String javaInfo = "Java " + System.getProperty("java.version");
    private String message;
    private double progress;

    public SplashPanel(String svg) {
        this.svgDiagram = this.createSVGDiagram(svg);
        int w = Math.round(this.svgDiagram.getWidth());
        int h = Math.round(this.svgDiagram.getHeight());
        Dimension bounds = new Dimension(w + 2, h + 2);
        this.setMinimumSize(bounds);
        this.setPreferredSize(bounds);
        this.setMaximumSize(bounds);
        JLabel lbl = new JLabel(this.javaInfo);
        FontMetrics fontMetrics = lbl.getFontMetrics(FONT);
        this.fontHeight = fontMetrics.getHeight();
        this.fontWidth = lbl.getPreferredSize().width;
        this.updateMessage("Initializing OSGi container...", 0.0);
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(BORDER_COLOR);
        g.fillRect(0, 0, w, h);
        Graphics2D g2 = this.createGraphics2D(g);
        g2.translate(1, 1);
        try {
            this.svgDiagram.render(g2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        g2.dispose();
        g2 = this.createGraphics2D(g);
        g2.setColor(BORDER_COLOR);
        g2.fillRect(0, h - 20 - this.fontHeight - 4, w, 4);
        g2.setColor(TEXT_COLOR);
        g2.setFont(FONT);
        g2.drawString(this.javaInfo, w - 20 - this.fontWidth, 20 + this.fontHeight);
        g2.dispose();
        if (this.message != null) {
            this.drawProgressString(g);
        }
        if (this.progress > 0.0) {
            this.drawProgressBar(g);
        }
    }

    public void updateMessage(String message, double progress) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(() -> this.updateMessage(message, progress));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return;
        }
        this.message = message;
        this.progress = progress;
        if (this.isDisplayable()) {
            this.repaint();
        }
    }

    public void close() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Window)) continue;
            parent.setVisible(false);
        }
    }

    private SVGDiagram createSVGDiagram(String svg) {
        SVGUniverse universe = new SVGUniverse();
        StringReader is = new StringReader(svg);
        URI uri = universe.loadSVG(is, "bg");
        SVGDiagram diagram = universe.getDiagram(uri);
        diagram.setIgnoringClipHeuristic(true);
        return diagram;
    }

    private void drawProgressString(Graphics g) {
        int h = this.getHeight();
        Graphics2D g2 = this.createGraphics2D(g);
        g2.setColor(TEXT_COLOR);
        g2.drawString(this.message, 20, h - 20);
        g2.dispose();
    }

    private void drawProgressBar(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        int th = this.fontHeight;
        int progressWidth = (int)((double)w * this.progress);
        Graphics2D g2 = this.createGraphics2D(g);
        g2.setColor(TEXT_COLOR);
        g2.fillRect(0, h - 20 - th - 4, progressWidth, 4);
        g2.dispose();
    }

    private Graphics2D createGraphics2D(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return g2;
    }
}

