/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.jobs.internal;

import java.awt.Color;
import java.util.Collection;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.cytoscape.jobs.CyJobStatus;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.swing.StatusBarPanelFactory;

public class JobStatusBar
extends JPanel
implements StatusBarPanelFactory {
    public static final String TASK_HISTORY_CLICK = "job-status-click";
    public static final String ICON_RUNNING = "\uf251";
    public static final String ICON_WARN = "\uf071";
    public static final String ICON_ERROR = "\uf056";
    public static final String ICON_CANCELLED = "\uf05e";
    public static final String ICON_FINISHED = "\uf0ed";
    public static final String ICON_JOBS = "\uf0c2";
    final JButton showBtn;
    JDialog statusDialog = null;
    JobsIcon currentStatus = JobsIcon.JOBS;

    public JobStatusBar(CyServiceRegistrar serviceRegistrar) {
        IconManager iconManager = (IconManager)serviceRegistrar.getService(IconManager.class);
        this.showBtn = new JButton();
        this.showBtn.setFont(iconManager.getIconFont(14.0f));
        this.showBtn.setText(JobsIcon.JOBS.getText());
        if (LookAndFeelUtil.isAquaLAF()) {
            this.showBtn.putClientProperty("JButton.buttonType", "gradient");
        }
        this.showBtn.addActionListener(evt -> {
            this.showBtn.setText(JobsIcon.JOBS.getText());
            this.showBtn.setForeground(JobsIcon.JOBS.getForeground());
            if (this.statusDialog != null) {
                this.statusDialog.setVisible(true);
            }
        });
        this.showBtn.setToolTipText("Show Job Status");
        this.showBtn.setFocusPainted(false);
        int w = Math.max(48, this.showBtn.getPreferredSize().width);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.showBtn, w, w, w));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.showBtn, -1, -1, Short.MAX_VALUE));
    }

    public void setDialog(JDialog dialog) {
        this.statusDialog = dialog;
    }

    public void updateIcon(Collection<CyJobStatus> values) {
        JobsIcon icon = JobsIcon.JOBS;
        if (values != null && values.size() > 0) {
            for (CyJobStatus status : values) {
                CyJobStatus.Status jobStatus = status.getStatus();
                if (jobStatus.equals((Object)CyJobStatus.Status.FINISHED)) {
                    icon = JobsIcon.FINISHED;
                    break;
                }
                if (jobStatus.equals((Object)CyJobStatus.Status.ERROR) || jobStatus.equals((Object)CyJobStatus.Status.FAILED)) {
                    icon = JobsIcon.ERROR;
                    continue;
                }
                if (jobStatus.equals((Object)CyJobStatus.Status.CANCELED) || jobStatus.equals((Object)CyJobStatus.Status.PURGED) || jobStatus.equals((Object)CyJobStatus.Status.TERMINATED) || jobStatus.equals((Object)CyJobStatus.Status.UNKNOWN)) {
                    if (icon.equals((Object)JobsIcon.ERROR)) continue;
                    icon = JobsIcon.WARN;
                    continue;
                }
                if (!jobStatus.equals((Object)CyJobStatus.Status.QUEUED) && !jobStatus.equals((Object)CyJobStatus.Status.SUBMITTED) && !jobStatus.equals((Object)CyJobStatus.Status.RUNNING) || icon.equals((Object)JobsIcon.ERROR) || icon.equals((Object)JobsIcon.WARN)) continue;
                icon = JobsIcon.RUNNING;
            }
        }
        if (!this.currentStatus.equals((Object)JobsIcon.RUNNING) && this.currentStatus.equals((Object)icon)) {
            return;
        }
        this.setIcon(icon);
    }

    public void setIcon(JobsIcon icon) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.setIcon(icon));
            return;
        }
        String iconText = null;
        if (icon != null) {
            if (this.currentStatus.equals((Object)JobsIcon.RUNNING) && icon.equals((Object)JobsIcon.RUNNING)) {
                String text = this.showBtn.getText();
                if (text.equals(ICON_RUNNING)) {
                    iconText = "\uf252";
                } else if (text.equals("\uf252")) {
                    iconText = "\uf253";
                } else if (text.equals("\uf253")) {
                    iconText = ICON_RUNNING;
                }
            } else {
                iconText = icon.getText();
            }
            Color iconColor = icon.getForeground();
            this.showBtn.setText(iconText);
            this.showBtn.setForeground(iconColor);
            this.currentStatus = icon;
        }
    }

    public JPanel createTaskStatusPanel() {
        return this;
    }

    public static enum JobsIcon {
        RUNNING("\uf251"),
        WARN("\uf071"),
        ERROR("\uf056"),
        CANCELLED("\uf05e"),
        FINISHED("\uf0ed"),
        JOBS("\uf0c2");

        private final String text;

        private JobsIcon(String text) {
            this.text = text;
        }

        public Color getForeground() {
            switch (this) {
                case RUNNING: {
                    return LookAndFeelUtil.getInfoColor();
                }
                case WARN: {
                    return LookAndFeelUtil.getWarnColor();
                }
                case ERROR: {
                    return LookAndFeelUtil.getErrorColor();
                }
                case CANCELLED: {
                    return LookAndFeelUtil.getErrorColor();
                }
                case FINISHED: {
                    return LookAndFeelUtil.getSuccessColor();
                }
            }
            return UIManager.getColor("Label.foreground");
        }

        public String getText() {
            return this.text;
        }
    }
}

