/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.jobs.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.jobs.CyJob;
import org.cytoscape.jobs.CyJobMonitor;
import org.cytoscape.jobs.CyJobStatus;
import org.cytoscape.jobs.internal.CyJobManagerImpl;
import org.cytoscape.jobs.internal.GUICyJobMonitor;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskMonitor;

public class GUIJobDialog
extends JDialog {
    final CyServiceRegistrar serviceRegistrar;
    final ConcurrentMap<CyJob, CyJobStatus> statusMap;
    final List<CyJob> jobList;
    final CyJobManagerImpl jobManager;
    final GUICyJobMonitor jobMonitor;
    JobTableModel jobTableModel;
    final JDialog jobDialog;

    public GUIJobDialog(CyServiceRegistrar registrar, CySwingApplication swingApp, ConcurrentMap<CyJob, CyJobStatus> statusMap, CyJobManagerImpl jobManager, GUICyJobMonitor jobMonitor) {
        this.setTitle("Job Monitor");
        this.serviceRegistrar = registrar;
        this.statusMap = statusMap;
        this.jobManager = jobManager;
        this.jobMonitor = jobMonitor;
        this.jobList = new ArrayList<CyJob>();
        for (CyJob job : statusMap.keySet()) {
            this.jobList.add(job);
        }
        this.initUI();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.jobDialog = this;
    }

    public void initUI() {
        this.jobTableModel = new JobTableModel(this);
        JTable table = new JTable(this.jobTableModel);
        table.setAutoResizeMode(4);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setPreferredSize(new Dimension(500, 100));
        JTableButtonRenderer buttonRenderer = new JTableButtonRenderer();
        table.setDefaultRenderer(JButton.class, buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JCheckBox());
        table.setDefaultEditor(JButton.class, buttonEditor);
        table.setRowHeight(30);
        JButton closeButton = new JButton(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIJobDialog.this.dispose();
            }
        });
        JPanel bottomPanel = LookAndFeelUtil.createOkCancelPanel(null, (JButton)closeButton);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), null, (Action)closeButton.getAction());
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        this.add((Component)bottomPanel, "South");
    }

    public void mapChanged() {
        this.jobList.clear();
        for (CyJob job : this.statusMap.keySet()) {
            this.jobList.add(job);
        }
        this.jobTableModel.fireTableDataChanged();
    }

    public String jobToString(CyJob job) {
        return job.getJobName() + "(" + job.getJobId() + ")";
    }

    String getButtonText(String action) {
        if (action == null) {
            return "";
        }
        if (action.equals("cancel")) {
            return "Cancel Job";
        }
        if (action.equals("error")) {
            return "Show Error";
        }
        if (action.equals("warning")) {
            return "Show Error";
        }
        if (action.equals("load")) {
            return "Load Data";
        }
        return null;
    }

    class LoadDataTask
    extends AbstractTask {
        final CyJob job;

        public LoadDataTask(CyJob job) {
            this.job = job;
        }

        public void run(TaskMonitor monitor) {
            monitor.setTitle("Loading data for " + this.job.toString());
            CyJobMonitor jobMonitor = this.job.getJobMonitor();
            if (jobMonitor != null) {
                jobMonitor.loadData(this.job, monitor);
            }
            GUIJobDialog.this.jobManager.removeJob(this.job);
            GUIJobDialog.this.jobList.remove(this.job);
            GUIJobDialog.this.statusMap.remove(this.job);
            GUIJobDialog.this.mapChanged();
        }
    }

    class ButtonEditor
    extends DefaultCellEditor {
        protected JButton button;
        private String action;
        private boolean isPushed;
        private CyJob job;
        private CyJobStatus jobStatus;

        public ButtonEditor(JCheckBox checkBox) {
            super(checkBox);
            this.button = new JButton();
            this.button.setOpaque(true);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.action = (String)value;
            this.button.setText(GUIJobDialog.this.getButtonText(this.action));
            this.isPushed = true;
            this.job = GUIJobDialog.this.jobList.get(row);
            this.jobStatus = (CyJobStatus)GUIJobDialog.this.statusMap.get(this.job);
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.isPushed) {
                this.isPushed = false;
                if (this.action.equals("cancel")) {
                    CyJobStatus status = this.job.getJobExecutionService().cancelJob(this.job);
                    if (status.getStatus().equals((Object)CyJobStatus.Status.CANCELED)) {
                        GUIJobDialog.this.jobManager.removeJob(this.job);
                        GUIJobDialog.this.mapChanged();
                        GUIJobDialog.this.jobMonitor.jobStatusChanged(this.job, status);
                    }
                } else if (this.action.equals("error")) {
                    this.showMessage(GUIJobDialog.this.jobDialog, 0);
                } else if (this.action.equals("warning")) {
                    this.showMessage(GUIJobDialog.this.jobDialog, 2);
                } else if (this.action.equals("load")) {
                    TaskManager taskManager = (TaskManager)GUIJobDialog.this.serviceRegistrar.getService(TaskManager.class);
                    taskManager.execute(new TaskIterator(new Task[]{new LoadDataTask(this.job)}));
                }
            }
            return this.action;
        }

        void showMessage(JDialog parent, int messageType) {
            JOptionPane.showMessageDialog(parent, this.jobStatus.toString(), "Job " + GUIJobDialog.this.jobToString(this.job), messageType);
            GUIJobDialog.this.jobManager.removeJob(this.job);
            GUIJobDialog.this.jobList.remove(this.job);
            GUIJobDialog.this.statusMap.remove(this.job);
            GUIJobDialog.this.mapChanged();
            GUIJobDialog.this.jobMonitor.updateIcon();
        }
    }

    class JTableButtonRenderer
    extends JButton
    implements TableCellRenderer {
        public JTableButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(UIManager.getColor("Button.background"));
            }
            this.setText(GUIJobDialog.this.getButtonText((String)value));
            return this;
        }
    }

    class JobTableModel
    extends AbstractTableModel {
        static final long serialVersionUID = 1002L;
        final JDialog jobDialog;

        public JobTableModel(JDialog dialog) {
            this.jobDialog = dialog;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Job Name";
                }
                case 1: {
                    return "Job Id";
                }
                case 2: {
                    return "Current Status";
                }
                case 3: {
                    return "";
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: 
                case 1: 
                case 2: {
                    return String.class;
                }
                case 3: {
                    return JButton.class;
                }
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return GUIJobDialog.this.statusMap.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int row, int column) {
            CyJob job = GUIJobDialog.this.jobList.get(row);
            CyJobStatus status = (CyJobStatus)GUIJobDialog.this.statusMap.get(job);
            CyJobStatus.Status jobStatus = status.getStatus();
            switch (column) {
                case 0: {
                    return job.getJobName();
                }
                case 1: {
                    return job.getJobId();
                }
                case 2: {
                    return jobStatus.toString();
                }
                case 3: {
                    switch (jobStatus) {
                        case ERROR: 
                        case FAILED: {
                            return "error";
                        }
                        case PURGED: 
                        case TERMINATED: 
                        case CANCELED: 
                        case UNKNOWN: {
                            return "warning";
                        }
                        case QUEUED: 
                        case RUNNING: 
                        case SUBMITTED: {
                            return "cancel";
                        }
                        case FINISHED: {
                            return "load";
                        }
                    }
                }
            }
            return null;
        }
    }
}

