/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.application.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.application.CyShutdown;
import org.cytoscape.application.events.CyShutdownEvent;
import org.cytoscape.application.events.CyShutdownRequestedEvent;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHandler
implements CyShutdown {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final Bundle rootBundle;
    private final CyServiceRegistrar serviceRegistrar;
    final String activeSessionFilename = "tracker.active.session";

    public ShutdownHandler(Bundle rootBundle, CyServiceRegistrar serviceRegistrar) {
        this.rootBundle = rootBundle;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void exit(int retVal) {
        this.exit(retVal, false);
    }

    public void exit(int retVal, boolean force) {
        CyShutdownRequestedEvent request = new CyShutdownRequestedEvent((Object)this, force);
        ((CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class)).fireEvent((CyEvent)request);
        if (!request.actuallyShutdown()) {
            logger.info("NOT shutting down, per listener instruction: " + request.abortShutdownReason());
            return;
        }
        CyShutdownEvent ev = new CyShutdownEvent((Object)this, force);
        ((CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class)).fireEvent((CyEvent)ev);
        try {
            logger.info("#CiaoBello", (Object)this.rootBundle);
            CyApplicationConfiguration c = (CyApplicationConfiguration)this.serviceRegistrar.getService(CyApplicationConfiguration.class);
            this.removeFailSafeFile(c.getConfigurationDirectoryLocation().getAbsolutePath());
            this.rootBundle.stop();
        }
        catch (BundleException e) {
            logger.error("Error while shutting down", (Throwable)e);
        }
    }

    private void removeFailSafeFile(String configPath) {
        Path path = Paths.get(configPath, "tracker.active.session");
        if (path != null && path.toFile().exists()) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                logger.error("Could not clean up tracker.active.session in " + configPath);
            }
        } else {
            logger.info("tracker.active.session did not exist in " + configPath);
        }
    }
}

