/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.application.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.application.TableViewRenderer;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentRenderingEngineEvent;
import org.cytoscape.application.events.SetCurrentTableEvent;
import org.cytoscape.application.events.SetSelectedNetworkViewsEvent;
import org.cytoscape.application.events.SetSelectedNetworksEvent;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedListener;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.events.RenderingEngineAboutToBeRemovedEvent;
import org.cytoscape.view.presentation.events.RenderingEngineAboutToBeRemovedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyApplicationManagerImpl
implements CyApplicationManager,
NetworkAboutToBeDestroyedListener,
NetworkViewAboutToBeDestroyedListener,
RenderingEngineAboutToBeRemovedListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String LAST_DIRECTORY = "directory.last";
    private final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();
    private CyNetwork currentNetwork;
    private CyNetworkView currentNetworkView;
    private CyTable currentTable;
    private RenderingEngine<CyNetwork> currentNetworkRenderingEngine;
    private final List<CyNetworkView> selectedNetworkViews = new LinkedList<CyNetworkView>();
    private Map<String, NetworkViewRenderer> networkRenderers = new LinkedHashMap<String, NetworkViewRenderer>();
    private NetworkViewRenderer defaultNetworkRenderer;
    private Map<String, TableViewRenderer> tableRenderers = new LinkedHashMap<String, TableViewRenderer>();
    private TableViewRenderer defaultTableRenderer;

    public CyApplicationManagerImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(NetworkAboutToBeDestroyedEvent event) {
        CyNetwork toBeDestroyed = event.getNetwork();
        ArrayList eventsToFire = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            logger.debug("NetworkAboutToBeDestroyedEvent: " + toBeDestroyed + ". Current: " + this.currentNetwork);
            if (toBeDestroyed.equals(this.currentNetwork)) {
                this.internalSetCurrentNetwork(null, eventsToFire);
            }
        }
        this.fireEvents(eventsToFire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(NetworkViewAboutToBeDestroyedEvent event) {
        CyNetworkView toBeDestroyed = event.getNetworkView();
        ArrayList eventsToFire = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            logger.debug("NetworkViewAboutToBeDestroyedEvent: " + toBeDestroyed + ". Current: " + this.currentNetworkView);
            if (toBeDestroyed.equals(this.currentNetworkView)) {
                this.internalSetCurrentNetworkView(null, eventsToFire);
            }
            this.selectedNetworkViews.removeAll(Collections.singletonList(toBeDestroyed));
        }
        this.fireEvents(eventsToFire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(RenderingEngineAboutToBeRemovedEvent event) {
        RenderingEngine renderingEngine = event.getRenderingEngine();
        Object object = this.lock;
        synchronized (object) {
            if (renderingEngine == this.currentNetworkRenderingEngine) {
                this.setCurrentRenderingEngine(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyNetwork getCurrentNetwork() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentNetwork;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentNetwork(CyNetwork network) {
        ArrayList eventsToFire = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            this.internalSetCurrentNetwork(network, eventsToFire);
        }
        this.fireEvents(eventsToFire);
    }

    private void internalSetCurrentNetwork(CyNetwork network, List<CyEvent<?>> eventsToFire) {
        boolean changed;
        CyNetworkManager networkManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        if (network != null && !networkManager.networkExists(network.getSUID().longValue())) {
            throw new IllegalArgumentException("Network is not registered in this ApplicationManager: " + network);
        }
        boolean bl = changed = !Objects.equals(network, this.currentNetwork);
        if (changed) {
            this.currentNetwork = network;
            if (network != null && !this.getSelectedNetworks().contains(network)) {
                this.internalSetSelectedNetworks(Collections.singletonList(network), eventsToFire);
            }
            eventsToFire.add((CyEvent<?>)new SetCurrentNetworkEvent((CyApplicationManager)this, this.currentNetwork));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyNetworkView getCurrentNetworkView() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentNetworkView;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentNetworkView(CyNetworkView view) {
        ArrayList eventsToFire = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            this.internalSetCurrentNetworkView(view, eventsToFire);
        }
        this.fireEvents(eventsToFire);
    }

    private void internalSetCurrentNetworkView(CyNetworkView view, List<CyEvent<?>> eventsToFire) {
        boolean changed;
        CyNetworkManager networkManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        if (view != null && !networkManager.networkExists(((CyNetwork)view.getModel()).getSUID().longValue())) {
            throw new IllegalArgumentException("network is not recognized by this ApplicationManager");
        }
        boolean bl = changed = !Objects.equals(view, this.currentNetworkView);
        if (changed) {
            this.currentNetworkView = view;
            eventsToFire.add((CyEvent<?>)new SetCurrentNetworkViewEvent((CyApplicationManager)this, this.currentNetworkView));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CyNetworkView> getSelectedNetworkViews() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<CyNetworkView>(this.selectedNetworkViews);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedNetworkViews(List<CyNetworkView> networkViews) {
        ArrayList eventsToFire = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            this.internalSetSelectedNetworkViews(networkViews, eventsToFire);
        }
        this.fireEvents(eventsToFire);
    }

    private void internalSetSelectedNetworkViews(List<CyNetworkView> networkViews, List<CyEvent<?>> eventsToFire) {
        this.selectedNetworkViews.clear();
        if (networkViews != null) {
            this.selectedNetworkViews.addAll(networkViews);
        }
        eventsToFire.add((CyEvent<?>)new SetSelectedNetworkViewsEvent((CyApplicationManager)this, new ArrayList<CyNetworkView>(this.selectedNetworkViews)));
    }

    public List<CyNetwork> getSelectedNetworks() {
        CyNetworkManager networkManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        Set allNetworks = networkManager.getNetworkSet();
        ArrayList<CyNetwork> selectedNetworks = new ArrayList<CyNetwork>();
        for (CyNetwork n : allNetworks) {
            CyRow row = n.getRow((CyIdentifiable)n);
            if (!((Boolean)row.get("selected", Boolean.class, (Object)false)).booleanValue()) continue;
            selectedNetworks.add(n);
        }
        return selectedNetworks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedNetworks(List<CyNetwork> networks) {
        ArrayList eventsToFire = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            this.internalSetSelectedNetworks(networks, eventsToFire);
        }
        this.fireEvents(eventsToFire);
    }

    private void internalSetSelectedNetworks(List<CyNetwork> networks, List<CyEvent<?>> eventsToFire) {
        Set<CyNetwork> selectedNetworks;
        LinkedHashSet<Object> linkedHashSet = selectedNetworks = networks != null ? new LinkedHashSet<CyNetwork>(networks) : new LinkedHashSet();
        if (!selectedNetworks.equals(new LinkedHashSet<CyNetwork>(this.getSelectedNetworks()))) {
            selectedNetworks = this.selectNetworks(selectedNetworks);
            eventsToFire.add((CyEvent<?>)new SetSelectedNetworksEvent((CyApplicationManager)this, new ArrayList<CyNetwork>(selectedNetworks)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderingEngine<CyNetwork> getCurrentRenderingEngine() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentNetworkRenderingEngine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentRenderingEngine(RenderingEngine<CyNetwork> engine) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            changed = Objects.equals(engine, this.currentNetworkRenderingEngine);
            this.currentNetworkRenderingEngine = engine;
        }
        if (changed) {
            this.fireEvents(Collections.singletonList(new SetCurrentRenderingEngineEvent((CyApplicationManager)this, this.currentNetworkRenderingEngine)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableViewRenderer getTableViewRenderer(String rendererId) {
        Object object = this.lock;
        synchronized (object) {
            return this.tableRenderers.get(rendererId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkViewRenderer getNetworkViewRenderer(String rendererId) {
        Object object = this.lock;
        synchronized (object) {
            return this.networkRenderers.get(rendererId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyTable getCurrentTable() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentTable(CyTable table) {
        ArrayList eventsToFire = new ArrayList(1);
        Object object = this.lock;
        synchronized (object) {
            if (!Objects.equals(this.currentTable, table)) {
                this.currentTable = table;
                eventsToFire.add((CyEvent<?>)new SetCurrentTableEvent((CyApplicationManager)this, this.currentTable));
            }
        }
        this.fireEvents(eventsToFire);
    }

    private Set<CyNetwork> selectNetworks(Collection<CyNetwork> networks) {
        CyNetworkManager networkManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        HashSet<CyNetwork> selectedNetworks = new HashSet<CyNetwork>();
        Set allNetworks = networkManager.getNetworkSet();
        for (CyNetwork n : allNetworks) {
            boolean selected = networks != null && networks.contains(n);
            CyRow row = n.getRow((CyIdentifiable)n);
            row.set("selected", (Object)selected);
            if (!selected) continue;
            selectedNetworks.add(n);
        }
        return selectedNetworks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.setCurrentNetwork(null);
            this.setCurrentNetworkView(null);
            this.setSelectedNetworkViews(null);
            this.setCurrentRenderingEngine(null);
            this.setCurrentTable(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkViewRenderer getCurrentNetworkViewRenderer() {
        Object object = this.lock;
        synchronized (object) {
            NetworkViewRenderer netViewRenderer = null;
            if (this.currentNetworkView != null) {
                netViewRenderer = this.getNetworkViewRenderer(this.currentNetworkView.getRendererId());
            }
            if (netViewRenderer == null) {
                netViewRenderer = this.getDefaultNetworkViewRenderer();
            }
            return netViewRenderer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkViewRenderer(NetworkViewRenderer renderer, Map<?, ?> properties) {
        Object object = this.lock;
        synchronized (object) {
            this.networkRenderers.put(renderer.getId(), renderer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetworkViewRenderer(NetworkViewRenderer renderer, Map<?, ?> properties) {
        Object object = this.lock;
        synchronized (object) {
            this.networkRenderers.remove(renderer.getId());
            if (this.defaultNetworkRenderer == renderer) {
                this.defaultNetworkRenderer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableViewRenderer(TableViewRenderer renderer, Map<?, ?> properties) {
        Object object = this.lock;
        synchronized (object) {
            this.tableRenderers.put(renderer.getId(), renderer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableViewRenderer(TableViewRenderer renderer, Map<?, ?> properties) {
        Object object = this.lock;
        synchronized (object) {
            this.tableRenderers.remove(renderer.getId());
            if (this.defaultTableRenderer == renderer) {
                this.defaultTableRenderer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkViewRenderer getDefaultNetworkViewRenderer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.defaultNetworkRenderer == null) {
                if (this.networkRenderers.isEmpty()) {
                    return null;
                }
                this.defaultNetworkRenderer = this.networkRenderers.entrySet().iterator().next().getValue();
            }
            return this.defaultNetworkRenderer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultNetworkViewRenderer(NetworkViewRenderer renderer) {
        Object object = this.lock;
        synchronized (object) {
            this.defaultNetworkRenderer = renderer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultTableViewRenderer(TableViewRenderer renderer) {
        Object object = this.lock;
        synchronized (object) {
            this.defaultTableRenderer = renderer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableViewRenderer getDefaultTableViewRenderer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.defaultTableRenderer == null) {
                if (this.tableRenderers.isEmpty()) {
                    return null;
                }
                this.defaultTableRenderer = this.tableRenderers.entrySet().iterator().next().getValue();
            }
            return this.defaultTableRenderer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TableViewRenderer> getTableViewRendererSet() {
        Object object = this.lock;
        synchronized (object) {
            return new LinkedHashSet<TableViewRenderer>(this.tableRenderers.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NetworkViewRenderer> getNetworkViewRendererSet() {
        Object object = this.lock;
        synchronized (object) {
            return new LinkedHashSet<NetworkViewRenderer>(this.networkRenderers.values());
        }
    }

    public File getCurrentDirectory() {
        File dir;
        Properties props = this.getCy3Properties();
        String lastDir = props.getProperty(LAST_DIRECTORY);
        File file = dir = lastDir != null ? new File(lastDir) : null;
        if (!(dir != null && dir.exists() && dir.isDirectory() || (dir = new File(System.getProperty("user.dir"))) == null)) {
            props.remove(LAST_DIRECTORY);
        }
        return dir;
    }

    public boolean setCurrentDirectory(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return false;
        }
        Properties props = this.getCy3Properties();
        props.setProperty(LAST_DIRECTORY, dir.getAbsolutePath());
        return true;
    }

    private Properties getCy3Properties() {
        return (Properties)((CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)")).getProperties();
    }

    private void fireEvents(List<CyEvent<?>> eventsToFire) {
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        for (CyEvent<?> event : eventsToFire) {
            eventHelper.fireEvent(event);
        }
    }
}

