/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.parse_tree;

import java.util.Stack;
import org.cytoscape.equations.AbstractNode;
import org.cytoscape.equations.CodeAndSourceLocation;
import org.cytoscape.equations.TreeNode;
import org.cytoscape.equations.internal.Token;
import org.cytoscape.equations.internal.interpreter.Instruction;

public class UnaryOpNode
extends AbstractNode {
    private final Token operator;
    private final TreeNode operand;

    public UnaryOpNode(int sourceLocation, Token operator, TreeNode operand) {
        super(sourceLocation);
        if (operand == null) {
            throw new IllegalArgumentException("operand must not be null.");
        }
        this.operator = operator;
        this.operand = operand;
    }

    public String toString() {
        return "UnaryOpNode: " + this.operator;
    }

    public Class getType() {
        return this.operand.getType();
    }

    public TreeNode getLeftChild() {
        return this.operand;
    }

    public TreeNode getRightChild() {
        return null;
    }

    public Token getOperator() {
        return this.operator;
    }

    public void genCode(Stack<CodeAndSourceLocation> codeStack) {
        this.operand.genCode(codeStack);
        switch (this.operator) {
            case PLUS: {
                codeStack.push(new CodeAndSourceLocation((Object)Instruction.FUPLUS, this.getSourceLocation()));
                break;
            }
            case MINUS: {
                codeStack.push(new CodeAndSourceLocation((Object)Instruction.FUMINUS, this.getSourceLocation()));
                break;
            }
            default: {
                throw new IllegalStateException("invalid unary operation: " + this.operator + ".");
            }
        }
    }
}

