/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.parse_tree;

import java.util.Stack;
import org.cytoscape.equations.AbstractNode;
import org.cytoscape.equations.CodeAndSourceLocation;
import org.cytoscape.equations.Function;
import org.cytoscape.equations.TreeNode;
import org.cytoscape.equations.internal.interpreter.Instruction;

public class FuncCallNode
extends AbstractNode {
    private final Function func;
    final Class returnType;
    private final TreeNode[] args;

    public FuncCallNode(int sourceLocation, Function func, Class returnType, TreeNode[] args) {
        super(sourceLocation);
        if (func == null) {
            throw new IllegalArgumentException("function must not be null.");
        }
        if (returnType == null) {
            throw new IllegalArgumentException("return type must not be null.");
        }
        if (args == null) {
            throw new IllegalArgumentException("args must not be null.");
        }
        this.func = func;
        this.returnType = returnType;
        this.args = args;
    }

    public String toString() {
        return "FuncCallNode: call to " + this.func.getName().toUpperCase() + " with " + this.args.length + " args";
    }

    public Class getType() {
        return this.returnType;
    }

    public TreeNode getLeftChild() {
        return null;
    }

    public TreeNode getRightChild() {
        return null;
    }

    public Object getValue() {
        return null;
    }

    public void genCode(Stack<CodeAndSourceLocation> codeStack) {
        for (int i = this.args.length - 1; i >= 0; --i) {
            this.args[i].genCode(codeStack);
        }
        codeStack.push(new CodeAndSourceLocation((Object)this.args.length, -1));
        codeStack.push(new CodeAndSourceLocation((Object)this.func, -1));
        codeStack.push(new CodeAndSourceLocation((Object)Instruction.CALL, this.getSourceLocation()));
    }
}

