/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import java.text.DateFormat;
import java.util.Calendar;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;

public class Today
extends AbstractFunction {
    public Today() {
        super(new ArgDescriptor[0]);
    }

    public String getName() {
        return "TODAY";
    }

    public String getCategoryName() {
        return "Date/Time";
    }

    public String getFunctionSummary() {
        return "Returns today's date as a string.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) {
        Calendar calendar = Calendar.getInstance();
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        try {
            return dateFormat.format(calendar.getTime());
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to get today's date: " + e.getMessage());
        }
    }
}

