/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Substitute
extends AbstractFunction {
    public Substitute() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.STRING, "text", "The source text."), new ArgDescriptor(ArgType.STRING, "original", "The text that will be replaced."), new ArgDescriptor(ArgType.STRING, "replacement", "The replacement text."), new ArgDescriptor(ArgType.OPT_INT, "nth_appearance", "Which occurrence to replace.")});
    }

    public String getName() {
        return "SUBSTITUTE";
    }

    public String getCategoryName() {
        return "Text";
    }

    public String getFunctionSummary() {
        return "Replaces some text with other text.";
    }

    public Class<?> getReturnType() {
        return String.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        int nthAppearance;
        String text = FunctionUtil.getArgAsString((Object)args[0]);
        String original = FunctionUtil.getArgAsString((Object)args[1]);
        String replacement = FunctionUtil.getArgAsString((Object)args[2]);
        if (args.length == 3) {
            return Substitute.replaceAll(text, original, replacement);
        }
        try {
            nthAppearance = (int)FunctionUtil.getArgAsLong((Object)args[3]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[3] + "\" to a number in a call to SUBSTITUTE().");
        }
        if (nthAppearance <= 0) {
            return text;
        }
        int startIndex = Substitute.findNth(nthAppearance, text, original);
        if (startIndex == -1) {
            return text;
        }
        return text.substring(0, startIndex) + replacement + text.substring(startIndex + original.length());
    }

    private static int findNth(int n, String hayStack, String needle) {
        int startOffset = 0;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            offset = hayStack.indexOf(needle, startOffset);
            if (offset == -1) {
                return offset;
            }
            startOffset = offset + needle.length();
        }
        return offset;
    }

    private static String replaceAll(String s, String original, String replacement) {
        int startMatch;
        StringBuilder builder = new StringBuilder();
        int startOffset = 0;
        while ((startMatch = s.indexOf(original, startOffset)) != -1) {
            builder.append(s.substring(startOffset, startMatch));
            builder.append(replacement);
            startOffset = startMatch + original.length();
        }
        builder.append(s.substring(startOffset));
        return builder.toString();
    }
}

