/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class StDev
extends AbstractFunction {
    public StDev() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOATS, "numbers", "One or more numbers or lists of numbers.")});
    }

    public String getName() {
        return "STDEV";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Returns the sample standard deviation of a list of numbers.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        double[] numbers;
        try {
            numbers = FunctionUtil.getDoubles((Object[])args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not convert an argument or list element to a number in a call to STDEV().");
        }
        if (numbers.length < 2) {
            throw new IllegalArgumentException("illegal argument(s) in call to STDEV(): must have at least 2 numbers.");
        }
        return Math.sqrt(FunctionUtil.calcSampleVariance((double[])numbers));
    }
}

