/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import java.util.regex.Pattern;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;
import org.cytoscape.equations.internal.StringList;

public class Split
extends AbstractFunction {
    public Split() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.STRING, "text", "The text that will be split."), new ArgDescriptor(ArgType.STRING, "delimiter", "The text that will be used as a delimiter.")});
    }

    public String getName() {
        return "SPLIT";
    }

    public String getCategoryName() {
        return "Text";
    }

    public String getFunctionSummary() {
        return "Splits a text string into substrings around matches of a delimiter.";
    }

    public Class<?> getReturnType() {
        return StringList.class;
    }

    public Object evaluateFunction(Object[] args) {
        String text = FunctionUtil.getArgAsString((Object)args[0]);
        String delimiter = FunctionUtil.getArgAsString((Object)args[1]);
        String[] strings = text.split(Pattern.quote(delimiter));
        return new StringList(strings);
    }
}

