/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Sign
extends AbstractFunction {
    public Sign() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "number", "Any number.")});
    }

    public String getName() {
        return "SIGN";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Implements the signum function.  Returns -1,0,+1 based on the number being negative, zero, or positive.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) {
        double number;
        try {
            number = FunctionUtil.getArgAsDouble((Object)args[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("SIGN: " + e.getMessage());
        }
        return Math.signum(number);
    }
}

