/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import java.util.Arrays;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Mode
extends AbstractFunction {
    public Mode() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOATS, "numbers", "One or more numbers or lists of numbers.")});
    }

    public String getName() {
        return "MODE";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Returns the mode of a list of numbers.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        double[] x;
        try {
            x = FunctionUtil.getDoubles((Object[])args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("non-numeric argument or list element in a call to MODE().");
        }
        Arrays.sort(x);
        double mode = 0.0;
        int highestFrequencySoFar = 0;
        double currentValue = -x[0];
        int currentFrequency = 0;
        for (double d : x) {
            if (d == currentValue) {
                ++currentFrequency;
                continue;
            }
            if (currentFrequency > highestFrequencySoFar) {
                highestFrequencySoFar = currentFrequency;
                mode = currentValue;
            }
            currentFrequency = 1;
            currentValue = d;
        }
        if (highestFrequencySoFar < 2) {
            throw new IllegalArgumentException("the are no duplicates in the list of numbers supplied to MODE().");
        }
        return mode;
    }
}

