/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import java.util.List;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class First
extends AbstractFunction {
    public First() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.ANY_LIST, "list", "A non-empty list.")});
    }

    public String getName() {
        return "FIRST";
    }

    public String getCategoryName() {
        return "List";
    }

    public String getFunctionSummary() {
        return "Returns the first entry in a list.";
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        List list = (List)args[0];
        if (list.isEmpty()) {
            throw new IllegalArgumentException("can't get the first argument of an empty list in a call to FIRST().");
        }
        Object firstElement = list.get(0);
        Object retVal = FunctionUtil.translateObjectType(firstElement);
        if (retVal == null) {
            throw new IllegalArgumentException("bad list element type: " + firstElement.getClass() + " in a call to FIRST().");
        }
        return retVal;
    }
}

