/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import java.util.List;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;

public class Count
extends AbstractFunction {
    public Count() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.ANY_LIST, "list", "One or more lists or individual items.")});
    }

    public String getName() {
        return "COUNT";
    }

    public String getCategoryName() {
        return "List";
    }

    public String getFunctionSummary() {
        return "Returns the number of numeric values in a list. Can be applied to multiple list arguments and will return the total count of all numeric values in the lists.";
    }

    public Class<?> getReturnType() {
        return Long.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        int count = 0;
        for (Object arg : args) {
            if (arg instanceof List) {
                List list = (List)arg;
                for (Object listEntry : list) {
                    if (listEntry.getClass() == Double.class || listEntry.getClass() == Integer.class || listEntry.getClass() == Long.class) {
                        ++count;
                        continue;
                    }
                    if (listEntry.getClass() != String.class || !this.isValidDouble((String)listEntry)) continue;
                    ++count;
                }
                continue;
            }
            if (arg.getClass() == Double.class || arg.getClass() == Integer.class || arg.getClass() == Long.class) {
                ++count;
                continue;
            }
            if (arg.getClass() != String.class || !this.isValidDouble((String)arg)) continue;
            ++count;
        }
        return (long)count;
    }

    private boolean isValidDouble(String s) {
        try {
            double d = Double.parseDouble(s);
            return !Double.isNaN(d) && !Double.isInfinite(d);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

