/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Combin
extends AbstractFunction {
    public Combin() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.INT, "n", "The total number of objects."), new ArgDescriptor(ArgType.INT, "k", "The size of the selected subset.")});
    }

    public String getName() {
        return "COMBIN";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Returns number of combinations of n objects, with k chosen at any one time.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        long N = FunctionUtil.getArgAsLong((Object)args[0]);
        long K = FunctionUtil.getArgAsLong((Object)args[1]);
        if (N < 0L) {
            throw new IllegalArgumentException("1st argument to COMBIN() must not be negative.");
        }
        if (K < 0L) {
            throw new IllegalArgumentException("2nd argument to COMBIN() must not be negative.");
        }
        if (N < K) {
            throw new IllegalArgumentException("2nd argument to COMBIN() must not be less than 1st argument.");
        }
        if (K < 0L || K > N) {
            return 0L;
        }
        return this.combinations(N, K);
    }

    private long combinations(long n, long k) {
        long c2;
        if (k == 0L || n == k) {
            return 1L;
        }
        long c1 = this.combinations(n - 1L, k);
        long sum = c1 + (c2 = this.combinations(n - 1L, k - 1L));
        if (sum < c1 || sum < c2) {
            throw new ArithmeticException("overflow in call to COMBIN().");
        }
        return sum;
    }
}

