/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal;

import java.io.IOException;
import java.io.StringReader;
import org.cytoscape.equations.internal.Token;

public class Tokeniser {
    private final String equationAsString;
    private Token previousToken;
    private StringReader reader;
    private int tokenStartPos;
    private int previousTokenStartPos;
    private int currentPos;
    private long previousIntConstant;
    private long currentIntConstant;
    private String previousIdent;
    private String currentIdent;
    private double previousFloatConstant;
    private double currentFloatConstant;
    private String previousFloatString;
    private String currentFloatString;
    private boolean previousBooleanConstant;
    private boolean currentBooleanConstant;
    private String previousStringConstant;
    private String currentStringConstant;
    private int currentStringLiteralLength;
    private String errorMsg;
    private int previousChar;
    private boolean putBackChar;
    private boolean identifierInBraces;

    public Tokeniser(String equationAsString) {
        this.equationAsString = equationAsString;
        this.previousToken = null;
        this.reader = new StringReader(equationAsString);
        this.currentPos = -1;
        this.putBackChar = false;
        this.identifierInBraces = false;
    }

    public String getEquation() {
        return this.equationAsString;
    }

    public Token getToken() {
        if (this.previousToken != null) {
            Token retval = this.previousToken;
            this.previousToken = null;
            this.currentIntConstant = this.previousIntConstant;
            this.currentFloatConstant = this.previousFloatConstant;
            this.currentFloatString = this.previousFloatString;
            this.currentBooleanConstant = this.previousBooleanConstant;
            this.currentStringConstant = this.previousStringConstant;
            this.currentIdent = this.previousIdent;
            this.tokenStartPos = this.previousTokenStartPos;
            return retval;
        }
        int nextCh = this.getChar();
        while (nextCh != -1 && Character.isWhitespace((char)nextCh)) {
            nextCh = this.getChar();
        }
        this.tokenStartPos = this.currentPos;
        if (nextCh == -1) {
            this.tokenStartPos = this.equationAsString.length();
            return Token.EOS;
        }
        char ch = (char)nextCh;
        switch (ch) {
            case ':': {
                this.identifierInBraces = false;
                return Token.COLON;
            }
            case '^': {
                return Token.CARET;
            }
            case '{': {
                this.identifierInBraces = true;
                return Token.OPEN_BRACE;
            }
            case '}': {
                this.identifierInBraces = false;
                return Token.CLOSE_BRACE;
            }
            case '(': {
                return Token.OPEN_PAREN;
            }
            case ')': {
                return Token.CLOSE_PAREN;
            }
            case '+': {
                return Token.PLUS;
            }
            case '-': {
                return Token.MINUS;
            }
            case '/': {
                return Token.DIV;
            }
            case '*': {
                return Token.MUL;
            }
            case '=': {
                return Token.EQUAL;
            }
            case '$': {
                return Token.DOLLAR;
            }
            case ',': {
                return Token.COMMA;
            }
            case '&': {
                return Token.AMPERSAND;
            }
        }
        if (ch == '\"') {
            return this.parseStringConstant();
        }
        if (!this.identifierInBraces && (Character.isDigit(ch) || ch == '.')) {
            this.ungetChar(nextCh);
            return this.parseNumericConstant();
        }
        if (ch == '<') {
            nextCh = this.getChar();
            if (nextCh == -1) {
                return Token.LESS_THAN;
            }
            if ((char)nextCh == '>') {
                return Token.NOT_EQUAL;
            }
            if ((char)nextCh == '=') {
                return Token.LESS_OR_EQUAL;
            }
            this.ungetChar(nextCh);
            return Token.LESS_THAN;
        }
        if (ch == '>') {
            nextCh = this.getChar();
            if (nextCh == -1) {
                return Token.GREATER_THAN;
            }
            if ((char)nextCh == '=') {
                return Token.GREATER_OR_EQUAL;
            }
            this.ungetChar(nextCh);
            return Token.GREATER_THAN;
        }
        if (this.identifierInBraces || Character.isLetter(ch)) {
            this.ungetChar(nextCh);
            return this.identifierInBraces ? this.parseIdentifier() : this.parseSimpleIdentifier();
        }
        this.errorMsg = "unexpected input character '" + Character.toString(ch) + "'";
        return Token.ERROR;
    }

    public void ungetToken(Token token) throws IllegalStateException {
        if (this.previousToken != null) {
            throw new IllegalStateException("can't unget more than one token.");
        }
        this.previousToken = token;
        this.previousIntConstant = this.currentIntConstant;
        this.previousFloatConstant = this.currentFloatConstant;
        this.previousFloatString = this.currentFloatString;
        this.previousBooleanConstant = this.currentBooleanConstant;
        this.previousStringConstant = this.currentStringConstant;
        this.previousIdent = this.currentIdent;
        this.previousTokenStartPos = this.tokenStartPos;
    }

    public int getStartPos() {
        return this.tokenStartPos;
    }

    public int getCurrentPos() {
        return this.currentPos;
    }

    public String getTokenAsString() {
        Token token = this.getToken();
        if (token == Token.STRING_CONSTANT) {
            return "STRING_CONSTANT: \"" + this.getStringConstant() + "\"";
        }
        if (token == Token.FLOAT_CONSTANT) {
            return "FLOAT_CONSTANT: \"" + this.getFloatConstant() + "\"";
        }
        if (token == Token.BOOLEAN_CONSTANT) {
            return "BOOLEAN_CONSTANT: \"" + this.getBooleanConstant() + "\"";
        }
        if (token == Token.IDENTIFIER) {
            return "IDENTIFIER: \"" + this.getIdent() + "\"";
        }
        if (token == Token.ERROR) {
            return "ERROR: \"" + this.getErrorMsg();
        }
        return token.toString();
    }

    public String getStringConstant() {
        return this.currentStringConstant;
    }

    public int getCurrentStringLiteralLength() {
        return this.currentStringLiteralLength;
    }

    public double getFloatConstant() {
        return this.currentFloatConstant;
    }

    public String getFloatString() {
        return this.currentFloatString;
    }

    public boolean getBooleanConstant() {
        return this.currentBooleanConstant;
    }

    public long getIntConstant() {
        return this.currentIntConstant;
    }

    public String getIdent() {
        return this.currentIdent;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    private int getChar() {
        int retval;
        if (this.putBackChar) {
            ++this.currentPos;
            int retval2 = this.previousChar;
            this.putBackChar = false;
            return retval2;
        }
        try {
            retval = this.reader.read();
        }
        catch (IOException e) {
            return -1;
        }
        if (retval != -1) {
            ++this.currentPos;
        }
        return retval;
    }

    private char peek() {
        try {
            this.reader.mark(1);
            char c = (char)this.reader.read();
            this.reader.reset();
            return c;
        }
        catch (IOException e) {
            return '\uffff';
        }
    }

    private void ungetChar(int ch) {
        if (this.putBackChar) {
            throw new IllegalStateException("can't unget two chars in a row.");
        }
        this.previousChar = ch;
        this.putBackChar = true;
        --this.currentPos;
    }

    private Token parseStringConstant() {
        int nextCh;
        this.currentStringLiteralLength = 1;
        StringBuilder builder = new StringBuilder();
        boolean escaped = false;
        block5: while ((nextCh = this.getChar()) != -1) {
            ++this.currentStringLiteralLength;
            char ch = (char)nextCh;
            if (escaped) {
                escaped = false;
                switch (ch) {
                    case '\\': {
                        builder.append('\\');
                        continue block5;
                    }
                    case '\"': {
                        builder.append('\"');
                        continue block5;
                    }
                    case 'n': {
                        builder.append('\n');
                        continue block5;
                    }
                }
                this.errorMsg = "unknown escape character '" + Character.toString(ch) + "'";
                return Token.ERROR;
            }
            if (ch == '\\') {
                escaped = true;
                continue;
            }
            if (ch == '\"') {
                this.currentStringConstant = builder.toString();
                return Token.STRING_CONSTANT;
            }
            builder.append(ch);
        }
        this.errorMsg = "unterminated String constant.";
        return Token.ERROR;
    }

    private Token parseNumericConstant() {
        int ch;
        int INITIAL_CAPACITY = 20;
        StringBuilder builder = new StringBuilder(20);
        while ((ch = this.getChar()) != -1 && Character.isDigit((char)ch)) {
            builder.append((char)ch);
        }
        if (ch == -1 || (char)ch != 'e' && (char)ch != 'E' && (char)ch != '.') {
            try {
                double d;
                String s = builder.toString();
                this.currentFloatConstant = d = Double.parseDouble(s);
                this.currentFloatString = s;
                this.ungetChar(ch);
                return Token.FLOAT_CONSTANT;
            }
            catch (NumberFormatException e2) {
                this.errorMsg = "invalid numeric constant.";
                return Token.ERROR;
            }
        }
        if ((char)ch == '.') {
            builder.append((char)ch);
            while ((ch = this.getChar()) != -1 && Character.isDigit((char)ch)) {
                builder.append((char)ch);
            }
        }
        if ((char)ch == 'e' || (char)ch == 'E') {
            builder.append((char)ch);
            ch = this.getChar();
            if (ch == -1) {
                this.errorMsg = "invalid numeric constant.";
                return Token.ERROR;
            }
            if ((char)ch == '+' || (char)ch == '-') {
                builder.append((char)ch);
                ch = this.getChar();
            }
            if (!Character.isDigit((char)ch)) {
                this.errorMsg = "missing digits in exponent.";
                return Token.ERROR;
            }
            this.ungetChar(ch);
            while ((ch = this.getChar()) != -1 && Character.isDigit((char)ch)) {
                builder.append((char)ch);
            }
        }
        this.ungetChar(ch);
        try {
            double d;
            String s = builder.toString();
            this.currentFloatConstant = d = Double.parseDouble(s);
            this.currentFloatString = s;
            return Token.FLOAT_CONSTANT;
        }
        catch (NumberFormatException e3) {
            this.errorMsg = "invalid numeric constant.";
            return Token.ERROR;
        }
    }

    private Token parseIdentifier() {
        int ch;
        int INITIAL_CAPACITY = 20;
        StringBuilder builder = new StringBuilder(20);
        boolean escaped = false;
        while ((ch = this.getChar()) != -1 && ((char)ch != '}' && (char)ch != ',' && (char)ch != '(' && (char)ch != ')' || escaped)) {
            if (escaped) {
                escaped = false;
                builder.append((char)ch);
                continue;
            }
            if ((char)ch == ':') {
                if (this.peek() != ':') break;
                this.getChar();
                builder.append("::");
                continue;
            }
            if (ch == 92) {
                escaped = true;
                continue;
            }
            builder.append((char)ch);
        }
        if (escaped) {
            this.errorMsg = "invalid column name at end of formula.";
            return Token.ERROR;
        }
        this.ungetChar(ch);
        this.currentIdent = builder.toString();
        if (this.currentIdent.equalsIgnoreCase("TRUE")) {
            this.currentBooleanConstant = true;
            return Token.BOOLEAN_CONSTANT;
        }
        if (this.currentIdent.equalsIgnoreCase("FALSE")) {
            this.currentBooleanConstant = false;
            return Token.BOOLEAN_CONSTANT;
        }
        return Token.IDENTIFIER;
    }

    private Token parseSimpleIdentifier() {
        int ch;
        int INITIAL_CAPACITY = 20;
        StringBuilder builder = new StringBuilder(20);
        while ((ch = this.getChar()) != -1 && (Character.isLetter((char)ch) || Character.isDigit((char)ch) || (char)ch == '_')) {
            builder.append((char)ch);
        }
        this.ungetChar(ch);
        this.currentIdent = builder.toString();
        if (this.currentIdent.equalsIgnoreCase("TRUE")) {
            this.currentBooleanConstant = true;
            return Token.BOOLEAN_CONSTANT;
        }
        if (this.currentIdent.equalsIgnoreCase("FALSE")) {
            this.currentBooleanConstant = false;
            return Token.BOOLEAN_CONSTANT;
        }
        return Token.IDENTIFIER;
    }

    public static void main(String[] args) {
        for (String arg : args) {
            String tokenAsString;
            Tokeniser tokeniser = new Tokeniser(arg);
            do {
                tokenAsString = tokeniser.getTokenAsString();
                System.out.println(tokenAsString);
            } while (tokenAsString != "EOS");
        }
    }
}

