/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.cytoscape.equations.AbstractNode;
import org.cytoscape.equations.EquationParser;
import org.cytoscape.equations.Function;
import org.cytoscape.equations.FunctionUtil;
import org.cytoscape.equations.TreeNode;
import org.cytoscape.equations.event.EquationFunctionAddedEvent;
import org.cytoscape.equations.event.EquationFunctionRemovedEvent;
import org.cytoscape.equations.internal.ParseException;
import org.cytoscape.equations.internal.Token;
import org.cytoscape.equations.internal.Tokeniser;
import org.cytoscape.equations.internal.builtins.ACos;
import org.cytoscape.equations.internal.builtins.ASin;
import org.cytoscape.equations.internal.builtins.ATan2;
import org.cytoscape.equations.internal.builtins.Abs;
import org.cytoscape.equations.internal.builtins.And;
import org.cytoscape.equations.internal.builtins.Average;
import org.cytoscape.equations.internal.builtins.BList;
import org.cytoscape.equations.internal.builtins.Combin;
import org.cytoscape.equations.internal.builtins.Concatenate;
import org.cytoscape.equations.internal.builtins.Cos;
import org.cytoscape.equations.internal.builtins.Cosh;
import org.cytoscape.equations.internal.builtins.Count;
import org.cytoscape.equations.internal.builtins.Degrees;
import org.cytoscape.equations.internal.builtins.Error;
import org.cytoscape.equations.internal.builtins.Exp;
import org.cytoscape.equations.internal.builtins.FList;
import org.cytoscape.equations.internal.builtins.First;
import org.cytoscape.equations.internal.builtins.GeoMean;
import org.cytoscape.equations.internal.builtins.HarMean;
import org.cytoscape.equations.internal.builtins.IList;
import org.cytoscape.equations.internal.builtins.If;
import org.cytoscape.equations.internal.builtins.Largest;
import org.cytoscape.equations.internal.builtins.Last;
import org.cytoscape.equations.internal.builtins.Left;
import org.cytoscape.equations.internal.builtins.Len;
import org.cytoscape.equations.internal.builtins.ListToString;
import org.cytoscape.equations.internal.builtins.Ln;
import org.cytoscape.equations.internal.builtins.Log;
import org.cytoscape.equations.internal.builtins.Lower;
import org.cytoscape.equations.internal.builtins.Max;
import org.cytoscape.equations.internal.builtins.Median;
import org.cytoscape.equations.internal.builtins.Mid;
import org.cytoscape.equations.internal.builtins.Min;
import org.cytoscape.equations.internal.builtins.Mod;
import org.cytoscape.equations.internal.builtins.Mode;
import org.cytoscape.equations.internal.builtins.NormDist;
import org.cytoscape.equations.internal.builtins.Not;
import org.cytoscape.equations.internal.builtins.Now;
import org.cytoscape.equations.internal.builtins.Nth;
import org.cytoscape.equations.internal.builtins.Or;
import org.cytoscape.equations.internal.builtins.Permut;
import org.cytoscape.equations.internal.builtins.Pi;
import org.cytoscape.equations.internal.builtins.Product;
import org.cytoscape.equations.internal.builtins.Radians;
import org.cytoscape.equations.internal.builtins.Right;
import org.cytoscape.equations.internal.builtins.Round;
import org.cytoscape.equations.internal.builtins.SList;
import org.cytoscape.equations.internal.builtins.Sign;
import org.cytoscape.equations.internal.builtins.Sin;
import org.cytoscape.equations.internal.builtins.Sinh;
import org.cytoscape.equations.internal.builtins.Split;
import org.cytoscape.equations.internal.builtins.Sqrt;
import org.cytoscape.equations.internal.builtins.StDev;
import org.cytoscape.equations.internal.builtins.Substitute;
import org.cytoscape.equations.internal.builtins.Sum;
import org.cytoscape.equations.internal.builtins.Tan;
import org.cytoscape.equations.internal.builtins.Tanh;
import org.cytoscape.equations.internal.builtins.Text;
import org.cytoscape.equations.internal.builtins.Today;
import org.cytoscape.equations.internal.builtins.Trunc;
import org.cytoscape.equations.internal.builtins.Upper;
import org.cytoscape.equations.internal.builtins.Value;
import org.cytoscape.equations.internal.builtins.Var;
import org.cytoscape.equations.internal.parse_tree.BinOpNode;
import org.cytoscape.equations.internal.parse_tree.BooleanConstantNode;
import org.cytoscape.equations.internal.parse_tree.FConvNode;
import org.cytoscape.equations.internal.parse_tree.FloatConstantNode;
import org.cytoscape.equations.internal.parse_tree.FuncCallNode;
import org.cytoscape.equations.internal.parse_tree.IdentNode;
import org.cytoscape.equations.internal.parse_tree.SConvNode;
import org.cytoscape.equations.internal.parse_tree.StringConstantNode;
import org.cytoscape.equations.internal.parse_tree.UnaryOpNode;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EquationParserImpl
implements EquationParser {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private Tokeniser tokeniser;
    private Map<String, Function> nameToFunctionMap;
    private String lastErrorMessage;
    private int lastErrorLocation = -1;
    private TreeNode parseTree;
    private Map<String, Class<?>> variableNameToTypeMap;
    private Set<String> variableReferences;
    private Map<String, Object> defaultVariableValues;
    private Set<Function> registeredFunctions;
    private final CyServiceRegistrar serviceRegistrar;

    public EquationParserImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.nameToFunctionMap = new HashMap<String, Function>();
        this.registeredFunctions = new HashSet<Function>();
        this.parseTree = null;
        this.registerBuiltins();
    }

    @Deprecated
    public void registerFunction(Function func) throws IllegalArgumentException {
        this.registerFunctionInternal(func);
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        eventHelper.addEventPayload((Object)this, (Object)func, EquationFunctionAddedEvent.class);
    }

    public void registerFunctionInternal(Function func) throws IllegalArgumentException {
        String funcName = func.getName().toUpperCase();
        if (funcName == null || funcName.equals("")) {
            throw new IllegalArgumentException("empty or missing function name.");
        }
        if (this.nameToFunctionMap.get(funcName) != null) {
            throw new IllegalArgumentException("attempt at registering " + funcName + "() twice.");
        }
        this.nameToFunctionMap.put(funcName, func);
        this.registeredFunctions.add(func);
    }

    public Function getFunction(String functionName) {
        return this.nameToFunctionMap.get(functionName);
    }

    public Set<Function> getRegisteredFunctions() {
        return this.registeredFunctions;
    }

    public boolean parse(String formula, Map<String, Class<?>> variableNameToTypeMap) {
        if (formula == null) {
            throw new NullPointerException("formula string must not be null.");
        }
        if (formula.length() < 1 || formula.charAt(0) != '=') {
            throw new NullPointerException("0: formula string must start with an equal sign.");
        }
        this.variableNameToTypeMap = variableNameToTypeMap;
        this.variableReferences = new TreeSet<String>();
        this.defaultVariableValues = new TreeMap<String, Object>();
        this.tokeniser = new Tokeniser(formula.substring(1));
        this.lastErrorMessage = null;
        this.lastErrorLocation = -1;
        try {
            this.parseTree = this.parseExpr();
            Token token = this.tokeniser.getToken();
            int tokenStartPos = this.tokeniser.getStartPos();
            if (token != Token.EOS) {
                throw new ParseException(tokenStartPos, "premature end of expression: expected end-of-string, but found " + token + ".");
            }
        }
        catch (ParseException e) {
            this.lastErrorMessage = e.getErrorMsg();
            this.lastErrorLocation = e.getErrorLocation();
            return false;
        }
        catch (ArithmeticException | IllegalArgumentException | IllegalStateException e) {
            this.lastErrorMessage = e.getMessage();
            return false;
        }
        return true;
    }

    public Class<?> getType() {
        return this.parseTree == null ? null : this.parseTree.getType();
    }

    public String getErrorMsg() {
        return this.lastErrorMessage;
    }

    public int getErrorLocation() {
        return this.lastErrorLocation;
    }

    public Set<String> getVariableReferences() {
        return this.variableReferences;
    }

    public Map<String, Object> getDefaultVariableValues() {
        return this.defaultVariableValues;
    }

    public TreeNode getParseTree() {
        return this.parseTree;
    }

    private AbstractNode parseExpr() {
        AbstractNode term;
        int sourceLocation;
        Token token;
        AbstractNode exprNode = this.parseTerm();
        while (true) {
            token = this.tokeniser.getToken();
            sourceLocation = this.tokeniser.getStartPos();
            if (token != Token.PLUS && token != Token.MINUS && token != Token.AMPERSAND) break;
            term = this.parseTerm();
            if (token == Token.PLUS || token == Token.MINUS) {
                exprNode = this.handleBinaryArithmeticOp(token, sourceLocation, (TreeNode)exprNode, (TreeNode)term);
                continue;
            }
            exprNode = new BinOpNode(sourceLocation, Token.AMPERSAND, (TreeNode)exprNode, (TreeNode)term);
        }
        if (token.isComparisonOperator()) {
            term = this.parseTerm();
            return this.handleComparisonOp(token, sourceLocation, (TreeNode)exprNode, (TreeNode)term);
        }
        this.tokeniser.ungetToken(token);
        return exprNode;
    }

    private AbstractNode parseTerm() {
        Token token;
        AbstractNode termNode = this.parsePower();
        while (true) {
            token = this.tokeniser.getToken();
            int sourceLocation = this.tokeniser.getStartPos();
            if (token != Token.MUL && token != Token.DIV) break;
            AbstractNode powerNode = this.parsePower();
            termNode = this.handleBinaryArithmeticOp(token, sourceLocation, (TreeNode)termNode, (TreeNode)powerNode);
        }
        this.tokeniser.ungetToken(token);
        return termNode;
    }

    private AbstractNode parsePower() {
        AbstractNode powerNode = this.parseFactor();
        Token token = this.tokeniser.getToken();
        int sourceLocation = this.tokeniser.getStartPos();
        if (token == Token.CARET) {
            AbstractNode rhs = this.parsePower();
            powerNode = this.handleBinaryArithmeticOp(token, sourceLocation, (TreeNode)powerNode, (TreeNode)rhs);
        } else {
            this.tokeniser.ungetToken(token);
        }
        return powerNode;
    }

    private AbstractNode parseFactor() {
        Token token = this.tokeniser.getToken();
        int sourceLocation = this.tokeniser.getStartPos();
        if (token == Token.FLOAT_CONSTANT) {
            return new FloatConstantNode(sourceLocation, this.tokeniser.getFloatConstant());
        }
        if (token == Token.STRING_CONSTANT) {
            return new StringConstantNode(sourceLocation, this.tokeniser.getStringConstant());
        }
        if (token == Token.BOOLEAN_CONSTANT) {
            return new BooleanConstantNode(sourceLocation, this.tokeniser.getBooleanConstant());
        }
        if (token == Token.DOLLAR) {
            boolean usingOptionalBraces;
            int varRefStartPos = sourceLocation;
            token = this.tokeniser.getToken();
            sourceLocation = this.tokeniser.getStartPos();
            boolean bl = usingOptionalBraces = token == Token.OPEN_BRACE;
            if (usingOptionalBraces) {
                token = this.tokeniser.getToken();
                sourceLocation = this.tokeniser.getStartPos();
            }
            if (token != Token.IDENTIFIER) {
                throw new ParseException(sourceLocation, "identifier expected");
            }
            String ident = this.tokeniser.getIdent();
            Class<?> varRefType = this.variableNameToTypeMap.get(ident);
            if (varRefType == null) {
                throw new ParseException(sourceLocation, "unknown variable reference name: \"" + ident + "\"");
            }
            this.variableReferences.add(ident);
            Object defaultValue = null;
            if (usingOptionalBraces) {
                token = this.tokeniser.getToken();
                if (token == Token.COLON) {
                    token = this.tokeniser.getToken();
                    sourceLocation = this.tokeniser.getStartPos();
                    if (token != Token.FLOAT_CONSTANT && token != Token.STRING_CONSTANT && token != Token.BOOLEAN_CONSTANT) {
                        throw new ParseException(sourceLocation, "expected default value for variable reference");
                    }
                    switch (token) {
                        case FLOAT_CONSTANT: {
                            defaultValue = this.tokeniser.getFloatConstant();
                            break;
                        }
                        case BOOLEAN_CONSTANT: {
                            defaultValue = this.tokeniser.getBooleanConstant();
                            break;
                        }
                        case STRING_CONSTANT: {
                            defaultValue = String.valueOf(this.tokeniser.getStringConstant());
                        }
                    }
                    token = this.tokeniser.getToken();
                    sourceLocation = this.tokeniser.getStartPos();
                }
                if (token != Token.CLOSE_BRACE) {
                    throw new ParseException(sourceLocation, "closing brace expected");
                }
                this.defaultVariableValues.put(ident, defaultValue);
            }
            return new IdentNode(varRefStartPos, this.tokeniser.getIdent(), defaultValue, varRefType);
        }
        if (token == Token.OPEN_PAREN) {
            AbstractNode exprNode = this.parseExpr();
            token = this.tokeniser.getToken();
            if (token != Token.CLOSE_PAREN) {
                throw new ParseException(sourceLocation, "'(' expected");
            }
            return exprNode;
        }
        if (token == Token.PLUS || token == Token.MINUS) {
            AbstractNode factor = this.parseFactor();
            return this.handleUnaryOp(sourceLocation, token, (TreeNode)factor);
        }
        if (token == Token.IDENTIFIER) {
            this.tokeniser.ungetToken(token);
            return this.parseFunctionCall();
        }
        if (token == Token.ERROR) {
            throw new ParseException(sourceLocation, this.tokeniser.getErrorMsg());
        }
        throw new ParseException(sourceLocation, "unexpected input token: " + token);
    }

    private AbstractNode handleUnaryOp(int sourceLocation, Token operator, TreeNode operand) {
        Class operandType = operand.getType();
        if (operandType == Boolean.class || operandType == String.class || FunctionUtil.isTypeOfList((Class)operandType)) {
            throw new ParseException(sourceLocation, "can't apply a unary " + operator.asString() + " a boolean, string or list operand");
        }
        if (operandType == Double.class) {
            return new UnaryOpNode(sourceLocation, operator, operand);
        }
        return new UnaryOpNode(sourceLocation, operator, (TreeNode)new FConvNode(operand));
    }

    private AbstractNode parseFunctionCall() {
        int sourceLocation;
        Token token = this.tokeniser.getToken();
        int functionNameStartPos = this.tokeniser.getStartPos();
        if (token != Token.IDENTIFIER) {
            throw new ParseException(functionNameStartPos, "function name expected");
        }
        String originalName = this.tokeniser.getIdent();
        String functionNameCandidate = originalName.toUpperCase();
        if (functionNameCandidate.equals("DEFINED")) {
            return this.parseDefined();
        }
        Function func = this.nameToFunctionMap.get(functionNameCandidate);
        if (func == null) {
            if (this.tokeniser.getToken() == Token.OPEN_PAREN) {
                throw new ParseException(functionNameStartPos, "call to unknown function " + originalName + "()");
            }
            throw new ParseException(functionNameStartPos, "unknown text \"" + originalName + "\", maybe you forgot to put quotes around this text?");
        }
        token = this.tokeniser.getToken();
        int openParenPos = this.tokeniser.getStartPos();
        if (token != Token.OPEN_PAREN) {
            throw new ParseException(openParenPos, "expected '(' after function name \"" + functionNameCandidate + "\"");
        }
        ArrayList<Class> argTypes = new ArrayList<Class>();
        ArrayList<AbstractNode> args = new ArrayList<AbstractNode>();
        do {
            token = this.tokeniser.getToken();
            sourceLocation = this.tokeniser.getStartPos();
            if (token == Token.CLOSE_PAREN) break;
            this.tokeniser.ungetToken(token);
            AbstractNode exprNode = this.parseExpr();
            argTypes.add(exprNode.getType());
            args.add(exprNode);
            token = this.tokeniser.getToken();
            sourceLocation = this.tokeniser.getStartPos();
        } while (token == Token.COMMA);
        Class returnType = func.validateArgTypes(argTypes.toArray(new Class[argTypes.size()]));
        if (returnType == null) {
            throw new ParseException(openParenPos + 1, "invalid number or type of arguments in call to " + functionNameCandidate + "()");
        }
        if (token != Token.CLOSE_PAREN) {
            throw new ParseException(sourceLocation, "expected the closing parenthesis of a call to " + functionNameCandidate);
        }
        AbstractNode[] nodeArray = new AbstractNode[args.size()];
        return new FuncCallNode(functionNameStartPos, func, returnType, (TreeNode[])args.toArray(nodeArray));
    }

    private AbstractNode parseDefined() {
        Class<?> varRefType;
        Token token = this.tokeniser.getToken();
        int definedStart = this.tokeniser.getStartPos();
        if (token != Token.OPEN_PAREN) {
            throw new ParseException(definedStart, "\"(\" expected after \"DEFINED\"");
        }
        token = this.tokeniser.getToken();
        int sourceLocation = this.tokeniser.getStartPos();
        if (token != Token.DOLLAR) {
            if (token != Token.IDENTIFIER) {
                throw new ParseException(sourceLocation, "variable reference expected after \"DEFINED(\"");
            }
            varRefType = this.variableNameToTypeMap.get(this.tokeniser.getIdent());
        } else {
            token = this.tokeniser.getToken();
            sourceLocation = this.tokeniser.getStartPos();
            if (token != Token.OPEN_BRACE) {
                throw new ParseException(sourceLocation, "\"{\" expected after \"DEFINED($\"");
            }
            token = this.tokeniser.getToken();
            sourceLocation = this.tokeniser.getStartPos();
            if (token != Token.IDENTIFIER) {
                throw new ParseException(sourceLocation, "variable reference expected after \"DEFINED(${\"");
            }
            varRefType = this.variableNameToTypeMap.get(this.tokeniser.getIdent());
            token = this.tokeniser.getToken();
            sourceLocation = this.tokeniser.getStartPos();
            if (token != Token.CLOSE_BRACE) {
                throw new ParseException(sourceLocation, "\"}\" expected after after \"DEFINED(${" + this.tokeniser.getIdent() + "\"");
            }
        }
        token = this.tokeniser.getToken();
        sourceLocation = this.tokeniser.getStartPos();
        if (token != Token.CLOSE_PAREN) {
            throw new ParseException(sourceLocation, "missing \")\" in call to DEFINED()");
        }
        return new BooleanConstantNode(definedStart, varRefType != null);
    }

    private TreeNode handleFConv(TreeNode tn) {
        Class type = tn.getType();
        if (type == Long.class || type == Integer.class || type == Boolean.class || type == String.class) {
            return new FConvNode(tn);
        }
        if (type == Double.class) {
            return tn;
        }
        return null;
    }

    private AbstractNode handleBinaryArithmeticOp(Token operator, int sourceLocation, TreeNode lhs, TreeNode rhs) {
        Class lhsType = lhs.getType();
        Class rhsType = rhs.getType();
        TreeNode newLhs = this.handleFConv(lhs);
        TreeNode newRhs = this.handleFConv(rhs);
        if (newLhs == null || newRhs == null) {
            throw new ParseException(sourceLocation, "incompatible operands for \"" + operator.asString() + "\". (lhs=" + lhsType.getSimpleName() + ", rhs=" + rhsType.getSimpleName() + ")");
        }
        return new BinOpNode(sourceLocation, operator, newLhs, newRhs);
    }

    private AbstractNode handleComparisonOp(Token operator, int sourceLocation, TreeNode lhs, TreeNode rhs) {
        Class lhsType = lhs.getType();
        Class rhsType = rhs.getType();
        if (lhsType == Double.class && rhsType == Double.class) {
            return new BinOpNode(sourceLocation, operator, lhs, rhs);
        }
        if (lhsType == Double.class && (rhsType == Long.class || rhsType == Integer.class)) {
            return new BinOpNode(sourceLocation, operator, lhs, (TreeNode)new FConvNode(rhs));
        }
        if (lhsType == Double.class && rhsType == Boolean.class) {
            return new BinOpNode(sourceLocation, operator, lhs, (TreeNode)new FConvNode(rhs));
        }
        if (lhsType == Double.class && (rhsType == Long.class || rhsType == Integer.class)) {
            return new BinOpNode(sourceLocation, operator, lhs, (TreeNode)new FConvNode(rhs));
        }
        if ((lhsType == Long.class || lhsType == Integer.class) && rhsType == Double.class) {
            return new BinOpNode(sourceLocation, operator, (TreeNode)new FConvNode(lhs), rhs);
        }
        if (!(lhsType != Long.class && lhsType != Integer.class || rhsType != Long.class && rhsType != Integer.class && rhsType != Boolean.class && rhsType != String.class)) {
            return new BinOpNode(sourceLocation, operator, (TreeNode)new FConvNode(lhs), (TreeNode)new FConvNode(rhs));
        }
        if (lhsType == Boolean.class && rhsType == Boolean.class) {
            return new BinOpNode(sourceLocation, operator, lhs, rhs);
        }
        if (lhsType == Boolean.class && rhsType == Double.class) {
            return new BinOpNode(sourceLocation, operator, (TreeNode)new FConvNode(lhs), rhs);
        }
        if (lhsType == Boolean.class && (rhsType == Long.class || rhsType == Integer.class)) {
            return new BinOpNode(sourceLocation, operator, (TreeNode)new FConvNode(lhs), (TreeNode)new FConvNode(rhs));
        }
        if (lhsType == Boolean.class && rhsType == String.class) {
            return new BinOpNode(sourceLocation, operator, (TreeNode)new SConvNode(lhs), rhs);
        }
        if (lhsType == String.class && rhsType == String.class) {
            return new BinOpNode(sourceLocation, operator, lhs, rhs);
        }
        if (lhsType == String.class && (rhsType == Double.class || rhsType == Long.class || rhsType == Integer.class || rhsType == Boolean.class)) {
            return new BinOpNode(sourceLocation, operator, lhs, (TreeNode)new SConvNode(rhs));
        }
        throw new ParseException(sourceLocation, "incompatible operands for \"" + operator.asString() + "\". (lhs=" + lhs.toString() + ":" + lhsType + ", rhs=" + rhs.toString() + ":" + rhsType + ")");
    }

    private void registerBuiltins() {
        this.registerFunctionInternal((Function)new Abs());
        this.registerFunctionInternal((Function)new ACos());
        this.registerFunctionInternal((Function)new ASin());
        this.registerFunctionInternal((Function)new And());
        this.registerFunctionInternal((Function)new ATan2());
        this.registerFunctionInternal((Function)new Average());
        this.registerFunctionInternal((Function)new BList());
        this.registerFunctionInternal((Function)new Combin());
        this.registerFunctionInternal((Function)new Concatenate());
        this.registerFunctionInternal((Function)new Cos());
        this.registerFunctionInternal((Function)new Cosh());
        this.registerFunctionInternal((Function)new Count());
        this.registerFunctionInternal((Function)new Degrees());
        this.registerFunctionInternal((Function)new Error());
        this.registerFunctionInternal((Function)new Exp());
        this.registerFunctionInternal((Function)new First());
        this.registerFunctionInternal((Function)new FList());
        this.registerFunctionInternal((Function)new GeoMean());
        this.registerFunctionInternal((Function)new HarMean());
        this.registerFunctionInternal((Function)new If());
        this.registerFunctionInternal((Function)new IList());
        this.registerFunctionInternal((Function)new Largest());
        this.registerFunctionInternal((Function)new Last());
        this.registerFunctionInternal((Function)new Left());
        this.registerFunctionInternal((Function)new Len());
        this.registerFunctionInternal((Function)new ListToString());
        this.registerFunctionInternal((Function)new Ln());
        this.registerFunctionInternal((Function)new Log());
        this.registerFunctionInternal((Function)new Lower());
        this.registerFunctionInternal((Function)new Max());
        this.registerFunctionInternal((Function)new Median());
        this.registerFunctionInternal((Function)new Mid());
        this.registerFunctionInternal((Function)new Min());
        this.registerFunctionInternal((Function)new Mod());
        this.registerFunctionInternal((Function)new Mode());
        this.registerFunctionInternal((Function)new Not());
        this.registerFunctionInternal((Function)new NormDist());
        this.registerFunctionInternal((Function)new Now());
        this.registerFunctionInternal((Function)new Nth());
        this.registerFunctionInternal((Function)new Or());
        this.registerFunctionInternal((Function)new Permut());
        this.registerFunctionInternal((Function)new Pi());
        this.registerFunctionInternal((Function)new Product());
        this.registerFunctionInternal((Function)new Radians());
        this.registerFunctionInternal((Function)new Right());
        this.registerFunctionInternal((Function)new Round());
        this.registerFunctionInternal((Function)new Sign());
        this.registerFunctionInternal((Function)new Sin());
        this.registerFunctionInternal((Function)new Sinh());
        this.registerFunctionInternal((Function)new SList());
        this.registerFunctionInternal((Function)new Split());
        this.registerFunctionInternal((Function)new StDev());
        this.registerFunctionInternal((Function)new Sqrt());
        this.registerFunctionInternal((Function)new Substitute());
        this.registerFunctionInternal((Function)new Sum());
        this.registerFunctionInternal((Function)new Tan());
        this.registerFunctionInternal((Function)new Tanh());
        this.registerFunctionInternal((Function)new Text());
        this.registerFunctionInternal((Function)new Today());
        this.registerFunctionInternal((Function)new Trunc());
        this.registerFunctionInternal((Function)new Upper());
        this.registerFunctionInternal((Function)new Value());
        this.registerFunctionInternal((Function)new Var());
    }

    public void registerFunctionService(Function function, Map<?, ?> props) {
        if (function != null) {
            this.registerFunctionInternal(function);
            CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
            eventHelper.addEventPayload((Object)this, (Object)function, EquationFunctionAddedEvent.class);
            logger.debug("New Function Registered: " + function.getName());
        }
    }

    public void unregisterFunctionService(Function function, Map<?, ?> props) {
        if (function != null) {
            this.registeredFunctions.remove(function);
            this.nameToFunctionMap.remove(function.getName().toUpperCase(), function);
            CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
            eventHelper.addEventPayload((Object)this, (Object)function, EquationFunctionRemovedEvent.class);
        }
    }
}

