/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.aMatReader.internal.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class MatrixTriangleSelector
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    private ToggleDirectedButton directedButton;
    private ToggleAreaButton rowNamesButton;
    private ToggleAreaButton columnNamesButton;

    public MatrixTriangleSelector(boolean rowNames, boolean columnNames, boolean undirected) {
        this.setLayout(null);
        int width = 200;
        int height = 200;
        this.setSize(width, height);
        this.directedButton = new ToggleDirectedButton();
        this.directedButton.setSelected(!undirected);
        this.rowNamesButton = new ToggleAreaButton("Row Names");
        this.rowNamesButton.setSelected(rowNames);
        this.columnNamesButton = new ToggleAreaButton("Column Names");
        this.columnNamesButton.setSelected(columnNames);
        this.rowNamesButton.setTextRotation(-1.5707963267948966);
        this.add(this.directedButton);
        this.add(this.rowNamesButton);
        this.add(this.columnNamesButton);
        int fontSize = 20;
        this.directedButton.setBounds(fontSize, fontSize, width - fontSize, height - fontSize);
        this.rowNamesButton.setBounds(0, fontSize, fontSize, height - fontSize);
        this.columnNamesButton.setBounds(fontSize, 0, width - fontSize, fontSize);
        this.addComponentListener(this);
    }

    public boolean isUndirected() {
        return !this.directedButton.isSelected();
    }

    public boolean hasRowNames() {
        return this.rowNamesButton.isSelected();
    }

    public boolean hasColumnNames() {
        return this.columnNamesButton.isSelected();
    }

    public void setButtons(boolean rowNames, boolean columnNames, Boolean undirected) {
        if (undirected != null) {
            this.directedButton.setSelected(undirected == false);
        }
        this.rowNamesButton.setSelected(rowNames);
        this.columnNamesButton.setSelected(columnNames);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int width = this.getWidth();
        int height = this.getHeight();
        int mid = Math.min(width, height);
        int fontSize = 20;
        mid = Math.max(mid, 150);
        int x = width / 2 - mid / 2;
        this.directedButton.setBounds(x + fontSize, fontSize, mid - fontSize, mid - fontSize);
        this.rowNamesButton.setBounds(x, fontSize, fontSize, mid - fontSize);
        this.columnNamesButton.setBounds(x + fontSize, 0, mid - fontSize, fontSize);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public static void main(String[] args) {
        MatrixTriangleSelector sel = new MatrixTriangleSelector(true, true, false);
        JFrame f = new JFrame();
        f.add(sel);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    class ToggleDirectedButton
    extends ToggleAreaButton {
        private static final long serialVersionUID = 4237673574772967581L;

        public ToggleDirectedButton() {
            super("Directed");
        }

        protected int[] getTriangleXPoints() {
            return new int[]{0, this.getSize().width, this.getSize().width};
        }

        protected int[] getTriangleYPoints() {
            return new int[]{0, 0, this.getSize().height};
        }

        @Override
        protected void paintComponent(Graphics g) {
            Color gColor = new Color(100, 200, 100);
            if (this.getModel().isArmed()) {
                gColor = gColor.darker();
            } else if (this.getModel().isRollover()) {
                gColor = gColor.brighter();
            }
            super.paintComponent(g);
            if (!this.isSelected()) {
                int[] x = this.getTriangleXPoints();
                int[] y = this.getTriangleYPoints();
                g.setColor(gColor);
                g.fillPolygon(x, y, x.length);
            }
        }

        @Override
        public String getText() {
            return this.isSelected() ? "Directed" : "Undirected";
        }
    }

    class ToggleAreaButton
    extends JToggleButton {
        private static final long serialVersionUID = 1L;
        private double textAngle;
        Polygon polygon;

        public ToggleAreaButton(String label) {
            super(label, true);
            this.textAngle = 0.0;
            Dimension size = this.getPreferredSize();
            size.width = size.height = Math.max(size.width, size.height);
            this.setPreferredSize(size);
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(true);
        }

        public void setTextRotation(double angle) {
            this.textAngle = angle;
        }

        protected int[] getXPoints() {
            return new int[]{0, this.getSize().width, this.getSize().width, 0};
        }

        protected int[] getYPoints() {
            return new int[]{0, 0, this.getSize().height, this.getSize().height};
        }

        @Override
        protected void paintComponent(Graphics g) {
            Color color = Color.GRAY;
            if (this.getModel().isSelected()) {
                color = new Color(100, 200, 100);
            }
            if (this.getModel().isArmed()) {
                color = color.darker();
            } else if (this.getModel().isRollover()) {
                color = color.brighter();
            }
            g.setColor(color);
            int[] x = this.getXPoints();
            int[] y = this.getYPoints();
            g.fillPolygon(x, y, x.length);
        }

        @Override
        protected void paintBorder(Graphics g) {
            int[] x = this.getXPoints();
            int[] y = this.getYPoints();
            g.setColor(this.getForeground());
            g.drawPolygon(x, y, x.length);
            this.drawLabel((Graphics2D)g);
        }

        public void drawLabel(Graphics2D g) {
            int[] x = this.getXPoints();
            int[] y = this.getYPoints();
            int xMean = 0;
            int yMean = 0;
            for (int i = 0; i < x.length; ++i) {
                xMean += x[i];
                yMean += y[i];
            }
            xMean /= x.length;
            yMean /= y.length;
            String s = this.getText();
            Font font = g.getFont();
            Rectangle2D textRect = g.getFontMetrics().getStringBounds(s, g);
            int textWidth = (int)textRect.getWidth();
            int textHeight = (int)textRect.getHeight();
            int tx = xMean - textWidth / 2;
            int ty = yMean + textHeight / 2;
            if (this.textAngle != 0.0) {
                AffineTransform fontAT = new AffineTransform();
                fontAT.rotate(this.textAngle);
                font = font.deriveFont(fontAT);
                tx = xMean + textHeight / 2;
                ty = yMean + textWidth / 2;
            }
            g.setFont(font);
            g.drawString(s, tx, ty);
        }

        @Override
        public boolean contains(int x, int y) {
            int[] xP = this.getXPoints();
            int[] yP = this.getYPoints();
            if (this.polygon == null || !this.polygon.getBounds().equals(this.getBounds())) {
                this.polygon = new Polygon(xP, yP, xP.length);
            }
            return this.polygon.contains(x, y);
        }
    }
}

