/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.aMatReader.internal.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.cytoscape.aMatReader.internal.util.Delimiter;
import org.cytoscape.aMatReader.internal.util.PrefixedVector;
import org.cytoscape.aMatReader.internal.util.ResettableBufferedReader;

public class MatrixParser {
    private Vector<String> rowNames;
    private PrefixedVector columnNames;
    private final HashMap<Integer, Map<Integer, Double>> edgeMap;
    private final MatrixParameters parameters;

    public MatrixParser(MatrixParameters params) throws IOException, MatrixParseException {
        this.parameters = params;
        this.rowNames = new Vector();
        this.columnNames = new PrefixedVector();
        this.edgeMap = new HashMap();
    }

    public int edgeCount() {
        int count = 0;
        for (int src : this.edgeMap.keySet()) {
            Map<Integer, Double> map = this.edgeMap.get(src);
            count += map.size();
        }
        return count;
    }

    public String getRowName(int i) {
        if (this.rowNames.isEmpty()) {
            return "Node " + i;
        }
        return this.rowNames.get(i);
    }

    public int getRowCount() {
        return this.rowNames.size();
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public String getColumnName(int i) {
        if (this.columnNames.isEmpty()) {
            return "Node " + i;
        }
        return (String)this.columnNames.get(i);
    }

    public Map<Integer, Map<Integer, Double>> getEdges() {
        return this.edgeMap;
    }

    private void readColumnNames(String[] names) {
        int start;
        int n = start = this.parameters.hasRowNames ? 1 : 0;
        while (start < names.length) {
            if (!names[start].isEmpty()) {
                String name = names[start];
                if (name.startsWith(this.parameters.columnPrefix)) {
                    name = name.substring(this.parameters.columnPrefix.length(), name.length());
                }
                this.columnNames.add(name);
            }
            ++start;
        }
    }

    private void parseRow(int rowNumber, String[] row, boolean undirected) {
        HashMap<Integer, Double> tgtMap = new HashMap<Integer, Double>();
        for (int start = undirected ? rowNumber + 1 : 0; start < row.length; ++start) {
            Double value = MatrixParser.getValue(row[start]);
            if (value == null || this.parameters.ignoreZeros && value == 0.0) continue;
            tgtMap.put(start, value);
        }
        this.edgeMap.put(rowNumber, tgtMap);
    }

    public boolean buildNetwork(ResettableBufferedReader reader) throws IOException, MatrixParseException {
        String[] row;
        boolean pastColumnLine;
        int rowNumber = 0;
        boolean bl = pastColumnLine = !this.parameters.hasColumnNames;
        while ((row = this.readRow(reader, this.parameters.delimiter)) != null) {
            if (row.length == 0) continue;
            if (!pastColumnLine) {
                this.readColumnNames(row);
                if (!this.parameters.hasRowNames) {
                    this.rowNames = this.columnNames;
                }
                pastColumnLine = true;
                continue;
            }
            String name = "";
            if (this.parameters.hasRowNames) {
                name = row[0];
                this.rowNames.add(name);
                row = Arrays.copyOfRange(row, 1, row.length);
                if (!this.parameters.hasColumnNames) {
                    if (this.columnNames.isEmpty()) {
                        for (int i = 1; i <= row.length; ++i) {
                            this.columnNames.add("Node " + i);
                        }
                    }
                    this.columnNames.set(rowNumber, name);
                }
            }
            if (name.isEmpty()) {
                name = this.getColumnName(rowNumber);
            }
            this.parseRow(rowNumber, row, this.parameters.undirected);
            ++rowNumber;
        }
        return true;
    }

    private String[] readRow(ResettableBufferedReader input, Delimiter delimiter) throws IOException {
        String row = input.readLine();
        if (row == null) {
            return null;
        }
        if (row.startsWith("#")) {
            return new String[0];
        }
        String delim = delimiter.getDelimiter();
        String[] columns = row.split(delim, -1);
        return columns;
    }

    private static Double getValue(String value) {
        Double v = null;
        if (value == null) {
            return null;
        }
        try {
            v = new Double(value);
            if (v.isNaN()) {
                v = null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return v;
    }

    public static MatrixParameters predictParameters(ResettableBufferedReader reader) throws IOException {
        MatrixParameters prediction = new MatrixParameters();
        try {
            PrefixedVector pv;
            String firstLine = "#";
            while (firstLine.startsWith("#")) {
                reader.peekLine();
                firstLine = reader.readLine();
            }
            String secondLine = "#";
            while (secondLine.startsWith("#")) {
                reader.peekLine();
                secondLine = reader.readLine();
            }
            int numItems = 0;
            for (Delimiter delim : Delimiter.values()) {
                String[] secondRow = secondLine.split(delim.delimiter, -1);
                if (secondRow.length <= numItems) continue;
                numItems = secondRow.length;
                prediction.delimiter = delim;
            }
            String[] firstRow = firstLine.split(prediction.delimiter.delimiter, -1);
            String[] secondRow = secondLine.split(prediction.delimiter.delimiter, -1);
            for (int i = 1; i < firstRow.length; ++i) {
                String col = firstRow[i];
                if (col.isEmpty() || MatrixParser.getValue(col) != null) continue;
                prediction.hasColumnNames = true;
                break;
            }
            if (!secondRow[0].isEmpty() && MatrixParser.getValue(secondRow[0]) == null) {
                prediction.hasRowNames = true;
            }
            if (prediction.hasRowNames) {
                firstRow = Arrays.copyOfRange(firstRow, 1, firstRow.length);
            }
            if ((pv = new PrefixedVector(firstRow)).hasPrefix()) {
                prediction.columnPrefix = pv.getPrefix();
            }
            if (prediction.hasColumnNames && prediction.hasRowNames && secondRow[0].startsWith(prediction.columnPrefix)) {
                prediction.columnPrefix = "";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        reader.reset();
        return prediction;
    }

    private Vector<String> getEdgeStrings() {
        Vector<String> edges = new Vector<String>();
        for (int s : this.edgeMap.keySet()) {
            Map<Integer, Double> tgtMap = this.edgeMap.get(s);
            for (int t : tgtMap.keySet()) {
                double value = tgtMap.get(t);
                edges.add(this.getRowName(s) + " - " + this.getColumnName(t) + " = " + value);
            }
        }
        return edges;
    }

    public void removeColumnPrefix() {
        if (this.columnNames.hasPrefix()) {
            this.parameters.columnPrefix = this.columnNames.getPrefix();
        }
        if (this.parameters.columnPrefix != null && !this.parameters.columnPrefix.isEmpty()) {
            for (int i = 0; i < this.columnNames.size(); ++i) {
                String name = (String)this.columnNames.get(i);
                if (!name.startsWith(this.parameters.columnPrefix)) continue;
                name = name.substring(this.parameters.columnPrefix.length());
                this.columnNames.set(i, name);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String[] files = new String[]{"/Users/bsettle/git/aMatReader/samples/sample.mat", "/Users/bsettle/git/aMatReader/samples/sampleNoHeaderRow.mat", "/Users/bsettle/git/aMatReader/samples/sampleNoHeaderColumn.mat", "/Users/bsettle/git/aMatReader/samples/crazyTest.csv", "/Users/bsettle/git/aMatReader/samples/crazyTest2.txt", "/Users/bsettle/git/aMatReader/samples/crazyTest3.txt"};
        String outputAnswer = null;
        for (String f : files) {
            System.out.println(f);
            FileInputStream in = new FileInputStream(f);
            ResettableBufferedReader reader = new ResettableBufferedReader(new BufferedInputStream(in));
            MatrixParameters pred = MatrixParser.predictParameters(reader);
            pred.ignoreZeros = true;
            pred.undirected = false;
            MatrixParser p = new MatrixParser(pred);
            p.buildNetwork(reader);
            reader.close();
            Vector<String> strs = p.getEdgeStrings();
            Object[] strsArr = new String[strs.size()];
            strs.toArray(strsArr);
            Arrays.sort(strsArr);
            String output = String.join((CharSequence)"\n", (CharSequence[])strsArr);
            if (outputAnswer == null) {
                System.out.println(" = \n" + output);
                outputAnswer = output;
                continue;
            }
            if (!output.equals(outputAnswer)) {
                System.out.println(" mismatch = \n" + output);
                break;
            }
            System.out.println("match");
        }
    }

    public static class MatrixParameters {
        public Delimiter delimiter = Delimiter.TAB;
        public boolean hasRowNames = false;
        public boolean hasColumnNames = false;
        public String columnPrefix = "";
        public boolean ignoreZeros = true;
        public boolean undirected = false;

        public MatrixParameters(Delimiter delimiter, boolean ignoreZeros, boolean hasRowNames, boolean hasColumnNames, boolean undirected) {
            this.delimiter = delimiter;
            this.hasRowNames = hasRowNames;
            this.hasColumnNames = hasColumnNames;
            this.ignoreZeros = ignoreZeros;
            this.undirected = undirected;
        }

        public MatrixParameters() {
        }
    }

    public class MatrixParseException
    extends Exception {
        private static final long serialVersionUID = 2747259808393035815L;

        public MatrixParseException(String message) {
            super(message);
        }
    }
}

