/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.aMatReader.internal.rest;

import io.swagger.annotations.Api;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.cytoscape.aMatReader.internal.CyActivator;
import org.cytoscape.aMatReader.internal.ResourceManager;
import org.cytoscape.aMatReader.internal.rest.AMatReaderParameters;
import org.cytoscape.aMatReader.internal.rest.AMatReaderResource;
import org.cytoscape.aMatReader.internal.rest.AMatReaderResult;
import org.cytoscape.aMatReader.internal.rest.AMatReaderTaskObserver;
import org.cytoscape.aMatReader.internal.tasks.AMatReaderTask;
import org.cytoscape.aMatReader.internal.util.Delimiter;
import org.cytoscape.aMatReader.internal.util.MatrixParser;
import org.cytoscape.aMatReader.internal.util.ResettableBufferedReader;
import org.cytoscape.ci.CIErrorFactory;
import org.cytoscape.ci.CIResponseFactory;
import org.cytoscape.ci.CIWrapping;
import org.cytoscape.ci.model.CIError;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Apps: aMatReader"})
@Path(value="/aMatReader/v1/")
public class AMatReaderResourceImpl
implements AMatReaderResource {
    private final ResourceManager resourceManager;
    private final CyNetworkManager netMngr;
    private final AMatReaderTaskObserver taskObserver;
    private static final Logger logger = LoggerFactory.getLogger(AMatReaderResource.class);
    private static final String resourceErrorRoot = "urn:cytoscape:ci:aMatReader-app:v1";

    public AMatReaderResourceImpl(CyServiceRegistrar registrar, ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.netMngr = (CyNetworkManager)registrar.getService(CyNetworkManager.class);
        this.taskObserver = new AMatReaderTaskObserver(this, "aMatReader", "3");
    }

    private CIError buildCIError(int status, String resourcePath, String code, String message, Exception e) {
        CIErrorFactory ciErrorFactory = CyActivator.serviceManager.getCIErrorFactory();
        return ciErrorFactory.getCIError(Integer.valueOf(status), "urn:cytoscape:ci:aMatReader-app:v1:" + resourcePath + ":" + code, message);
    }

    public CIResponse<Object> buildCIErrorResponse(int status, String resourcePath, String code, String message, Exception e) {
        CIResponseFactory ciResponseFactory = CyActivator.serviceManager.getCIResponseFactory();
        CIResponse response = ciResponseFactory.getCIResponse(new Object());
        CIError error = this.buildCIError(status, resourcePath, code, message, e);
        if (e != null) {
            logger.error(message, (Throwable)e);
        } else {
            logger.error(message);
        }
        response.errors.add(error);
        return response;
    }

    private Response buildErrorResponse(Response.Status server_code, String error_code, Exception e) {
        return Response.status((Response.Status)server_code).type("application/json").entity(this.buildCIErrorResponse(server_code.getStatusCode(), "aMatReader", error_code, e.getMessage(), e)).build();
    }

    @Override
    @CIWrapping
    public Response aMatReader(AMatReaderParameters aMatReaderParameters) {
        return this.aMatReaderImport(null, aMatReaderParameters);
    }

    @Override
    @CIWrapping
    public Response aMatReaderExtend(long networkSUID, AMatReaderParameters aMatReaderParameters) {
        return this.aMatReaderImport(new Long(networkSUID), aMatReaderParameters);
    }

    public Response aMatReaderImport(Long networkSUID, AMatReaderParameters params) {
        if (params == null) {
            return this.buildErrorResponse(Response.Status.BAD_REQUEST, "2", new Exception("No parameters provided"));
        }
        if (params.files == null) {
            return this.buildErrorResponse(Response.Status.BAD_REQUEST, "2", new Exception("No files provided"));
        }
        Map<String, Object> context = null;
        try {
            context = this.buildContext(params);
        }
        catch (Exception e) {
            return this.buildErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, "2", e);
        }
        CyNetwork network = null;
        if (networkSUID != null && (network = this.netMngr.getNetwork(networkSUID.longValue())) == null) {
            String message = "Network with SUID " + networkSUID + " not found";
            return this.buildErrorResponse(Response.Status.NOT_FOUND, "2", new Exception(message));
        }
        Response resp = this.importFiles(network, params, context);
        this.taskObserver.allFinished(FinishStatus.getSucceeded());
        return resp;
    }

    public Map<String, Object> buildContext(AMatReaderParameters params) throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (params.delimiter == null) {
            throw new NullPointerException("Delimiter value not recognized. Must be one of " + Delimiter.values());
        }
        context.put("delimiter", (Object)params.delimiter);
        context.put("undirected", params.undirected);
        context.put("interactionName", params.interactionName);
        context.put("rowNames", params.rowNames);
        context.put("columnNames", params.columnNames);
        context.put("ignoreZeros", params.ignoreZeros);
        context.put("removeColumnPrefix", params.removeColumnPrefix);
        return context;
    }

    public Response importFiles(CyNetwork network, AMatReaderParameters params, Map<String, Object> context) {
        CyNetwork net = network;
        for (String f : params.files) {
            try {
                CIResponse<?> response = this.importFile(net, f, context);
                if (response instanceof AMatReaderResource.AMatReaderResponse) {
                    Long suid = ((AMatReaderResult)this.taskObserver.aMatResponse.data).suid;
                    if (net != null || suid == null) continue;
                    net = this.resourceManager.netManager.getNetwork(suid.longValue());
                    continue;
                }
                if (net == null) break;
                this.resourceManager.netManager.destroyNetwork(net);
                break;
            }
            catch (FileNotFoundException e) {
                if (net != null) {
                    this.resourceManager.netManager.destroyNetwork(net);
                }
                return this.buildErrorResponse(Response.Status.NOT_FOUND, "1", e);
            }
            catch (IOException | SecurityException e) {
                if (net != null) {
                    this.resourceManager.netManager.destroyNetwork(net);
                }
                return this.buildErrorResponse(Response.Status.BAD_REQUEST, "1", e);
            }
            catch (NullPointerException e) {
                if (net != null) {
                    this.resourceManager.netManager.destroyNetwork(net);
                }
                return this.buildErrorResponse(Response.Status.BAD_REQUEST, "3", e);
            }
        }
        this.taskObserver.allFinished(FinishStatus.getSucceeded());
        CIResponse<?> resp = this.taskObserver.getResponse();
        return Response.status((Response.Status)(resp.errors.size() == 0 ? Response.Status.OK : Response.Status.INTERNAL_SERVER_ERROR)).type("application/json").entity(resp).build();
    }

    public CIResponse<?> runTask(CyNetwork network, InputStream is, String name, Map<String, Object> context) throws IOException, NullPointerException {
        ResettableBufferedReader reader = new ResettableBufferedReader(is);
        AMatReaderTask task = network == null ? new AMatReaderTask(reader, name, this.resourceManager) : new AMatReaderTask(network, reader, name, this.resourceManager);
        this.resourceManager.taskManager.setExecutionContext(context);
        this.resourceManager.taskManager.execute(new TaskIterator(new Task[]{task}));
        this.taskObserver.taskFinished(task);
        return this.taskObserver.getResponse();
    }

    public CIResponse<?> importFile(CyNetwork network, String filename, Map<String, Object> context) throws FileNotFoundException, NullPointerException, SecurityException, IOException {
        File f = new File(filename);
        FileInputStream is = new FileInputStream(f);
        return this.runTask(network, is, f.getName(), context);
    }

    public CIResponse<?> importString(String matrix, String name, Map<String, Object> context) throws NullPointerException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(matrix.getBytes());
        return this.runTask(null, bais, name, context);
    }

    @Override
    public Response aMatReaderPredict(String path) {
        try {
            FileInputStream is = new FileInputStream(path);
            ResettableBufferedReader reader = new ResettableBufferedReader(is);
            MatrixParser.MatrixParameters predicted_params = MatrixParser.predictParameters(reader);
            CIResponse resp = new CIResponse();
            AMatReaderParameters params = new AMatReaderParameters();
            params.columnNames = predicted_params.hasColumnNames;
            params.rowNames = predicted_params.hasRowNames;
            params.delimiter = predicted_params.delimiter;
            params.files = new String[]{path};
            params.ignoreZeros = predicted_params.ignoreZeros;
            params.undirected = predicted_params.undirected;
            resp.data = params;
            return Response.status((Response.Status)Response.Status.OK).type("application/json").entity((Object)params).build();
        }
        catch (Exception e) {
            return this.buildErrorResponse(Response.Status.BAD_REQUEST, "500", e);
        }
    }
}

