/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.property.internal.bookmark;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.bookmark.Bookmarks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BookmarkReader
implements CyProperty<Bookmarks> {
    private static final String BOOKMARK_PACKAGE = Bookmarks.class.getPackage().getName();
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private String name;
    private Bookmarks bookmarks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookmarkReader(String name, String resourceLocation) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (resourceLocation == null) {
            throw new NullPointerException("resourceLocation is null");
        }
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(resourceLocation);
            if (is == null) {
                throw new IllegalArgumentException("Failed to open resource: " + resourceLocation);
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((String)BOOKMARK_PACKAGE, (ClassLoader)this.getClass().getClassLoader());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            this.bookmarks = (Bookmarks)unmarshaller.unmarshal(is);
        }
        catch (Exception e) {
            logger.warn("Could not read bookmark file - using empty bookmarks.", (Throwable)e);
            this.bookmarks = new Bookmarks();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                is = null;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Bookmarks getProperties() {
        return this.bookmarks;
    }

    public CyProperty.SavePolicy getSavePolicy() {
        return CyProperty.SavePolicy.SESSION_FILE;
    }

    public Class<? extends Bookmarks> getPropertyType() {
        return Bookmarks.class;
    }
}

