/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal.tasks;

import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowserManager;
import edu.ucsf.rbvi.cyBrowser.internal.tasks.AbstractEmptyObservableTask;
import edu.ucsf.rbvi.cyBrowser.internal.view.ResultsPanelBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.view.SwingBrowser;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class HideBrowserTask
extends AbstractEmptyObservableTask {
    @Tunable(description="Window ID", longDescription="The ID for the browser window to hide", exampleStringValue="Window 1", context="nogui")
    public String id = null;
    final CyBrowserManager manager;

    public HideBrowserTask(CyBrowserManager manager) {
        this.manager = manager;
    }

    @Override
    public void run(TaskMonitor monitor) {
        CyBrowser browser = this.manager.getBrowser(this.id);
        if (browser instanceof ResultsPanelBrowser) {
            this.manager.unregisterCytoPanel((ResultsPanelBrowser)browser);
        } else if (browser instanceof SwingBrowser) {
            ((SwingBrowser)browser).setVisible(false);
        }
    }

    @ProvidesTitle
    public String getTitle() {
        return "Hiding Cytoscape Web Browser";
    }
}

