/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.cyBrowser.internal.model;

import edu.ucsf.rbvi.cyBrowser.internal.model.CyBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.view.ResultsPanelBrowser;
import edu.ucsf.rbvi.cyBrowser.internal.view.SwingBrowser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.service.util.CyServiceRegistrar;

public class CyBrowserManager {
    CyServiceRegistrar registrar;
    CytoPanel cytoPanel = null;
    Map<String, CyBrowser> idMap;
    String version = "unknown";
    public static int browserCount = 1;

    public CyBrowserManager(CyServiceRegistrar registrar) {
        this.registrar = registrar;
        CySwingApplication swingApplication = (CySwingApplication)registrar.getService(CySwingApplication.class);
        this.cytoPanel = swingApplication.getCytoPanel(CytoPanelName.EAST);
        this.idMap = new HashMap<String, CyBrowser>();
    }

    public CyServiceRegistrar getRegistrar() {
        return this.registrar;
    }

    public void registerCytoPanel(final ResultsPanelBrowser browser) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CyBrowserManager.this.registrar.registerService((Object)browser, CytoPanelComponent.class, new Properties());
                CyBrowserManager.this.cytoPanel.setState(CytoPanelState.DOCK);
                int index = CyBrowserManager.this.cytoPanel.indexOfComponent(browser.getComponent());
                CyBrowserManager.this.cytoPanel.setSelectedIndex(index);
            }
        });
    }

    public void unregisterCytoPanel(final ResultsPanelBrowser browser) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (browser == null) {
                    for (CyBrowser br : CyBrowserManager.this.idMap.values()) {
                        if (!(br instanceof ResultsPanelBrowser)) continue;
                        CyBrowserManager.this.registrar.unregisterService((Object)((ResultsPanelBrowser)br), CytoPanelComponent.class);
                    }
                }
                CyBrowserManager.this.registrar.unregisterService((Object)browser, CytoPanelComponent.class);
                CyBrowserManager.this.cytoPanel.setState(CytoPanelState.DOCK);
            }
        });
    }

    public CyBrowser getBrowser(String id) {
        if (id == null) {
            id = "";
        }
        if (this.idMap.containsKey(id)) {
            return this.idMap.get(id);
        }
        return null;
    }

    public String makeId() {
        String id = "CyBrowser " + browserCount;
        ++browserCount;
        return id;
    }

    public void addBrowser(CyBrowser browser, String id) {
        if (id == null) {
            id = "CyBrowser " + browserCount;
            ++browserCount;
        }
        this.idMap.put((String)id, browser);
    }

    public void removeBrowser(String id) {
        if (id == null) {
            id = "";
        }
        this.idMap.remove(id);
    }

    public void removeBrowser(CyBrowser browser) {
        ArrayList<String> ids = new ArrayList<String>(this.idMap.keySet());
        for (String id : ids) {
            if (!this.idMap.get(id).equals(browser)) continue;
            this.removeBrowser(id);
        }
    }

    public void closeBrowser(String id) {
        final CyBrowser browser = this.getBrowser(id);
        if (browser == null) {
            System.out.println("Unable to get browser for id: '" + id + "'");
            return;
        }
        browser.loadURL(null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (browser instanceof ResultsPanelBrowser) {
                    CyBrowserManager.this.unregisterCytoPanel((ResultsPanelBrowser)browser);
                } else if (browser instanceof SwingBrowser) {
                    ((SwingBrowser)browser).dispose();
                }
            }
        });
        this.removeBrowser(id);
    }

    public Map<String, CyBrowser> getBrowserMap() {
        return this.idMap;
    }

    public void setVersion(String v) {
        this.version = v;
    }

    public String getVersion() {
        return this.version;
    }
}

