/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.command.internal.tunables;

import java.util.Map;
import javax.swing.JFrame;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.command.StringTunableHandler;
import org.cytoscape.command.StringTunableHandlerFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.MessageDialogs;
import org.cytoscape.work.AbstractTunableInterceptor;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TunableValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandTunableInterceptorImpl
extends AbstractTunableInterceptor<StringTunableHandler> {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private String args = null;
    private Map<String, Object> mapArgs = null;
    private final CyServiceRegistrar registrar;

    public CommandTunableInterceptorImpl(CyServiceRegistrar registrar) {
        this.registrar = registrar;
    }

    public void setConfigurationContext(String args) {
        this.args = args;
        if (args == null) {
            this.titleProviderMap.clear();
            this.handlerMap.clear();
        }
    }

    public void setConfigurationContext(Map<String, Object> args) {
        this.mapArgs = args;
        if (args == null) {
            this.titleProviderMap.clear();
            this.handlerMap.clear();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validateAndWriteBackTunables(Object o) {
        try {
            for (StringTunableHandler h : this.getHandlers(o)) {
                if (this.args != null) {
                    h.processArgString(this.args);
                    continue;
                }
                for (String string : this.mapArgs.keySet()) {
                    if (!h.getName().equals(string) && !h.getName().equals(this.upperFirstChar(string))) continue;
                    Object v = this.mapArgs.get(string);
                    try {
                        if (v instanceof String) {
                            v = h.processArg((String)v);
                        }
                        h.setValue(v);
                    }
                    catch (Exception e) {
                        logger.warn("Couldn't parse value from: " + v + " for setting: " + h.getName(), (Throwable)e);
                        throw new IllegalArgumentException("Couldn't parse value from: " + v + " for setting: " + h.getName());
                    }
                }
                continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.warn("Exception processing tunables", (Throwable)e);
            throw new RuntimeException("Error processing arguments: " + e.getMessage());
        }
    }

    public boolean validateTunableInput(Object objectWithTunables, TaskMonitor tm) {
        if (!(objectWithTunables instanceof TunableValidator)) {
            return true;
        }
        StringBuilder errMsg = new StringBuilder();
        try {
            JFrame parent;
            boolean yesClicked;
            TunableValidator.ValidationState validationState = ((TunableValidator)objectWithTunables).getValidationState((Appendable)errMsg);
            if (validationState == TunableValidator.ValidationState.INVALID) {
                tm.showMessage(TaskMonitor.Level.ERROR, "[ERROR] " + ((Object)errMsg).toString());
                return false;
            }
            if (validationState == TunableValidator.ValidationState.REQUEST_CONFIRMATION && !(yesClicked = MessageDialogs.showYesNoDialog((JFrame)(parent = ((CySwingApplication)this.registrar.getService(CySwingApplication.class)).getJFrame()), (String)"Confirmation", (String)((Object)errMsg).toString()))) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void addTunableHandlerFactory(StringTunableHandlerFactory<StringTunableHandler> f, Map<String, String> p) {
        super.addTunableHandlerFactory(f, p);
    }

    public void removeTunableHandlerFactory(StringTunableHandlerFactory<StringTunableHandler> f, Map<String, String> p) {
        super.removeTunableHandlerFactory(f, p);
    }

    private String upperFirstChar(String string) {
        return Character.toUpperCase(string.charAt(0)) + (string.length() > 1 ? string.substring(1) : "");
    }
}

