/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.nicecy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.TableViewRenderer;
import org.cytoscape.io.internal.CyServiceModule;
import org.cytoscape.io.internal.cxio.CxUtil;
import org.cytoscape.io.internal.cxio.TimingUtil;
import org.cytoscape.io.internal.nicecy.Identifiable;
import org.cytoscape.io.internal.nicecy.NiceCyNetwork;
import org.cytoscape.io.internal.nicecy.NiceCyView;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.model.table.CyTableViewFactory;
import org.cytoscape.view.model.table.CyTableViewManager;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.vizmap.TableVisualMappingManager;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.ndexbio.cx2.aspect.element.core.TableColumnVisualStyle;
import org.ndexbio.cx2.aspect.element.core.VPMappingType;
import org.ndexbio.cx2.aspect.element.core.VisualPropertyMapping;
import org.ndexbio.cx2.aspect.element.cytoscape.DefaultTableType;
import org.ndexbio.cxio.aspects.datamodels.CartesianLayoutElement;
import org.ndexbio.cxio.aspects.datamodels.CyGroupsElement;
import org.ndexbio.cxio.aspects.datamodels.CyTableColumnElement;
import org.ndexbio.cxio.aspects.datamodels.CyTableVisualPropertiesElement;
import org.ndexbio.cxio.aspects.datamodels.CyVisualPropertiesElement;
import org.ndexbio.cxio.aspects.datamodels.EdgeAttributesElement;
import org.ndexbio.cxio.aspects.datamodels.EdgesElement;
import org.ndexbio.cxio.aspects.datamodels.HiddenAttributesElement;
import org.ndexbio.cxio.aspects.datamodels.NetworkAttributesElement;
import org.ndexbio.cxio.aspects.datamodels.NetworkRelationsElement;
import org.ndexbio.cxio.aspects.datamodels.NodeAttributesElement;
import org.ndexbio.cxio.aspects.datamodels.NodesElement;
import org.ndexbio.cxio.aspects.datamodels.SubNetworkElement;
import org.ndexbio.cxio.core.interfaces.AspectElement;
import org.ndexbio.cxio.misc.OpaqueElement;
import org.ndexbio.model.cx.NiceCXNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiceCyRootNetwork
extends NiceCyNetwork {
    private static Logger logger = LoggerFactory.getLogger(NiceCyRootNetwork.class);
    public static String[] UNSERIALIZED_OPAQUE_ASPECTS = new String[]{"cyNetworkRelations", "metaData", "cyViews", "provenanceHistory", "ndexStatus", "numberVerification", "CX Element ID", "cyTableColumn", "cyGroups", "cyHiddenAttributes", "cySubNetworks", "@context", "cyVisualProperties", "visualProperties", "tableVisualProperties"};
    private Map<Long, Long> suid_to_cxid_map;
    protected final Map<String, Collection<AspectElement>> opaqueAspects;
    private final Map<Long, NiceCyNetwork.NiceCySubNetwork> subnetworks = new HashMap<Long, NiceCyNetwork.NiceCySubNetwork>();
    protected final boolean isCollection;
    protected final Map<Long, Identifiable.NiceCyNode> root_nodes = new HashMap<Long, Identifiable.NiceCyNode>();
    protected final Map<Long, Identifiable.NiceCyEdge> root_edges = new HashMap<Long, Identifiable.NiceCyEdge>();
    protected final Map<Long, Identifiable.NiceCyGroup> root_groups = new HashMap<Long, Identifiable.NiceCyGroup>();
    private Map<Long, Map<DefaultTableType, Map<String, Map<String, TableColumnVisualStyle>>>> tableVisualStyles = new HashMap<Long, Map<DefaultTableType, Map<String, Map<String, TableColumnVisualStyle>>>>();

    public NiceCyRootNetwork(NiceCXNetwork niceCX) {
        super(CxUtil.DEFAULT_SUBNET);
        this.opaqueAspects = niceCX.getOpaqueAspectTable();
        this.isCollection = this.opaqueAspects.containsKey("cySubNetworks");
        logger.info("Converting NiceCX to NiceCY: ");
        long t0 = System.currentTimeMillis();
        try {
            this.handleCxMapping(this.opaqueAspects.get("CX Element ID"));
            this.handleNetworkRelations(this.opaqueAspects.get("cyNetworkRelations"));
            this.handleNetworkAttributes(niceCX.getNetworkAttributes());
            this.handleNodes(niceCX.getNodes());
            this.handleEdges(niceCX.getEdges());
            this.handleNodeAttributes(niceCX.getNodeAttributes());
            this.handleEdgeAttributes(niceCX.getEdgeAttributes());
            this.handleNodeAssociatedAspects(niceCX.getNodeAssociatedAspects());
            this.handleEdgeAssociatedAspects(niceCX.getEdgeAssociatedAspects());
            this.handleOpaqueAspects();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to process JSON in CX: " + e.getMessage());
        }
        TimingUtil.reportTimeDifference(t0, "Convert to NiceCY", -1);
    }

    private void handleOpaqueAspects() throws JsonProcessingException {
        this.handleCyTableColumns(this.opaqueAspects.get("cyTableColumn"));
        this.handleGroups(this.opaqueAspects.get("cyGroups"));
        this.handleHiddenAttributes(this.opaqueAspects.get("cyHiddenAttributes"));
        this.handleSubNetworks(this.opaqueAspects.get("cySubNetworks"));
        this.handleNamespaces(this.opaqueAspects.get("@context"));
        Collection<AspectElement> visualProps = this.opaqueAspects.get("cyVisualProperties");
        if (visualProps == null) {
            visualProps = this.opaqueAspects.get("visualProperties");
        }
        this.handleCyVisualProperties(visualProps);
        this.handleCyTableVisualProperties(this.opaqueAspects.get("tableVisualProperties"));
    }

    private void handleNamespaces(Collection<AspectElement> aspects) throws JsonProcessingException {
        if (aspects == null) {
            return;
        }
        String contextStr = NiceCyRootNetwork.serializeNamespaces(aspects);
        NiceCyNetwork net = this.getNetwork(null);
        boolean hasContextAttribute = net.attributes.stream().anyMatch(nae -> nae.getName().equals("@context"));
        if (!hasContextAttribute) {
            NetworkAttributesElement value = new NetworkAttributesElement(Long.valueOf(this.getId()), "@context", contextStr);
            net.attributes.add(value);
        }
    }

    public static String serializeNamespaces(Collection<AspectElement> collection) throws JsonProcessingException {
        JsonObject obj = new JsonObject();
        for (AspectElement el : collection) {
            OpaqueElement op = (OpaqueElement)el;
            JsonNode node = op.getData();
            node.fields().forEachRemaining(entry -> {
                JsonNode val_node = (JsonNode)entry.getValue();
                JsonPrimitive val = new JsonPrimitive(val_node.asText());
                obj.add((String)entry.getKey(), (JsonElement)val);
            });
        }
        Gson gson = new Gson();
        return gson.toJson((JsonElement)obj);
    }

    private void handleSubNetworks(Collection<AspectElement> aspects) {
        if (aspects == null) {
            return;
        }
        aspects.forEach(aspect -> {
            SubNetworkElement sne = (SubNetworkElement)aspect;
            NiceCyNetwork.NiceCySubNetwork network = this.subnetworks.get(sne.getId());
            sne.getNodes().forEach(nodeId -> {
                long id = this.getCxId((long)nodeId);
                if (this.root_groups.containsKey(id)) {
                    network.groups.add(id);
                }
                network.nodes.add(id);
            });
            sne.getEdges().forEach(edgeId -> {
                long id = this.getCxId((long)edgeId);
                network.edges.add(id);
            });
        });
    }

    private void handleHiddenAttributes(Collection<AspectElement> aspects) {
        if (aspects == null) {
            return;
        }
        aspects.forEach(aspect -> {
            HiddenAttributesElement hae = (HiddenAttributesElement)aspect;
            NiceCyNetwork net = this.getNetwork(hae.getSubnetwork());
            net.hiddenAttributes.add(hae);
        });
    }

    private void handleCyVisualProperties(Collection<AspectElement> visualProps) {
        if (visualProps == null) {
            return;
        }
        visualProps.forEach(aspect -> {
            CyVisualPropertiesElement cvpe = (CyVisualPropertiesElement)aspect;
            NiceCyView view = this.getViewWithId(cvpe.getView());
            switch (cvpe.getProperties_of()) {
                case "network": 
                case "nodes:default": 
                case "edges:default": {
                    view.addVisualProperties(cvpe);
                    break;
                }
                case "nodes": {
                    Long node_id = this.getCxId(cvpe.getApplies_to());
                    view.addNodeBypass(node_id, cvpe);
                    break;
                }
                case "edges": {
                    Long edge_id = this.getCxId(cvpe.getApplies_to());
                    view.addEdgeBypass(edge_id, cvpe);
                }
            }
        });
    }

    private void handleCyTableVisualProperties(Collection<AspectElement> tableStyles) {
        if (tableStyles != null && !tableStyles.isEmpty()) {
            for (AspectElement e : tableStyles) {
                CyTableVisualPropertiesElement tableStyle = (CyTableVisualPropertiesElement)e;
                this.tableVisualStyles.put(tableStyle.getSubnetId(), tableStyle.getTableStyles());
            }
        }
    }

    private void handleNodeAssociatedAspects(Map<String, Map<Long, Collection<AspectElement>>> nodeAssociatedAspects) {
        nodeAssociatedAspects.forEach((name, map) -> {
            switch (name) {
                case "cartesianLayout": {
                    this.handleCartesianLayout((Map<Long, Collection<AspectElement>>)map);
                    break;
                }
                default: {
                    logger.info("Not handling node associcated " + name);
                }
            }
        });
    }

    private void handleCartesianLayout(Map<Long, Collection<AspectElement>> map) {
        map.forEach((suid, aspects) -> {
            long id = this.getCxId((long)suid);
            aspects.forEach(aspect -> {
                CartesianLayoutElement cl = (CartesianLayoutElement)aspect;
                Long viewId = cl.getView();
                NiceCyView view = this.getViewWithId(viewId);
                view.addCartesianLayout(id, cl);
            });
        });
    }

    private void handleEdgeAssociatedAspects(Map<String, Map<Long, Collection<AspectElement>>> edgeAssociatedAspects) {
        edgeAssociatedAspects.forEach((name, map) -> logger.info("Not handling edge associcated " + name));
    }

    private void handleNodeAttributes(Map<Long, Collection<NodeAttributesElement>> nodeAttributes) {
        nodeAttributes.forEach((suid, attrs) -> {
            long id = this.getCxId((long)suid);
            attrs.forEach(attr -> {
                try {
                    attr.setPropertyOf(Long.valueOf(id));
                    NiceCyNetwork net = this.getNetwork(attr.getSubnetwork());
                    if (net == null) {
                        throw new RuntimeException("No network found for SUID " + attr.getSubnetwork() + ". Check your CX attribute " + attr);
                    }
                    if (!net.nodeAttributes.containsKey(id)) {
                        net.nodeAttributes.put(id, new ArrayList());
                    }
                    net.nodeAttributes.get(id).add((NodeAttributesElement)attr);
                }
                catch (NullPointerException e) {
                    throw new RuntimeException("Error processing attribute: " + attr);
                }
            });
        });
    }

    private void handleEdgeAttributes(Map<Long, Collection<EdgeAttributesElement>> edgeAttributes) {
        edgeAttributes.forEach((suid, attrs) -> {
            long id = this.getCxId((long)suid);
            attrs.forEach(attr -> {
                NiceCyNetwork net = this.getNetwork(attr.getSubnetwork());
                if (!net.edgeAttributes.containsKey(id)) {
                    net.edgeAttributes.put(id, new ArrayList());
                }
                net.edgeAttributes.get(id).add((EdgeAttributesElement)attr);
            });
        });
    }

    private void handleGroups(Collection<AspectElement> aspects) {
        if (aspects == null) {
            return;
        }
        aspects.forEach(aspect -> {
            CyGroupsElement cge = (CyGroupsElement)aspect;
            long id = this.getCxId(cge.getGroupId());
            List<Long> nodes = cge.getNodes().stream().map(suid -> this.getCxId((long)suid)).collect(Collectors.toList());
            List<Long> internal_edges = cge.getInternalEdges().stream().map(suid -> this.getCxId((long)suid)).collect(Collectors.toList());
            List<Long> external_edges = cge.getExternalEdges().stream().map(suid -> this.getCxId((long)suid)).collect(Collectors.toList());
            boolean collapsed = cge.isCollapsed();
            Identifiable.NiceCyGroup group = new Identifiable.NiceCyGroup(id, this, nodes, internal_edges, external_edges, collapsed, cge.getName());
            this.root_groups.put(id, group);
        });
    }

    private void handleCxMapping(Collection<AspectElement> cxMapping) {
        if (cxMapping == null) {
            return;
        }
        Long t0 = System.currentTimeMillis();
        this.suid_to_cxid_map = new HashMap<Long, Long>();
        cxMapping.forEach(aspect -> {
            OpaqueElement oe = (OpaqueElement)aspect;
            JsonNode node = oe.getData();
            node.fields().forEachRemaining(entry -> {
                String suid_str = (String)entry.getKey();
                Long suid = Long.valueOf(suid_str);
                Long cxid = ((JsonNode)entry.getValue()).asLong();
                this.suid_to_cxid_map.put(suid, cxid);
            });
        });
        TimingUtil.reportTimeDifference(t0, "CX Mapping", -1);
    }

    private void handleNodes(Map<Long, NodesElement> nodes) {
        Long t0 = System.currentTimeMillis();
        nodes.forEach((suid, node) -> {
            Long id = this.getCxId((long)suid);
            this.root_nodes.put(id, new Identifiable.NiceCyNode(id, node.getNodeName(), node.getNodeRepresents()));
        });
        TimingUtil.reportTimeDifference(t0, "nodes", -1);
    }

    private void handleEdges(Map<Long, EdgesElement> edges) {
        if (edges == null) {
            return;
        }
        Long t0 = System.currentTimeMillis();
        edges.forEach((suid, edge) -> {
            Long id = this.getCxId((long)suid);
            Long source = this.getCxId(edge.getSource());
            Long target = this.getCxId(edge.getTarget());
            this.root_edges.put(id, new Identifiable.NiceCyEdge(id, this, source, target, edge.getInteraction()));
        });
        TimingUtil.reportTimeDifference(t0, "edges", -1);
    }

    private void handleCyTableColumns(Collection<AspectElement> aspects) {
        if (aspects == null) {
            return;
        }
        Long t0 = System.currentTimeMillis();
        aspects.forEach(aspect -> {
            CyTableColumnElement ctce = (CyTableColumnElement)aspect;
            NiceCyNetwork net = this.getNetwork(ctce.getSubnetwork());
            net.tableColumns.add(ctce);
        });
        TimingUtil.reportTimeDifference(t0, "cyTableColumn", -1);
    }

    private void handleNetworkAttributes(Collection<NetworkAttributesElement> networkAttributes) {
        if (networkAttributes == null) {
            return;
        }
        Long t0 = System.currentTimeMillis();
        networkAttributes.forEach(attr -> this.getNetwork((Long)attr.getSubnetwork()).attributes.add((NetworkAttributesElement)attr));
        TimingUtil.reportTimeDifference(t0, "networkAttributes", -1);
    }

    private void handleNetworkRelations(Collection<AspectElement> aspects) {
        if (aspects != null) {
            Long t0 = System.currentTimeMillis();
            aspects.stream().filter(aspect -> ((NetworkRelationsElement)aspect).getRelationship().equals("subnetwork")).forEach(aspect -> {
                NetworkRelationsElement nre = (NetworkRelationsElement)aspect;
                Long suid = nre.getChild();
                NiceCyNetwork.NiceCySubNetwork network = new NiceCyNetwork.NiceCySubNetwork(suid, this);
                NetworkAttributesElement nae = new NetworkAttributesElement(suid, "name", nre.getChildName());
                network.attributes.add(nae);
                if (!this.isCollection || this.getNetworkName() == null) {
                    this.attributes.add(nae);
                }
                this.subnetworks.put(suid, network);
            });
            aspects.stream().filter(aspect -> ((NetworkRelationsElement)aspect).getRelationship().equals("view")).forEach(aspect -> {
                NetworkRelationsElement nre = (NetworkRelationsElement)aspect;
                Long suid = nre.getChild();
                Long net = nre.getParent();
                NiceCyNetwork.NiceCySubNetwork subnet = (NiceCyNetwork.NiceCySubNetwork)this.getNetwork(net);
                NiceCyView view = new NiceCyView(suid, subnet, nre.getChildName());
                subnet.views.put(suid, view);
            });
            TimingUtil.reportTimeDifference(t0, "cySubNetworks", -1);
        }
        if (this.subnetworks.isEmpty()) {
            NiceCyNetwork.NiceCySubNetwork subnet = new NiceCyNetwork.NiceCySubNetwork(CxUtil.DEFAULT_SUBNET, this);
            subnet.views.put(CxUtil.DEFAULT_VIEW, new NiceCyView(CxUtil.DEFAULT_VIEW, subnet, null));
            this.subnetworks.put(CxUtil.DEFAULT_SUBNET, subnet);
        }
    }

    private NiceCyNetwork getNetwork(Long suid) {
        if (suid == null) {
            if (!this.isCollection) {
                return this.subnetworks.values().iterator().next();
            }
            return this;
        }
        return this.subnetworks.get(suid);
    }

    private long getCxId(long suid) {
        if (this.suid_to_cxid_map == null) {
            return suid;
        }
        if (!this.suid_to_cxid_map.containsKey(suid)) {
            throw new IllegalArgumentException("Unable to find suid " + suid + " in CX ID Mapping.");
        }
        return this.suid_to_cxid_map.get(suid);
    }

    private NiceCyView getViewWithId(Long view) {
        if (view == null) {
            if (!this.isCollection) {
                return this.subnetworks.get((Object)CxUtil.DEFAULT_SUBNET).views.get(CxUtil.DEFAULT_VIEW);
            }
            ArrayList<NiceCyView> views = new ArrayList<NiceCyView>();
            for (NiceCyNetwork.NiceCySubNetwork subnet : this.subnetworks.values()) {
                views.addAll(subnet.views.values());
            }
            if (views.size() == 1) {
                return (NiceCyView)views.get(0);
            }
        } else {
            for (NiceCyNetwork.NiceCySubNetwork subnet : this.subnetworks.values()) {
                if (!subnet.views.containsKey(view)) continue;
                return subnet.views.get(view);
            }
        }
        throw new RuntimeException("No view found with ID " + view);
    }

    public List<CyNetwork> apply() {
        if (this.subnetworks.isEmpty()) {
            throw new RuntimeException("No networks were detected in the CX");
        }
        long t0 = System.currentTimeMillis();
        ArrayList<CyNetwork> networks = new ArrayList<CyNetwork>();
        CyNetworkFactory network_factory = CyServiceModule.getService(CyNetworkFactory.class);
        CyNetwork base = network_factory.createNetwork();
        CyRootNetwork root = ((CySubNetwork)base).getRootNetwork();
        networks.add(base);
        this.network = root;
        this.addRootNetworkColumns();
        Iterator<NiceCyNetwork.NiceCySubNetwork> nice_subs = this.subnetworks.values().iterator();
        NiceCyNetwork.NiceCySubNetwork nice_sub = nice_subs.next();
        nice_sub.apply((CyNetwork)root.getBaseNetwork());
        while (nice_subs.hasNext()) {
            nice_sub = nice_subs.next();
            CySubNetwork currentNetwork = root.addSubNetwork();
            nice_sub.apply((CyNetwork)currentNetwork);
            networks.add((CyNetwork)currentNetwork);
        }
        this.addTableColumns();
        this.addAttributes();
        this.serializeOpaqueAspects();
        TimingUtil.reportTimeDifference(t0, "time to build cynetwork(s)", -1);
        return networks;
    }

    public void addTableVisualStyles(CyNetwork currentNetwork) throws Exception {
        Map<DefaultTableType, Map<String, Map<String, TableColumnVisualStyle>>> currentNetTableStyles;
        if (this.tableVisualStyles.isEmpty()) {
            return;
        }
        if (this.isCollection) {
            Long subNetId = this.getSubNetId(currentNetwork);
            currentNetTableStyles = this.tableVisualStyles.get(subNetId);
        } else {
            currentNetTableStyles = this.tableVisualStyles.get(null);
        }
        Map<String, Map<String, TableColumnVisualStyle>> tableStyles = currentNetTableStyles.get(DefaultTableType.Network);
        if (tableStyles != null) {
            NiceCyRootNetwork.addStyleToTable(currentNetwork.getDefaultNetworkTable(), tableStyles);
        }
        if ((tableStyles = currentNetTableStyles.get(DefaultTableType.Node)) != null) {
            NiceCyRootNetwork.addStyleToTable(currentNetwork.getDefaultNodeTable(), tableStyles);
        }
        if ((tableStyles = currentNetTableStyles.get(DefaultTableType.Edge)) != null) {
            NiceCyRootNetwork.addStyleToTable(currentNetwork.getDefaultEdgeTable(), tableStyles);
        }
    }

    private Long getSubNetId(CyNetwork currentNetwork) {
        for (Map.Entry<Long, NiceCyNetwork.NiceCySubNetwork> entry : this.subnetworks.entrySet()) {
            NiceCyNetwork subnet = entry.getValue();
            if (subnet.network == null) {
                throw new RuntimeException("No CySubNetwork created for " + subnet);
            }
            if (!subnet.network.equals(currentNetwork)) continue;
            return entry.getKey();
        }
        throw new RuntimeException("No CySubNetwork found for " + currentNetwork);
    }

    private static <K, T> void addStyleToTable(CyTable table, Map<String, Map<String, TableColumnVisualStyle>> nodeTableStyles) throws Exception {
        CyApplicationManager appManager = CyServiceModule.getService(CyApplicationManager.class);
        CyTableViewManager tableViewManager = CyServiceModule.getService(CyTableViewManager.class);
        CyTableViewFactory tableViewFactory = CyServiceModule.getService(CyTableViewFactory.class);
        TableVisualMappingManager tableVisualMappingManager = CyServiceModule.getService(TableVisualMappingManager.class);
        VisualStyleFactory visualStyleFactory = CyServiceModule.getService(VisualStyleFactory.class);
        VisualMappingFunctionFactory vmfFactoryC = CyServiceModule.getContinuousMapping();
        VisualMappingFunctionFactory vmfFactoryD = CyServiceModule.getDiscreteMapping();
        VisualMappingFunctionFactory vmfFactoryP = CyServiceModule.getPassthroughMapping();
        if (table != null) {
            CyTableView tableView = tableViewManager.getTableView(table);
            if (tableView == null) {
                tableView = tableViewFactory.createTableView(table);
                tableViewManager.setTableView(tableView);
            }
            TableViewRenderer renderer = appManager.getTableViewRenderer(tableView.getRendererId());
            RenderingEngineFactory factory = renderer.getRenderingEngineFactory("");
            VisualLexicon lexicon = factory.getVisualLexicon();
            for (Map.Entry<String, Map<String, TableColumnVisualStyle>> e : nodeTableStyles.entrySet()) {
                String colName = e.getKey();
                View colView = tableView.getColumnView(colName);
                VisualStyle columnStyle = tableVisualMappingManager.getVisualStyle(colView);
                if (columnStyle == null) {
                    columnStyle = visualStyleFactory.createVisualStyle(UUID.randomUUID().toString());
                    tableVisualMappingManager.setVisualStyle(colView, columnStyle);
                }
                Map<String, TableColumnVisualStyle> colStyles = e.getValue();
                for (Map.Entry<String, TableColumnVisualStyle> e2 : colStyles.entrySet()) {
                    String vpName = e2.getKey();
                    TableColumnVisualStyle style = e2.getValue();
                    VisualProperty vp = lexicon.lookup(CyColumn.class, vpName);
                    Object v = style.getDefaultValue();
                    VisualPropertyMapping mapping = style.getMapping();
                    if (vp == null) continue;
                    if (v != null) {
                        Object finalV = CxUtil.cvtCX2ObjToVisualPropertyValue(v, vp);
                        columnStyle.setDefaultValue(vp, finalV);
                    }
                    if (mapping == null) continue;
                    Class attrDataType = table.getColumn(mapping.getMappingDef().getAttributeName()).getType();
                    if (mapping.getType() == VPMappingType.PASSTHROUGH) {
                        PassthroughMapping pmf = (PassthroughMapping)vmfFactoryP.createVisualMappingFunction(mapping.getMappingDef().getAttributeName(), attrDataType, vp);
                        columnStyle.addVisualMappingFunction((VisualMappingFunction)pmf);
                        continue;
                    }
                    if (mapping.getType() == VPMappingType.DISCRETE) {
                        DiscreteMapping dmf = (DiscreteMapping)vmfFactoryD.createVisualMappingFunction(mapping.getMappingDef().getAttributeName(), attrDataType, vp);
                        for (Map dMappingEntry : mapping.getMappingDef().getMapppingList()) {
                            Object vpValue = CxUtil.cvtCX2ObjToVisualPropertyValue(dMappingEntry.get("vp"), vp);
                            dmf.putMapValue(dMappingEntry.get("v"), vpValue);
                        }
                        columnStyle.addVisualMappingFunction((VisualMappingFunction)dmf);
                        continue;
                    }
                    if (mapping.getType() != VPMappingType.CONTINUOUS) continue;
                    ContinuousMapping cmf = (ContinuousMapping)vmfFactoryC.createVisualMappingFunction(mapping.getMappingDef().getAttributeName(), attrDataType, vp);
                    int counter = 0;
                    boolean cyCounter = false;
                    Object L = null;
                    Object E = null;
                    Object G = null;
                    Object ov = null;
                    for (Map m : mapping.getMappingDef().getMapppingList()) {
                        Object minV = m.get("min");
                        Object maxV = m.get("max");
                        Boolean includeMin = (Boolean)m.get("includeMin");
                        Boolean includeMax = (Boolean)m.get("includeMax");
                        Object minVP = m.get("minVPValue");
                        Object maxVP = m.get("maxVPValue");
                        if (minVP == null && maxVP == null) {
                            throw new Exception("minVPValue and maxVPValue are both missing in CONTINUOUS mapping of " + vpName + " on column " + colName);
                        }
                        if (counter == 0) {
                            L = CxUtil.cvtCX2ObjToVisualPropertyValue(maxVP, vp);
                            ov = maxV;
                            if (includeMax.booleanValue()) {
                                E = L;
                            }
                        } else {
                            G = CxUtil.cvtCX2ObjToVisualPropertyValue(minVP, vp);
                            if (includeMin.booleanValue()) {
                                E = G;
                            }
                            BoundaryRangeValues point = new BoundaryRangeValues(L, E, G);
                            cmf.addPoint(ov, point);
                            if (maxV != null) {
                                ov = maxV;
                                L = CxUtil.cvtCX2ObjToVisualPropertyValue(maxVP, vp);
                                E = includeMax != false ? L : null;
                            }
                        }
                        ++counter;
                    }
                    columnStyle.addVisualMappingFunction((VisualMappingFunction)cmf);
                }
            }
        }
    }

    protected void addRootNetworkColumns() {
        this.tableColumns.stream().filter(x -> "network_table".equals(x.getAppliesTo())).forEach(column -> {
            String name;
            CyTable table = this.network.getTable(CyNetwork.class, "USER");
            if (table.getColumn(name = column.getName()) == null) {
                CxUtil.createColumn(table, name, CxUtil.getDataType(column.getDataType()), column.isSingleValue());
            }
        });
    }

    @Override
    protected void addTableColumns() {
        this.tableColumns.stream().filter(x -> !"network_table".equals(x.getAppliesTo())).forEach(column -> {
            CyTable table;
            String name = column.getName();
            boolean isLocal = column.getSubnetwork() != null;
            switch (column.getAppliesTo()) {
                case "node_table": {
                    table = isLocal ? this.network.getTable(CyNode.class, "LOCAL_ATTRS") : this.network.getTable(CyNode.class, "USER");
                    break;
                }
                case "edge_table": {
                    table = isLocal ? this.network.getTable(CyEdge.class, "LOCAL_ATTRS") : this.network.getTable(CyEdge.class, "USER");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized CyTableColumn applies_to: " + column.getAppliesTo());
                }
            }
            if (table.getColumn(name) == null) {
                CxUtil.createColumn(table, name, CxUtil.getDataType(column.getDataType()), column.isSingleValue());
            }
        });
    }

    private void serializeOpaqueAspects() {
        Long t0 = System.currentTimeMillis();
        NiceCyNetwork subnet = this.getNetwork(null);
        this.opaqueAspects.forEach((name, opaque) -> {
            if (ArrayUtils.contains((Object[])UNSERIALIZED_OPAQUE_ASPECTS, (Object)name)) {
                return;
            }
            try {
                subnet.serializeAspect("CX_OPAQUE::" + name, (Collection<AspectElement>)opaque);
            }
            catch (IOException e) {
                logger.warn("Failed to serialize opaque aspect: " + name);
            }
        });
        TimingUtil.reportTimeDifference(t0, "Opaque Elements", -1);
    }

    @Override
    protected String getNamespace() {
        return "SHARED_ATTRS";
    }

    public List<CyNetworkView> createViews(CyNetwork network, Boolean explicitCreateViews) {
        ArrayList<CyNetworkView> views = new ArrayList<CyNetworkView>();
        this.subnetworks.forEach((suid, subnet) -> {
            if (subnet.network == null) {
                throw new RuntimeException("No CySubNetwork created for " + subnet);
            }
            if (subnet.network.equals(network)) {
                views.addAll(subnet.createViews(explicitCreateViews));
            }
        });
        return views;
    }

    public Collection<Identifiable.NiceCyEdge> getRootEdges() {
        return this.root_edges.values();
    }

    public Collection<Identifiable.NiceCyNode> getRootNodes() {
        return this.root_nodes.values();
    }

    public Collection<Identifiable.NiceCyGroup> getRootGroups() {
        return this.root_groups.values();
    }

    public CyNode getNode(Long suid) {
        return this.root_nodes.get(suid).getNode();
    }

    public CyEdge getEdge(Long suid) {
        return this.root_edges.get(suid).getEdge();
    }

    public CyRootNetwork getCollection() {
        return (CyRootNetwork)this.network;
    }

    public Collection<NiceCyNetwork.NiceCySubNetwork> getSubnetworks() {
        return this.subnetworks.values();
    }

    @Override
    public String getNetworkName() {
        if (!this.isCollection && !this.subnetworks.isEmpty()) {
            return this.subnetworks.values().iterator().next().getNetworkName();
        }
        return super.getNetworkName();
    }

    public void updateNetworkAndViewIds(NiceCyRootNetwork other) {
        String name;
        this.id = other.getId();
        HashMap<String, NiceCyNetwork.NiceCySubNetwork> netNameMap = new HashMap<String, NiceCyNetwork.NiceCySubNetwork>();
        for (NiceCyNetwork.NiceCySubNetwork net : other.subnetworks.values()) {
            name = net.getNetworkName();
            if (netNameMap.containsKey(name)) {
                throw new RuntimeException("Cannot align networks with duplicate names");
            }
            netNameMap.put(name, net);
        }
        for (NiceCyNetwork.NiceCySubNetwork net : this.subnetworks.values()) {
            name = net.getNetworkName();
            if (!netNameMap.containsKey(name)) {
                throw new RuntimeException("Network named " + name + " not in other");
            }
            this.subnetworks.remove(net.getId());
            NiceCyNetwork.NiceCySubNetwork otherNet = (NiceCyNetwork.NiceCySubNetwork)netNameMap.get(name);
            net.updateViewIds(otherNet);
            this.subnetworks.put(net.getId(), net);
            netNameMap.remove(name);
        }
    }

    public void setNetworkName(String _network_collection_name) {
        this.attributes.add(new NetworkAttributesElement(null, "name", _network_collection_name));
        this.attributes.add(new NetworkAttributesElement(null, "shared name", _network_collection_name));
    }
}

