/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.nicecy;

import java.util.List;
import java.util.stream.Collectors;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.io.internal.CyServiceModule;
import org.cytoscape.io.internal.cxio.CxUtil;
import org.cytoscape.io.internal.nicecy.NiceCyRootNetwork;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.subnetwork.CySubNetwork;

public abstract class Identifiable {
    protected long id;

    public Identifiable(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public class NiceCyEdge
    extends Identifiable {
        private final Long source;
        private final Long target;
        private final NiceCyRootNetwork root;
        private final String interaction;
        private CyEdge edge;

        public NiceCyEdge(long id, NiceCyRootNetwork root, Long source, Long target, String interaction) {
            super(id);
            this.root = root;
            this.source = source;
            this.target = target;
            this.interaction = interaction;
        }

        public CyEdge addTo(CySubNetwork subnet) {
            CyNode sourceNode = this.root.getNode(this.source);
            CyNode targetNode = this.root.getNode(this.target);
            if (this.edge == null) {
                this.edge = subnet.addEdge(sourceNode, targetNode, true);
                CxUtil.saveCxId((CyIdentifiable)this.edge, (CyNetwork)subnet, this.id);
            } else {
                subnet.addEdge(this.edge);
            }
            if (this.interaction != null) {
                subnet.getRow((CyIdentifiable)this.edge).set("interaction", (Object)this.interaction);
                subnet.getRow((CyIdentifiable)this.edge).set("shared interaction", (Object)this.interaction);
                String sourceName = (String)subnet.getDefaultNodeTable().getRow((Object)sourceNode.getSUID()).get("name", String.class);
                String targetName = (String)subnet.getDefaultNodeTable().getRow((Object)targetNode.getSUID()).get("name", String.class);
                String name = String.format("%s (%s) %s", sourceName, this.interaction, targetName);
                subnet.getRow((CyIdentifiable)this.edge).set("name", (Object)name);
                subnet.getRow((CyIdentifiable)this.edge).set("shared name", (Object)name);
            }
            return this.edge;
        }

        public CyEdge getEdge() {
            if (this.edge == null) {
                throw new RuntimeException("Edge " + this.id + " was never created.");
            }
            return this.edge;
        }
    }

    public class NiceCyNode
    extends Identifiable {
        private final String name;
        private final String represents;
        private CyNode node;

        public NiceCyNode(long id, String name, String represents) {
            super(id);
            this.name = name;
            this.represents = represents;
        }

        public CyNode addTo(CySubNetwork subnet) {
            if (this.node == null) {
                this.node = subnet.addNode();
                CxUtil.saveCxId((CyIdentifiable)this.node, (CyNetwork)subnet, this.id);
            } else {
                subnet.addNode(this.node);
            }
            CyRow row = subnet.getDefaultNodeTable().getRow((Object)this.node.getSUID());
            if (this.name != null) {
                row.set("name", (Object)this.name);
                row.set("shared name", (Object)this.name);
            }
            if (this.represents != null) {
                CxUtil.createColumn(subnet.getDefaultNodeTable(), "represents", String.class, true);
                row.set("represents", (Object)this.represents);
            }
            return this.node;
        }

        public String getName() {
            return this.name;
        }

        public CyNode getNode() {
            if (this.node == null) {
                throw new RuntimeException("Node " + this.id + " was never created.");
            }
            return this.node;
        }
    }

    public class NiceCyGroup
    extends Identifiable {
        private final NiceCyRootNetwork root;
        private CyGroup group;
        private final List<Long> nodes;
        private final List<Long> internal_edges;
        private final List<Long> external_edges;
        private final boolean collapsed;
        private final String name;

        public NiceCyGroup(long id, NiceCyRootNetwork root, List<Long> nodes, List<Long> internal_edges, List<Long> external_edges, boolean collapsed, String name) {
            super(id);
            this.root = root;
            this.nodes = nodes;
            this.internal_edges = internal_edges;
            this.external_edges = external_edges;
            this.collapsed = collapsed;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<Long> getNodes() {
            return this.nodes;
        }

        public List<Long> getInternalEdges() {
            return this.internal_edges;
        }

        public List<Long> getExternalEdges() {
            return this.external_edges;
        }

        public boolean getIsCollapsed() {
            return this.collapsed;
        }

        public void addTo(CySubNetwork network) {
            CyGroupFactory group_factory = CyServiceModule.getService(CyGroupFactory.class);
            if (this.group == null) {
                CyNode node = this.root.getNode(this.id);
                List internal_nodes = this.nodes.stream().map(suid -> this.root.getNode((Long)suid)).collect(Collectors.toList());
                List int_edges = this.internal_edges.stream().map(suid -> this.root.getEdge((Long)suid)).collect(Collectors.toList());
                List ext_edges = this.external_edges.stream().map(suid -> this.root.getEdge((Long)suid)).collect(Collectors.toList());
                int_edges.addAll(ext_edges);
                this.group = group_factory.createGroup((CyNetwork)network, node, internal_nodes, int_edges, true);
            } else {
                this.group.addGroupToNetwork((CyNetwork)network);
            }
            CyRow row = network.getRow((CyIdentifiable)this.group.getGroupNode());
            row.set("name", (Object)this.name);
            row.set("shared name", (Object)this.name);
        }

        public CyGroup getGroup() {
            if (this.group == null) {
                throw new RuntimeException("Group " + this.id + " was never initialized");
            }
            return this.group;
        }

        public boolean isCollapsed() {
            return this.collapsed;
        }

        public void updateInView(CySubNetwork network) {
            this.group.collapse((CyNetwork)network);
            this.group.expand((CyNetwork)network);
            if (this.isCollapsed()) {
                this.group.collapse((CyNetwork)network);
            }
        }
    }
}

