/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.cxio;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Font;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.io.internal.CyServiceModule;
import org.cytoscape.io.internal.cxio.Settings;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.property.BooleanVisualProperty;
import org.cytoscape.view.presentation.property.DoubleVisualProperty;
import org.cytoscape.view.presentation.property.IntegerVisualProperty;
import org.cytoscape.view.presentation.property.StringVisualProperty;
import org.ndexbio.cx2.aspect.element.core.FontFace;
import org.ndexbio.cx2.converter.FontFaceConverter;
import org.ndexbio.cxio.aspects.datamodels.ATTRIBUTE_DATA_TYPE;
import org.ndexbio.cxio.aspects.datamodels.AbstractAttributesAspectElement;
import org.ndexbio.cxio.metadata.MetaDataCollection;
import org.ndexbio.cxio.metadata.MetaDataElement;
import org.ndexbio.model.cx.NiceCXNetwork;

public final class CxUtil {
    private static Logger logger = Logger.getLogger((String)"CxUtil");
    public static final String REPRESENTS = "represents";
    public static final String CONTINUOUS_MAPPING = "CONTINUOUS_MAPPING_";
    public static final String DISCRETE_MAPPING = "DISCRETE_MAPPING_";
    public static final String PASSTHROUGH_MAPPING = "PASSTHROUGH_MAPPING_";
    public static final String VM_COL = "COL";
    public static final String VM_TYPE = "T";
    public static final String DISCRETE = "DISCRETE";
    public static final String CONTINUOUS = "CONTINUOUS";
    public static final String PASSTHROUGH = "PASSTHROUGH";
    public static final String NODE_SIZE_LOCKED = "nodeSizeLocked";
    public static final String NODE_CUSTOM_GRAPHICS_SIZE_SYNC = "nodeCustomGraphicsSizeSync";
    public static final String ARROW_COLOR_MATCHES_EDGE = "arrowColorMatchesEdge";
    public static final String NAME = "name";
    public static final String SHARED_NAME = "shared name";
    public static final String INTERACTION = "interaction";
    public static final String SHARED_INTERACTION = "shared interaction";
    public static final String SELECTED = "selected";
    public static final String CX_ID_MAPPING = "CX Element ID";
    public static final String CX_METADATA = "CX MetaData";
    public static final String OPAQUE_ASPECT_PREFIX = "CX_OPAQUE::";
    public static final Long DEFAULT_SUBNET = Long.MIN_VALUE;
    public static final Long DEFAULT_VIEW = Long.MIN_VALUE;
    private static String CXID_NAMESPACE = "HIDDEN";

    public static MetaDataCollection getMetaData(CyNetwork network) {
        String metaDataStr;
        CyTable hidden_network_table = network.getTable(CyNetwork.class, "HIDDEN");
        CyRow row = hidden_network_table.getRow((Object)network.getSUID());
        if (row != null && (metaDataStr = (String)row.get(CX_METADATA, String.class)) != null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                return (MetaDataCollection)mapper.readValue(metaDataStr, MetaDataCollection.class);
            }
            catch (IOException e) {
                logger.info((Object)("Get Metadata threw an IOException: " + e));
            }
        }
        return new MetaDataCollection();
    }

    public static void setMetaData(CyNetwork network, MetaDataCollection metaData) {
        CyTable hidden_table = network.getTable(CyNetwork.class, "HIDDEN");
        if (hidden_table.getColumn(CX_METADATA) == null) {
            hidden_table.createColumn(CX_METADATA, String.class, true);
        }
        CyRow row = hidden_table.getRow((Object)network.getSUID());
        ObjectMapper mapper = new ObjectMapper();
        try {
            String metaDataStr = mapper.writeValueAsString((Object)metaData);
            row.set(CX_METADATA, (Object)metaDataStr);
        }
        catch (JsonProcessingException e) {
            logger.error((Object)("Failed to update metaData. This should not happen. " + e));
        }
    }

    public static boolean isCollection(NiceCXNetwork niceCX) {
        return niceCX.getOpaqueAspectTable().containsKey("cyNetworkRelations");
    }

    private static CyTable getCxTable(CyIdentifiable ele, CyRootNetwork root) {
        CyTable table = ele instanceof CyNode ? root.getTable(CyNode.class, CXID_NAMESPACE) : root.getTable(CyEdge.class, CXID_NAMESPACE);
        if (table.getColumn(CX_ID_MAPPING) == null) {
            table.createColumn(CX_ID_MAPPING, Long.class, false);
        }
        return table;
    }

    private static final Long getMaxId(Class<? extends CyIdentifiable> type, CyRootNetwork network) {
        CyTable table = network.getTable(type, CXID_NAMESPACE);
        CyColumn column = table.getColumn(CX_ID_MAPPING);
        if (column == null) {
            return null;
        }
        List values = column.getValues(Long.class);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (Long)Collections.max(values, (a, b) -> {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return Long.compare(a, b);
        });
    }

    private static void updateCxIdCounter(Class<? extends CyIdentifiable> type, CyRootNetwork root, Long counter) {
        for (CySubNetwork network : root.getSubNetworkList()) {
            String aspect;
            MetaDataCollection metadata = CxUtil.getMetaData((CyNetwork)network);
            String string = aspect = type.equals(CyNode.class) ? "nodes" : "edges";
            if (metadata == null) {
                metadata = new MetaDataCollection();
                MetaDataElement mde = new MetaDataElement(aspect, "1.0");
                metadata.add(mde);
            }
            metadata.setIdCounter(aspect, counter);
            CxUtil.setMetaData((CyNetwork)network, metadata);
        }
    }

    private static final void populateCxIdColumn(Class<? extends CyIdentifiable> type, CyRootNetwork root) {
        Long counter = CxUtil.getMaxId(type, root);
        CyTable table = root.getTable(type, CXID_NAMESPACE);
        boolean had_ids = counter != null;
        List eles = type.equals(CyNode.class) ? root.getNodeList() : root.getEdgeList();
        for (CyIdentifiable ele : eles) {
            CyRow row = table.getRow((Object)ele.getSUID());
            if (row.get(CX_ID_MAPPING, Long.class) != null) continue;
            if (had_ids) {
                counter = counter + 1L;
                row.set(CX_ID_MAPPING, (Object)counter);
                continue;
            }
            row.set(CX_ID_MAPPING, (Object)ele.getSUID());
            counter = counter == null ? ele.getSUID() : Math.max(counter, ele.getSUID());
        }
        CxUtil.updateCxIdCounter(type, root, counter);
    }

    private static CyRootNetwork getRoot(CyNetwork network) {
        if (network instanceof CySubNetwork) {
            return ((CySubNetwork)network).getRootNetwork();
        }
        return (CyRootNetwork)network;
    }

    public static final void saveCxId(CyIdentifiable ele, CyNetwork network, Long id) {
        CyRootNetwork root = CxUtil.getRoot(network);
        CyTable table = CxUtil.getCxTable(ele, root);
        CyRow row = table.getRow((Object)ele.getSUID());
        row.set(CX_ID_MAPPING, (Object)id);
    }

    public static Long getCxId(CyIdentifiable cyEle, CyRootNetwork root) {
        CyTable table = CxUtil.getCxTable(cyEle, root);
        CyRow row = table.getRow((Object)cyEle.getSUID());
        return (Long)row.get(CX_ID_MAPPING, Long.class);
    }

    public static Long getElementId(CyIdentifiable cy_ele, CyNetwork network, boolean useCxId) {
        CyRootNetwork root = CxUtil.getRoot(network);
        if (!useCxId) {
            return cy_ele.getSUID();
        }
        Long cx_id = CxUtil.getCxId(cy_ele, root);
        if (cx_id != null) {
            return cx_id;
        }
        if (cy_ele instanceof CyNode) {
            CxUtil.populateCxIdColumn(CyNode.class, root);
        } else if (cy_ele instanceof CyEdge) {
            CxUtil.populateCxIdColumn(CyEdge.class, root);
        }
        return CxUtil.getCxId(cy_ele, root);
    }

    public static final ATTRIBUTE_DATA_TYPE toAttributeType(Class<?> attr_class) {
        if (attr_class == String.class) {
            return ATTRIBUTE_DATA_TYPE.STRING;
        }
        if (attr_class == Double.class) {
            return ATTRIBUTE_DATA_TYPE.DOUBLE;
        }
        if (attr_class == Integer.class) {
            return ATTRIBUTE_DATA_TYPE.INTEGER;
        }
        if (attr_class == Long.class) {
            return ATTRIBUTE_DATA_TYPE.LONG;
        }
        if (attr_class == Boolean.class) {
            return ATTRIBUTE_DATA_TYPE.BOOLEAN;
        }
        throw new IllegalArgumentException("Don't know how to deal with type '" + attr_class + "'");
    }

    public static final ATTRIBUTE_DATA_TYPE toListAttributeType(Class<?> attr_class) {
        if (attr_class == String.class) {
            return ATTRIBUTE_DATA_TYPE.LIST_OF_STRING;
        }
        if (attr_class == Double.class) {
            return ATTRIBUTE_DATA_TYPE.LIST_OF_DOUBLE;
        }
        if (attr_class == Integer.class) {
            return ATTRIBUTE_DATA_TYPE.LIST_OF_INTEGER;
        }
        if (attr_class == Long.class) {
            return ATTRIBUTE_DATA_TYPE.LIST_OF_LONG;
        }
        if (attr_class == Boolean.class) {
            return ATTRIBUTE_DATA_TYPE.LIST_OF_BOOLEAN;
        }
        throw new IllegalArgumentException("Don't know how to deal with type '" + attr_class + "'");
    }

    public static String getNetworkName(CyNetwork net) {
        String str;
        CyRow row = net.getRow((CyIdentifiable)net, "USER");
        if (row == null) {
            throw new NullPointerException("Unable to find network name in network table");
        }
        String name = null;
        Map values = row.getAllValues();
        if (values != null && !values.isEmpty() && values.get(NAME) != null && (str = String.valueOf(values.get(NAME))) != null && str.trim().length() > 0) {
            name = str;
        }
        return name;
    }

    public static VisualLexicon getLexicon(CyNetworkView view) {
        CyApplicationManager _application_manager = CyServiceModule.getService(CyApplicationManager.class);
        NetworkViewRenderer renderer = _application_manager.getNetworkViewRenderer(view.getRendererId());
        RenderingEngineFactory factory = renderer == null ? null : renderer.getRenderingEngineFactory("");
        VisualLexicon lexicon = factory == null ? null : factory.getVisualLexicon();
        return lexicon;
    }

    public static boolean hasCxIds(CyNetwork network) {
        CyRootNetwork root = CxUtil.getRoot(network);
        CyTable table = root.getTable(CyNode.class, CXID_NAMESPACE);
        return table.getColumn(CX_ID_MAPPING) != null;
    }

    public static Class<?> getDataType(ATTRIBUTE_DATA_TYPE type) {
        switch (type) {
            case STRING: 
            case LIST_OF_STRING: {
                return String.class;
            }
            case BOOLEAN: 
            case LIST_OF_BOOLEAN: {
                return Boolean.class;
            }
            case DOUBLE: 
            case LIST_OF_DOUBLE: {
                return Double.class;
            }
            case INTEGER: 
            case LIST_OF_INTEGER: {
                return Integer.class;
            }
            case LONG: 
            case LIST_OF_LONG: {
                return Long.class;
            }
        }
        throw new IllegalArgumentException("don't know how to deal with type '" + type + "'");
    }

    public static CyColumn createColumn(CyTable table, String name, Class<?> data_type, boolean is_single) {
        if (table == null) {
            return null;
        }
        if (table.getColumn(name) == null) {
            if (is_single) {
                table.createColumn(name, data_type, false);
            } else {
                table.createListColumn(name, data_type, false);
            }
        }
        return table.getColumn(name);
    }

    public static final void addToColumn(CyTable table, CyRow row, AbstractAttributesAspectElement e) {
        if (e == null) {
            return;
        }
        String name = e.getName();
        if (name == null) {
            return;
        }
        if (!(Settings.INSTANCE.isIgnoreSuidColumn() && name.equals("SUID") || Settings.INSTANCE.isIgnoreSelectedColumn() && name.equals(SELECTED))) {
            Class<?> data_type = CxUtil.getDataType(e.getDataType());
            CyColumn col = CxUtil.createColumn(table, name, data_type, e.isSingleValue());
            if (col == null) {
                logger.warn((Object)("Failed to create column " + name + " in table " + table));
                return;
            }
            if (col.getListElementType() != null && e.isSingleValue()) {
                logger.warn((Object)("Invalid entry.  Not a list: " + e.toString()));
                return;
            }
            Object val = CxUtil.getValue(e);
            try {
                row.set(name, val);
            }
            catch (Exception ex) {
                logger.warn((Object)("Invalid element found: " + e), (Throwable)ex);
            }
        }
    }

    public static final Object getValue(AbstractAttributesAspectElement e) {
        Class<?> type = CxUtil.getDataType(e.getDataType());
        if (e.isSingleValue()) {
            Object val = null;
            try {
                val = CxUtil.parseValue(e.getValue(), type);
            }
            catch (Exception ex) {
                logger.warn((Object)("Could not process element: " + e), (Throwable)ex);
                ex.printStackTrace();
                val = null;
            }
            return val;
        }
        List values = e.getValues().stream().map(value -> CxUtil.parseValue(value, type)).collect(Collectors.toList());
        return values;
    }

    public static final Object parseValue(String value, Class<?> type) {
        if (type == String.class || type == null) {
            return value;
        }
        if (value == null || value.equals("") || value.equalsIgnoreCase("null") || value.equals("NaN") || value.equals("nan")) {
            value = null;
        }
        if (type == Double.class) {
            if (value == null) {
                return Double.NaN;
            }
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("could not convert '" + value + "' to double");
            }
        }
        if (type == Boolean.class) {
            try {
                return Boolean.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("could not convert '" + value + "' to boolean");
            }
        }
        if (value == null) {
            return null;
        }
        if (type == Long.class) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("could not convert '" + value + "' to long");
            }
        }
        if (type == Integer.class) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("could not convert '" + value + "' to integer");
            }
        }
        throw new IllegalArgumentException("don't know how to deal with type '" + type + "' for value '" + value + "'");
    }

    public static <T> Object cvtVisualPropertyValueAsCX2Obj(T value, VisualProperty<T> vp) {
        if (value == null) {
            return null;
        }
        if (value instanceof String || value instanceof Integer || value instanceof Double || value instanceof Boolean) {
            return value;
        }
        if (value instanceof Font) {
            return FontFaceConverter.convertFont((String)((Font)value).getName());
        }
        return vp.toSerializableString(value);
    }

    public static <T> T cvtCX2ObjToVisualPropertyValue(Object value, VisualProperty<T> vp) {
        if (value == null) {
            return null;
        }
        if (vp instanceof StringVisualProperty || vp instanceof IntegerVisualProperty || vp instanceof DoubleVisualProperty || vp instanceof BooleanVisualProperty) {
            return (T)value;
        }
        if (vp.getDefault() instanceof Font) {
            FontFace ff = value instanceof Map ? FontFace.createFromMap((Map)((Map)value)) : (FontFace)value;
            return (T)new Font(ff.getName(), 0, 11);
        }
        return (T)vp.parseSerializableString((String)value);
    }
}

