/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.cx_writer;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.cytoscape.io.internal.CyServiceModule;
import org.cytoscape.io.internal.cxio.CxUtil;
import org.cytoscape.io.internal.cxio.VisualPropertyType;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.ndexbio.cxio.aspects.datamodels.CyVisualPropertiesElement;
import org.ndexbio.cxio.core.interfaces.AspectElement;
import org.ndexbio.cxio.util.CxioUtil;

public final class VisualPropertiesGatherer {
    private static final Logger logger = Logger.getLogger((String)"VisualPropertiesGatherer");
    private static final boolean ALLOW_NODE_CUSTOM_PROPERTIES = true;
    public static final char COMMA = ',';

    public static final List<AspectElement> gatherVisualPropertiesAsAspectElements(CyNetworkView view, VisualLexicon lexicon, Set<VisualPropertyType> types, Long viewId, boolean use_cxId) throws JsonProcessingException {
        ArrayList<AspectElement> elements = new ArrayList<AspectElement>();
        VisualMappingManager vmm = CyServiceModule.getService(VisualMappingManager.class);
        VisualStyle current_visual_style = vmm.getVisualStyle(view);
        if (lexicon == null) {
            throw new IllegalArgumentException("VisualLexicon is not initialized. This should not happen");
        }
        Set all_visual_properties = lexicon.getAllVisualProperties();
        if (current_visual_style == null) {
            throw new IllegalArgumentException("Failed to get Visual Style from view " + view);
        }
        if (types.contains((Object)VisualPropertyType.NETWORK)) {
            VisualPropertiesGatherer.gatherNetworkVisualProperties(view, elements, current_visual_style, all_visual_properties, viewId);
        }
        if (types.contains((Object)VisualPropertyType.NODES_DEFAULT)) {
            VisualPropertiesGatherer.gatherNodesDefaultVisualProperties(view, elements, current_visual_style, all_visual_properties, viewId);
        }
        if (types.contains((Object)VisualPropertyType.EDGES_DEFAULT)) {
            VisualPropertiesGatherer.gatherEdgesDefaultVisualProperties(view, elements, current_visual_style, all_visual_properties, viewId);
        }
        if (types.contains((Object)VisualPropertyType.NODES)) {
            VisualPropertiesGatherer.gatherNodeVisualProperties(view, elements, all_visual_properties, viewId, use_cxId);
        }
        if (types.contains((Object)VisualPropertyType.EDGES)) {
            VisualPropertiesGatherer.gatherEdgeVisualProperties(view, elements, all_visual_properties, viewId, use_cxId);
        }
        return elements;
    }

    private static final <T> void addProperties(View<? extends CyIdentifiable> view, VisualProperty<T> vp, CyVisualPropertiesElement cvp) {
        if (!view.isSet(vp) || !view.isValueLocked(vp)) {
            return;
        }
        try {
            String value_str = VisualPropertiesGatherer.getSerializableVisualProperty(view, vp);
            if (CxioUtil.isEmpty((String)value_str)) {
                return;
            }
            String id_string = vp.getIdString();
            if (id_string.equals("NODE") || id_string.equals("EDGE") || id_string.equals("NETWORK")) {
                logger.info((Object)("Need to add handler for Property: " + id_string + " " + value_str));
            } else {
                cvp.putProperty(id_string, value_str);
            }
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Writing %s(%s) = %s caused Error:\n%s", vp.getDisplayName(), vp.getTargetDataType(), view.getVisualProperty(vp), e.getMessage());
            throw new IllegalArgumentException(message);
        }
    }

    private static <T> String getSerializableVisualProperty(View<? extends CyIdentifiable> view, VisualProperty<T> vp) {
        Object prop = view.getVisualProperty(vp);
        if (prop == null) {
            return null;
        }
        String val = null;
        try {
            val = vp.toSerializableString(prop);
        }
        catch (ClassCastException e) {
            val = String.valueOf(prop);
            String message = String.format("Class cast exception for %s: %s(%s) = %s. Error: %s\n", vp.getClass(), vp.getDisplayName(), vp.getTargetDataType(), view.getVisualProperty(vp), e.getMessage());
            logger.info((Object)message);
        }
        return val;
    }

    private static final <T> void addPropertiesNetwork(View<? extends CyIdentifiable> view, VisualStyle style, VisualProperty<T> vp, CyVisualPropertiesElement cvp) {
        String value_str = VisualPropertiesGatherer.getSerializableVisualProperty(view, vp);
        if (CxioUtil.isEmpty((String)value_str)) {
            return;
        }
        String id_string = vp.getIdString();
        if (view.isSet(vp) && view.isValueLocked(vp)) {
            if (id_string.equals("NODE") || id_string.equals("EDGE") || id_string.equals("NETWORK")) {
                throw new RuntimeException("Failed to add property " + vp);
            }
            cvp.putProperty(id_string, value_str);
        } else if (!(id_string.equals("NODE") || id_string.equals("EDGE") || id_string.equals("NETWORK") || id_string.startsWith("NODE_CUSTOM"))) {
            cvp.putProperty(id_string, value_str);
        }
    }

    private static final <T> void addDefaultProperties(VisualStyle style, VisualProperty<T> vp, CyVisualPropertiesElement cvp) {
        String id_string;
        String value_str;
        Object vp_value = style.getDefaultValue(vp);
        if (!(vp_value == null || CxioUtil.isEmpty((String)(value_str = vp.toSerializableString(vp_value))) || (id_string = vp.getIdString()).equals("NODE") || id_string.equals("EDGE") || id_string.equals("NETWORK"))) {
            if (id_string.startsWith("NODE_CUSTOM")) {
                cvp.putProperty(id_string, value_str);
            } else {
                cvp.putProperty(id_string, value_str);
            }
        }
    }

    private static String escapeString(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (curChar == ',') {
                result.append(',');
            }
            result.append(curChar);
        }
        return result.toString();
    }

    private static final <T> void addMappings(VisualStyle style, VisualProperty<T> vp, CyVisualPropertiesElement cvp, CyTable table) {
        VisualMappingFunction mapping = style.getVisualMappingFunction(vp);
        if (mapping == null) {
            return;
        }
        String col = mapping.getMappingColumnName();
        if (mapping instanceof PassthroughMapping) {
            PassthroughMapping pm = (PassthroughMapping)mapping;
            String type = null;
            try {
                type = VisualPropertiesGatherer.toAttributeType(pm.getMappingColumnType(), table, col);
            }
            catch (IOException e) {
                logger.info((Object)("WARNING: problem with mapping/column '" + col + "': column not present, ignoring corresponding passthrough mapping. " + e.getMessage()));
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("COL");
            sb.append("=");
            sb.append(VisualPropertiesGatherer.escapeString(col));
            sb.append(",");
            sb.append("T");
            sb.append("=");
            sb.append(VisualPropertiesGatherer.escapeString(type));
            cvp.putMapping(vp.getIdString(), "PASSTHROUGH", sb.toString());
        } else if (mapping instanceof DiscreteMapping) {
            DiscreteMapping dm = (DiscreteMapping)mapping;
            String type = null;
            try {
                type = VisualPropertiesGatherer.toAttributeType(dm.getMappingColumnType(), table, col);
            }
            catch (IOException e) {
                logger.info((Object)("WARNING: problem with mapping/column '" + col + "': column not present, ignoring corresponding discrete mapping. " + e.getMessage()));
                return;
            }
            Map map = dm.getAll();
            StringBuilder sb = new StringBuilder();
            sb.append("COL");
            sb.append("=");
            sb.append(VisualPropertiesGatherer.escapeString(col));
            sb.append(",");
            sb.append("T");
            sb.append("=");
            sb.append(VisualPropertiesGatherer.escapeString(type));
            int counter = 0;
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                try {
                    sb.append(",K=");
                    sb.append(counter);
                    sb.append("=");
                    sb.append(VisualPropertiesGatherer.escapeString(entry.getKey().toString()));
                    sb.append(",V=");
                    sb.append(counter);
                    sb.append("=");
                    sb.append(VisualPropertiesGatherer.escapeString(vp.toSerializableString(value)));
                }
                catch (Exception e) {
                    logger.info((Object)("could not add discrete mapping entry: " + value));
                    e.printStackTrace();
                    return;
                }
                ++counter;
            }
            cvp.putMapping(vp.getIdString(), "DISCRETE", sb.toString());
        } else if (mapping instanceof ContinuousMapping) {
            ContinuousMapping cm = (ContinuousMapping)mapping;
            String type = null;
            try {
                type = VisualPropertiesGatherer.toAttributeType(cm.getMappingColumnType(), table, col);
            }
            catch (IOException e) {
                logger.info((Object)("WARNING: problem with mapping/column '" + col + "': column not present, ignoring corresponding continuous mapping." + e.getMessage()));
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("COL");
            sb.append("=");
            sb.append(VisualPropertiesGatherer.escapeString(col));
            sb.append(",");
            sb.append("T");
            sb.append("=");
            sb.append(VisualPropertiesGatherer.escapeString(type));
            int counter = 0;
            for (ContinuousMappingPoint cp : cm.getAllPoints()) {
                Object lesser = cp.getRange().lesserValue;
                Object equal = cp.getRange().equalValue;
                Object greater = cp.getRange().greaterValue;
                sb.append(",L=");
                sb.append(counter);
                sb.append("=");
                sb.append(VisualPropertiesGatherer.escapeString(vp.toSerializableString(lesser)));
                sb.append(",E=");
                sb.append(counter);
                sb.append("=");
                sb.append(VisualPropertiesGatherer.escapeString(vp.toSerializableString(equal)));
                sb.append(",G=");
                sb.append(counter);
                sb.append("=");
                sb.append(VisualPropertiesGatherer.escapeString(vp.toSerializableString(greater)));
                sb.append(",OV=");
                sb.append(counter);
                sb.append("=");
                sb.append(VisualPropertiesGatherer.escapeString(cp.getValue().toString()));
                ++counter;
            }
            cvp.putMapping(vp.getIdString(), "CONTINUOUS", sb.toString());
        }
    }

    private static void gatherEdgesDefaultVisualProperties(CyNetworkView view, List<AspectElement> visual_properties, VisualStyle current_visual_style, Set<VisualProperty<?>> all_visual_properties, Long viewId) {
        CyVisualPropertiesElement e = new CyVisualPropertiesElement(VisualPropertyType.EDGES_DEFAULT.asString(), viewId, viewId);
        for (VisualProperty<?> visual_property : all_visual_properties) {
            if (visual_property.getTargetDataType() != CyEdge.class) continue;
            VisualPropertiesGatherer.addDefaultProperties(current_visual_style, visual_property, e);
            CyTable table = ((CyNetwork)view.getModel()).getTable(CyEdge.class, "USER");
            VisualPropertiesGatherer.addMappings(current_visual_style, visual_property, e, table);
        }
        VisualPropertiesGatherer.addDependency("arrowColorMatchesEdge", current_visual_style, e);
        visual_properties.add((AspectElement)e);
    }

    private static void gatherEdgeVisualProperties(CyNetworkView view, List<AspectElement> visual_properties, Set<VisualProperty<?>> all_visual_properties, Long viewId, boolean use_cxId) throws JsonProcessingException {
        for (View edge_view : view.getEdgeViews()) {
            CyEdge edge = (CyEdge)edge_view.getModel();
            CyVisualPropertiesElement e = new CyVisualPropertiesElement(VisualPropertyType.EDGES.asString(), CxUtil.getElementId((CyIdentifiable)edge, (CyNetwork)((CySubNetwork)view.getModel()), use_cxId), viewId);
            for (VisualProperty<?> visual_property : all_visual_properties) {
                if (visual_property.getTargetDataType() != CyEdge.class) continue;
                VisualPropertiesGatherer.addProperties((View<? extends CyIdentifiable>)edge_view, visual_property, e);
            }
            if (e.getProperties() == null || e.getProperties().isEmpty()) continue;
            visual_properties.add((AspectElement)e);
        }
    }

    private static void gatherNetworkVisualProperties(CyNetworkView view, List<AspectElement> visual_properties, VisualStyle current_visual_style, Set<VisualProperty<?>> all_visual_properties, Long viewId) {
        CyVisualPropertiesElement e = new CyVisualPropertiesElement(VisualPropertyType.NETWORK.asString(), viewId, viewId);
        for (VisualProperty<?> visual_property : all_visual_properties) {
            if (visual_property.getTargetDataType() != CyNetwork.class) continue;
            VisualPropertiesGatherer.addPropertiesNetwork((View<? extends CyIdentifiable>)view, current_visual_style, visual_property, e);
        }
        visual_properties.add((AspectElement)e);
    }

    private static void gatherNodesDefaultVisualProperties(CyNetworkView view, List<AspectElement> visual_properties, VisualStyle current_visual_style, Set<VisualProperty<?>> all_visual_properties, Long viewId) {
        CyVisualPropertiesElement e = new CyVisualPropertiesElement(VisualPropertyType.NODES_DEFAULT.asString(), viewId, viewId);
        for (VisualProperty<?> visual_property : all_visual_properties) {
            if (visual_property.getTargetDataType() != CyNode.class) continue;
            VisualPropertiesGatherer.addDefaultProperties(current_visual_style, visual_property, e);
            CyTable table = ((CyNetwork)view.getModel()).getTable(CyNode.class, "USER");
            VisualPropertiesGatherer.addMappings(current_visual_style, visual_property, e, table);
        }
        VisualPropertiesGatherer.addDependency("nodeCustomGraphicsSizeSync", current_visual_style, e);
        VisualPropertiesGatherer.addDependency("nodeSizeLocked", current_visual_style, e);
        visual_properties.add((AspectElement)e);
    }

    private static final void addDependency(String id_string, VisualStyle style, CyVisualPropertiesElement vpe) {
        for (VisualPropertyDependency d : style.getAllVisualPropertyDependencies()) {
            if (!d.getIdString().equals(id_string)) continue;
            vpe.putDependency(id_string, String.valueOf(d.isDependencyEnabled()));
            return;
        }
    }

    private static void gatherNodeVisualProperties(CyNetworkView view, List<AspectElement> visual_properties, Set<VisualProperty<?>> all_visual_properties, Long viewId, boolean use_cxId) throws JsonProcessingException {
        for (View node_view : view.getNodeViews()) {
            CyNode cy_node = (CyNode)node_view.getModel();
            CyVisualPropertiesElement e = new CyVisualPropertiesElement(VisualPropertyType.NODES.asString(), CxUtil.getElementId((CyIdentifiable)cy_node, (CyNetwork)((CySubNetwork)view.getModel()), use_cxId), viewId);
            for (VisualProperty<?> visual_property : all_visual_properties) {
                if (visual_property.getTargetDataType() != CyNode.class) continue;
                VisualPropertiesGatherer.addProperties((View<? extends CyIdentifiable>)node_view, visual_property, e);
            }
            if (e.getProperties() == null || e.getProperties().isEmpty()) continue;
            visual_properties.add((AspectElement)e);
        }
    }

    private static final String toAttributeType(Class<?> attr_class, CyTable table, String col_name) throws IOException {
        if (attr_class == String.class) {
            return "string";
        }
        if (attr_class == Float.class || attr_class == Double.class) {
            return "double";
        }
        if (attr_class == Integer.class || attr_class == Short.class) {
            return "integer";
        }
        if (attr_class == Long.class) {
            return "long";
        }
        if (attr_class == Boolean.class) {
            return "boolean";
        }
        if (Number.class.isAssignableFrom(attr_class)) {
            Class col_type = null;
            if (table != null && col_name != null) {
                CyColumn col = table.getColumn(col_name);
                if (col != null) {
                    col_type = table.getColumn(col_name).getType();
                } else {
                    throw new IOException("failed to obtain column '" + col_name + "'");
                }
            }
            if (col_type != null) {
                logger.info((Object)("mapping type is '" + attr_class + "' will use (from table column) '" + col_type + "' instead"));
                if (col_type == Float.class || col_type == Double.class) {
                    return "double";
                }
                if (col_type == Integer.class || col_type == Short.class) {
                    return "integer";
                }
                if (col_type == Long.class) {
                    return "long";
                }
                throw new IllegalArgumentException("don't know how to deal with type '" + col_type + "' (from table column " + col_name + ")");
            }
            throw new IllegalStateException("failed to obtain type for mapping from table");
        }
        throw new IllegalArgumentException("don't know how to deal with type '" + attr_class + "' for column " + col_name);
    }
}

