/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.cx_reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.io.BasicCyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CytoscapeCxFileFilter
extends BasicCyFileFilter {
    private static final String[] extensions = new String[]{"cx"};
    private static final String[] types = new String[]{"application/json"};
    private static final String description = "CX JSON";
    private static final DataCategory category = DataCategory.NETWORK;
    private static final Logger locallogger = LoggerFactory.getLogger(CytoscapeCxFileFilter.class);
    public static final Pattern CX_HEADER_PATTERN = Pattern.compile("\\s*\\{\\s*\"\\s*metaData\"\\s*:");
    public static final Pattern CX_HEADER_PATTERN_OLD = Pattern.compile("\\s*\\[\\s*\\{\\s*\"\\s*numberVerification\"\\s*:");

    public CytoscapeCxFileFilter(String[] extensions, String[] contentTypes, String description, DataCategory category, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, streamUtil);
    }

    public CytoscapeCxFileFilter(StreamUtil streamUtil) {
        this(extensions, types, description, category, streamUtil);
    }

    public boolean accepts(InputStream stream, DataCategory dataCategory) {
        if (!dataCategory.equals((Object)DataCategory.NETWORK)) {
            return false;
        }
        try {
            return this.getCXstartElement(stream) != null;
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("Error while checking header", (Throwable)e);
            return false;
        }
    }

    public boolean accepts(URI uri, DataCategory dataCategory) {
        boolean bl;
        block8: {
            InputStream is = uri.toURL().openStream();
            try {
                bl = this.accepts(is, dataCategory);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    locallogger.error("Error while opening stream: " + uri, (Throwable)e);
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    protected String getCXstartElement(InputStream stream) {
        Matcher matcher_old;
        String header = this.getHeaderCharacters(stream, 400);
        Matcher matcher = CX_HEADER_PATTERN.matcher(header);
        String root = null;
        if (matcher.find()) {
            root = matcher.group(0);
        }
        if (root == null && (matcher_old = CX_HEADER_PATTERN_OLD.matcher(header)).find()) {
            root = matcher_old.group(0);
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getHeaderCharacters(InputStream stream, int numCharacters) {
        String header;
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        try {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < numCharacters; ++i) {
                char[] c = new char[1];
                br.read(c);
                builder.append(c);
            }
            header = builder.toString();
        }
        catch (IOException ioe) {
            header = "";
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            br = null;
        }
        return header;
    }
}

