/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.opencl.layout;

import java.io.IOException;
import org.cytoscape.view.layout.EdgeWeighter;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;

public class CLLayoutContext
implements TunableValidator {
    @ContainsTunables
    public EdgeWeighter edgeWeighter = new EdgeWeighter();
    @Tunable(description="Iterations")
    public int numIterations = 100;
    @Tunable(description="Edge-Repulsive Iterations")
    public int numIterationsEdgeRepulsive = 0;
    @Tunable(description="Default Spring Coefficient")
    public double defaultSpringCoefficient = 1.0E-4;
    @Tunable(description="Default Spring Length")
    public double defaultSpringLength = 50.0;
    @Tunable(description="Default Node Mass")
    public double defaultNodeMass = 3.0;
    @Tunable(description="Force deterministic layouts (slower)")
    public boolean isDeterministic;
    @Tunable(description="Start from scratch")
    public boolean fromScratch = true;
    @Tunable(description="Don't partition graph before layout", groups={"Standard settings"})
    public boolean singlePartition;

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        try {
            if (!CLLayoutContext.isPositive(this.numIterations)) {
                errMsg.append("Number of iterations must be > 0; current value = " + this.numIterations);
            }
            if (!CLLayoutContext.isPositive(this.defaultSpringCoefficient)) {
                errMsg.append("Default spring coefficient must be > 0; current value = " + this.defaultSpringCoefficient);
            }
            if (!CLLayoutContext.isPositive(this.defaultSpringLength)) {
                errMsg.append("Default spring length must be > 0; current value = " + this.defaultSpringLength);
            }
            if (!CLLayoutContext.isPositive(this.defaultNodeMass)) {
                errMsg.append("Default node mass must be > 0; current value = " + this.defaultNodeMass);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return CLLayoutContext.isPositive(this.numIterations) && CLLayoutContext.isPositive(this.defaultSpringCoefficient) && CLLayoutContext.isPositive(this.defaultSpringLength) && CLLayoutContext.isPositive(this.defaultNodeMass) ? TunableValidator.ValidationState.OK : TunableValidator.ValidationState.INVALID;
    }

    private static boolean isPositive(int n) {
        return n > 0;
    }

    private static boolean isPositive(double n) {
        return n > 0.0;
    }
}

