/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.util;

import java.util.HashMap;
import java.util.Map;
import org.cytoscape.analyzer.util.ComplexParam;
import org.cytoscape.analyzer.util.JSONUtils;
import org.cytoscape.analyzer.util.Msgs;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;

public class NetworkStats {
    public static final String titleParam = "networkTitle";
    public static final String[] simpleParams = new String[]{"cc", "ncc", "diameter", "radius", "centralization", "connPairs", "avSpl", "avNeighbors", "nodeCount", "edgeCount", "density", "heterogeneity", "usn", "nsl", "mnp", "time"};
    public static final String[] complexParams = new String[]{"degreeDist", "inDegreeDist", "outDegreeDist", "cksDist", "topCoefs", "splDist", "commNeighbors", "neighborConn", "allNeighborConn", "inNeighborConn", "outNeighborConn", "nodeBetween", "closenessCent", "stressDist"};
    private Map<String, Object> params;
    private CyNetwork network;
    static String[] keys = new String[]{"networkTitle", "", "nodeCount", "edgeCount", "avNeighbors", "diameter", "radius", "avSpl", "", "cc", "density", "heterogeneity", "centralization", "", "ncc", "mnp", "nsl", "", "time"};
    boolean formatted = false;

    public Map<String, Object> getParameters() {
        return this.params;
    }

    public NetworkStats() {
        this.params = new HashMap<String, Object>();
        this.network = null;
    }

    public NetworkStats(String jsonMap) {
        this.params = JSONUtils.jsonToMap(jsonMap);
        this.network = null;
    }

    public NetworkStats(CyNetwork aNetwork, String aInterpretName) {
        this.params = new HashMap<String, Object>();
        this.set(titleParam, (String)aNetwork.getRow((CyIdentifiable)aNetwork).get("name", String.class) + aInterpretName);
        this.set("nodeCount", new Integer(aNetwork.getNodeCount()));
        this.set("edgeCount", new Integer(aNetwork.getEdgeCount()));
        this.network = aNetwork;
    }

    public void dump() {
    }

    String inQuotes(String s) {
        return "\"" + s + "\"";
    }

    public String jsonOutput() {
        return this.jsonOutput(this.params);
    }

    public String jsonOutput(Map<String, Object> parmMap) {
        StringBuilder out = new StringBuilder("{ \n");
        for (String key : keys) {
            if (key == null || key.trim().length() == 0) {
                out.append("\n");
                continue;
            }
            Object val = parmMap.get(key);
            if (val == null) continue;
            out.append("\t").append(this.inQuotes(key)).append(": ").append(this.inQuotes(val.toString())).append(",\n");
        }
        int len = out.length();
        out = out.delete(len - 2, len);
        out.append("\n}\n");
        return out.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.addString(builder, "Network: ", titleParam);
        this.addString(builder, "Number of nodes: ", "nodeCount");
        this.addString(builder, "Number of edges: ", "edgeCount");
        this.addInteger(builder, "Connected components: ", "ncc");
        this.addInteger(builder, "Diameter: ", "diameter");
        this.addDouble(builder, "Density: ", "density");
        this.addDouble(builder, "Heterogeneity: ", "heterogeneity");
        return builder.toString();
    }

    public String[] getKeys() {
        return keys;
    }

    void addString(StringBuilder builder, String label, String key) {
        String val = this.params.get(key).toString();
        builder.append(label);
        builder.append(val + "\n");
    }

    void addInteger(StringBuilder builder, String label, String key) {
        Integer val = (Integer)this.params.get(key);
        builder.append(label);
        builder.append(String.format("%3d\n", val));
    }

    void addDouble(StringBuilder builder, String label, String key) {
        Double val = (Double)this.params.get(key);
        builder.append(label);
        builder.append(String.format("%8.3f\n", val));
    }

    public String htmlOutput() {
        StringBuilder out = new StringBuilder();
        out.append("<html><body>");
        out.append("<p style=\"text-align: center\"><b>" + this.params.get(titleParam) + "</b></p>");
        out.append("<br/><br/>");
        out.append("<div height='100%'>");
        out.append("<table width='100%'>");
        for (String key : keys) {
            if (key == null || key.trim().length() == 0 || key.equals(titleParam)) continue;
            Object val = this.params.get(key);
            String s = Msgs.get(key);
            if (val instanceof String) {
                out.append(String.format("<tr><td><b>%s</b></td><td align='right'>%s</td></tr>", s, val));
                continue;
            }
            if (val instanceof Double) {
                out.append(String.format("<tr><td><b>%s</b></td><td align='right'>%8.3f</td></tr>", s, val));
                continue;
            }
            if (!(val instanceof Integer)) continue;
            out.append(String.format("<tr><td><b>%s</b></td><td align='right'>%3d</td></tr>", s, val));
        }
        out.append("</div></table></body></html>");
        return out.toString();
    }

    public String formattedOutput() {
        StringBuilder out = new StringBuilder();
        for (String key : keys) {
            if (key == null || key.trim().length() == 0) {
                out.append("\n");
                continue;
            }
            Object val = this.params.get(key);
            String s = Msgs.get(key);
            if (s != null) {
                key = s;
            }
            if (val instanceof String) {
                out.append(key).append("\t ").append(val).append('\n');
                continue;
            }
            if (val instanceof Double) {
                out.append(String.format("%s\t%8.3f\n", key, val));
                continue;
            }
            if (!(val instanceof Integer)) continue;
            out.append(String.format("%s\t%3d\n", key, val));
        }
        return out.toString();
    }

    public boolean contains(String aParam) {
        return this.params.containsKey(aParam);
    }

    public Object get(String aParam) {
        return this.params.get(aParam);
    }

    public ComplexParam getComplex(String aParam) {
        return (ComplexParam)this.params.get(aParam);
    }

    public String[] getComputedSimple() {
        return this.getComputed(simpleParams);
    }

    public String[] getComputedComplex() {
        return this.getComputed(complexParams);
    }

    public int getInt(String aParam) {
        return (Integer)this.params.get(aParam);
    }

    public long getLong(String aParam) {
        return (Long)this.params.get(aParam);
    }

    public String getTitle() {
        return (String)this.get(titleParam);
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public void set(String aParam, Object aValue) {
        this.params.put(aParam, aValue);
    }

    public void set(String aParam, int aValue) {
        this.set(aParam, new Integer(aValue));
    }

    public void set(String aParam, long aValue) {
        this.set(aParam, new Long(aValue));
    }

    public void set(String aParam, double aValue) {
        this.set(aParam, new Double(aValue));
    }

    public void setTitle(String aTitle) {
        this.set(titleParam, aTitle);
    }

    private String[] getComputed(String[] aIDs) {
        int size = 0;
        for (int i = 0; i < aIDs.length; ++i) {
            if (!this.params.containsKey(aIDs[i])) continue;
            ++size;
        }
        if (size == aIDs.length) {
            return aIDs;
        }
        String[] computed = new String[size];
        size = 0;
        for (int i = 0; i < aIDs.length; ++i) {
            if (!this.params.containsKey(aIDs[i])) continue;
            computed[size++] = aIDs[i];
        }
        return computed;
    }

    public void copyStats(NetworkStats other) {
        Map<String, Object> otherParams = other.getParameters();
        for (String key : simpleParams) {
            if (this.params.containsKey(key) || !otherParams.containsKey(key)) continue;
            this.params.put(key, otherParams.get(key));
        }
        for (String key : complexParams) {
            if (this.params.containsKey(key) || !otherParams.containsKey(key)) continue;
            this.params.put(key, otherParams.get(key));
        }
    }
}

