/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.util;

import java.io.FileWriter;
import java.io.IOException;
import org.cytoscape.analyzer.util.ComplexParam;
import org.cytoscape.analyzer.util.LineReader;

public class LongHistogram
implements ComplexParam {
    private long[][] bins;

    public LongHistogram(String[] aArgs, LineReader aReader) throws IOException {
        this.load(aArgs, aReader);
    }

    public LongHistogram(long[][] aBins, int aFromIndex, int aToIndex) {
        if (aBins[0].length != aBins[1].length || aFromIndex > aToIndex) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int binCount = aToIndex - aFromIndex + 1;
        this.bins = new long[2][binCount];
        for (int i = 0; i < binCount; ++i) {
            this.bins[0][i] = aBins[0][i + aFromIndex];
            this.bins[1][i] = aBins[1][i + aFromIndex];
        }
    }

    public LongHistogram(long[] aData, int aFromIndex, int aToIndex) {
        if (aFromIndex > aToIndex) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int binCount = aToIndex - aFromIndex + 1;
        this.bins = new long[2][binCount];
        for (int i = 0; i < binCount; ++i) {
            this.bins[0][i] = i + aFromIndex;
            this.bins[1][i] = aData[i + aFromIndex];
        }
    }

    public int getBinCount() {
        return this.bins[0].length;
    }

    public long[] getObservedRange() {
        return new long[]{this.bins[0][0], this.bins[0][this.bins[0].length - 1]};
    }

    public long[][] getBins() {
        return this.bins;
    }

    @Override
    public void load(String[] aArgs, LineReader aReader) throws IOException {
        int binCount = Integer.parseInt(aArgs[0]);
        this.bins = new long[2][binCount];
        for (int i = 0; i < binCount; ++i) {
            String[] values = aReader.readLine().split("\\t");
            this.bins[0][i] = Integer.parseInt(values[0]);
            this.bins[1][i] = Integer.parseInt(values[1]);
        }
    }

    @Override
    public void save(FileWriter aWriter, boolean aSaveArgs) throws IOException {
        int binCount = this.bins[0].length;
        if (aSaveArgs) {
            aWriter.write(String.valueOf(binCount) + "\n");
        }
        for (int i = 0; i < binCount; ++i) {
            aWriter.write(String.valueOf(this.bins[0][i]) + "\t" + String.valueOf(this.bins[1][i]) + "\n");
        }
    }
}

