/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.util;

import java.awt.geom.Point2D;
import org.cytoscape.analyzer.util.LongHistogram;
import org.cytoscape.analyzer.util.Points2D;

public class LogBinDistribution {
    private static final int INITIAL_SIZE = 8;
    private static final double LOGBASE = 10.0;
    private long[][] bins = new long[2][8];
    private long maxObservation;

    public LogBinDistribution() {
        this.bins[0][0] = 0L;
        int power = 1;
        for (int i = 1; i < 8; ++i) {
            this.bins[0][i] = power;
            power = (int)((double)power * 10.0);
        }
        this.maxObservation = 0L;
    }

    public long getMaxObservation() {
        return this.maxObservation;
    }

    public LongHistogram createHistogram() {
        return new LongHistogram(this.bins, 0, LogBinDistribution.getBinIndex(this.maxObservation));
    }

    public Points2D createPoints2D() {
        int size = LogBinDistribution.getBinIndex(this.maxObservation) + 1;
        Point2D.Double[] points = new Point2D.Double[size];
        for (int i = 0; i < size; ++i) {
            points[i] = new Point2D.Double(this.bins[0][i], this.bins[1][i]);
        }
        return new Points2D(points);
    }

    public void addObservation(long aObservation) {
        int binIndex = LogBinDistribution.getBinIndex(aObservation);
        if (binIndex >= this.bins[0].length) {
            this.ensureCapacity(binIndex + 1);
        }
        if (this.maxObservation < aObservation) {
            this.maxObservation = aObservation;
        }
        long[] lArray = this.bins[1];
        int n = binIndex;
        lArray[n] = lArray[n] + 1L;
    }

    private void ensureCapacity(long aCapacity) {
        int currentCap;
        int newCap = currentCap = this.bins[0].length;
        while ((long)newCap < aCapacity) {
            newCap += 2;
        }
        if (newCap != currentCap) {
            long[][] newDist = new long[2][newCap];
            System.arraycopy(this.bins[0], 0, newDist[0], 0, currentCap);
            System.arraycopy(this.bins[1], 0, newDist[1], 0, currentCap);
            this.bins = newDist;
            for (int i = currentCap; i < newCap; ++i) {
                this.bins[0][i] = this.bins[0][i - 1] * 10L;
            }
        }
    }

    private static int getBinIndex(long aObservation) {
        return aObservation != 0L ? (int)(Math.log(aObservation) / Math.log(10.0)) + 1 : 0;
    }
}

