/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.tasks;

import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import org.cytoscape.analyzer.tasks.NetAnalyzerAction;
import org.cytoscape.analyzer.tasks.NetModificationDialog;
import org.cytoscape.analyzer.tasks.Utils;
import org.cytoscape.analyzer.util.CyNetworkUtils;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveSelfLoopsAction
extends NetAnalyzerAction {
    private static final long serialVersionUID = -7465036491341908005L;
    private static final Logger logger = LoggerFactory.getLogger(RemoveSelfLoopsAction.class);
    private final CyNetworkManager netMgr;
    CySwingApplication desktop;
    public static String DI_REMOVESL = "Remove self-loops from the following networks:";
    public static String AC_REMSELFLOOPS = "Remove Self-Loops...";
    public static String SM_REMSELFLOOPS = " self-loop(s) removed from ";
    public static String SM_LOGERROR = "NetworkAnalyzer - Internal Error";
    public static String DT_REMSELFLOOPS = "Remove Self-Loops";

    public RemoveSelfLoopsAction(CyApplicationManager appMgr, CySwingApplication swingApp, CyNetworkManager netMgr) {
        super(AC_REMSELFLOOPS, appMgr);
        this.setPreferredMenu("Edit");
        this.setMenuGravity(4.2f);
        this.netMgr = netMgr;
        this.desktop = swingApp;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (!this.selectNetwork()) {
                return;
            }
            JFrame frame = this.desktop.getJFrame();
            String helpURL = null;
            NetModificationDialog d = new NetModificationDialog(frame, DT_REMSELFLOOPS, DI_REMOVESL, helpURL, this.netMgr);
            d.setVisible(true);
            CyNetwork[] networks = d.getSelectedNetworks();
            if (networks != null) {
                int size = networks.length;
                int[] removedLoops = new int[size];
                String[] networkNames = new String[size];
                for (int i = 0; i < size; ++i) {
                    CyNetwork currentNet = networks[i];
                    networkNames[i] = (String)currentNet.getRow((CyIdentifiable)currentNet).get("name", String.class);
                    removedLoops[i] = CyNetworkUtils.removeSelfLoops(currentNet);
                }
                String r = this.constructReport(removedLoops, SM_REMSELFLOOPS, networkNames);
                Utils.showInfoBox(frame, DT_REMSELFLOOPS, r);
            }
        }
        catch (Exception ex) {
            logger.error(SM_LOGERROR, (Throwable)ex);
        }
    }

    private String constructReport(int[] removedLoops, String s, String[] networkNames) {
        return null;
    }
}

